/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.lar;

import com.liferay.portal.kernel.lar.DataLevel;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.PortletDataHandlerBoolean;
import com.liferay.portal.kernel.lar.PortletDataHandlerControl;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.StagedModel;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.model.DDMTemplate;
import com.liferay.portlet.dynamicdatamapping.service.DDMTemplateLocalServiceUtil;
import com.liferay.portlet.journal.lar.JournalPortletDataHandler;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.service.JournalArticleLocalServiceUtil;
import com.liferay.portlet.journal.service.JournalContentSearchLocalServiceUtil;
import java.util.Map;
import javax.portlet.PortletPreferences;

public class JournalContentPortletDataHandler
extends JournalPortletDataHandler {
    private static Log _log = LogFactoryUtil.getLog(JournalContentPortletDataHandler.class);

    public JournalContentPortletDataHandler() {
        this.setDataLevel(DataLevel.PORTLET_INSTANCE);
        this.setDataPortletPreferences(new String[]{"articleId", "ddmTemplateKey", "groupId"});
        this.setExportControls(new PortletDataHandlerControl[]{new PortletDataHandlerBoolean(null, "selected-web-content", true, true, null, JournalArticle.class.getName())});
        this.setPublishToLiveByDefault(PropsValues.JOURNAL_CONTENT_PUBLISH_TO_LIVE_BY_DEFAULT);
    }

    @Override
    protected PortletPreferences doDeleteData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        if (portletPreferences == null) {
            return portletPreferences;
        }
        portletPreferences.setValue("articleId", "");
        portletPreferences.setValue("ddmTemplateKey", "");
        portletPreferences.setValue("groupId", "");
        return portletPreferences;
    }

    protected PortletPreferences doProcessExportPortletPreferences(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        portletDataContext.addPortletPermissions("com.liferay.portlet.journal");
        String articleId = portletPreferences.getValue("articleId", null);
        if (articleId == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("No article id found in preferences of portlet " + portletId));
            }
            return portletPreferences;
        }
        long articleGroupId = GetterUtil.getLong((String)portletPreferences.getValue("groupId", ""));
        if (articleGroupId <= 0L) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("No group id found in preferences of portlet " + portletId));
            }
            return portletPreferences;
        }
        long previousScopeGroupId = portletDataContext.getScopeGroupId();
        if (articleGroupId != previousScopeGroupId) {
            portletDataContext.setScopeGroupId(articleGroupId);
        }
        JournalArticle article = null;
        article = JournalArticleLocalServiceUtil.fetchLatestArticle((long)articleGroupId, (String)articleId, (int)0);
        if (article == null) {
            article = JournalArticleLocalServiceUtil.fetchLatestArticle((long)articleGroupId, (String)articleId, (int)3);
        }
        if (article == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Portlet " + portletId + " refers to an invalid article ID " + articleId));
            }
            portletDataContext.setScopeGroupId(previousScopeGroupId);
            return portletPreferences;
        }
        StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (String)portletId, (StagedModel)article);
        String defaultTemplateId = article.getTemplateId();
        String preferenceTemplateId = portletPreferences.getValue("ddmTemplateKey", null);
        if (Validator.isNotNull((String)defaultTemplateId) && Validator.isNotNull((String)preferenceTemplateId) && !defaultTemplateId.equals(preferenceTemplateId)) {
            DDMTemplate ddmTemplate = DDMTemplateLocalServiceUtil.getTemplate((long)article.getGroupId(), (long)PortalUtil.getClassNameId(DDMStructure.class), (String)preferenceTemplateId, (boolean)true);
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)article, (StagedModel)ddmTemplate, (String)"strong");
        }
        portletDataContext.setScopeGroupId(previousScopeGroupId);
        return portletPreferences;
    }

    protected PortletPreferences doProcessImportPortletPreferences(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        portletDataContext.importPortletPermissions("com.liferay.portlet.journal");
        long previousScopeGroupId = portletDataContext.getScopeGroupId();
        long importGroupId = GetterUtil.getLong((String)portletPreferences.getValue("groupId", null));
        if (importGroupId == portletDataContext.getSourceGroupId()) {
            portletDataContext.setScopeGroupId(portletDataContext.getGroupId());
        }
        if (importGroupId == portletDataContext.getSourceCompanyGroupId()) {
            portletDataContext.setScopeGroupId(portletDataContext.getCompanyGroupId());
        }
        StagedModelDataHandlerUtil.importReferenceStagedModels((PortletDataContext)portletDataContext, DDMStructure.class);
        StagedModelDataHandlerUtil.importReferenceStagedModels((PortletDataContext)portletDataContext, DDMTemplate.class);
        StagedModelDataHandlerUtil.importReferenceStagedModels((PortletDataContext)portletDataContext, JournalArticle.class);
        String articleId = portletPreferences.getValue("articleId", null);
        if (Validator.isNotNull((String)articleId)) {
            Map articleIds = portletDataContext.getNewPrimaryKeysMap(JournalArticle.class + ".articleId");
            articleId = MapUtil.getString((Map)articleIds, (String)articleId, (String)articleId);
            portletPreferences.setValue("articleId", articleId);
            String importedArticleGroupId = String.valueOf(portletDataContext.getScopeGroupId());
            portletPreferences.setValue("groupId", importedArticleGroupId);
            Layout layout = LayoutLocalServiceUtil.getLayout((long)portletDataContext.getPlid());
            JournalContentSearchLocalServiceUtil.updateContentSearch((long)portletDataContext.getScopeGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getLayoutId(), (String)portletId, (String)articleId, (boolean)true);
        } else {
            portletPreferences.setValue("groupId", "");
            portletPreferences.setValue("articleId", "");
        }
        String ddmTemplateKey = portletPreferences.getValue("ddmTemplateKey", null);
        if (Validator.isNotNull((String)ddmTemplateKey)) {
            Map ddmTemplateKeys = portletDataContext.getNewPrimaryKeysMap(DDMTemplate.class + ".ddmTemplateKey");
            ddmTemplateKey = MapUtil.getString((Map)ddmTemplateKeys, (String)ddmTemplateKey, (String)ddmTemplateKey);
            portletPreferences.setValue("ddmTemplateKey", ddmTemplateKey);
        } else {
            portletPreferences.setValue("ddmTemplateKey", "");
        }
        portletDataContext.setScopeGroupId(previousScopeGroupId);
        return portletPreferences;
    }
}

