/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.parsers.bbcode.BBCodeTranslatorUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.messageboards.LockedThreadException;
import com.liferay.portlet.messageboards.model.MBCategory;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.model.MBMessageConstants;
import com.liferay.portlet.messageboards.model.MBMessageDisplay;
import com.liferay.portlet.messageboards.model.MBThread;
import com.liferay.portlet.messageboards.service.base.MBMessageServiceBaseImpl;
import com.liferay.portlet.messageboards.service.permission.MBCategoryPermission;
import com.liferay.portlet.messageboards.service.permission.MBDiscussionPermission;
import com.liferay.portlet.messageboards.service.permission.MBMessagePermission;
import com.liferay.portlet.messageboards.util.MBUtil;
import com.liferay.portlet.messageboards.util.comparator.MessageCreateDateComparator;
import com.liferay.util.RSSUtil;
import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndContentImpl;
import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndFeedImpl;
import com.sun.syndication.feed.synd.SyndLinkImpl;
import com.sun.syndication.io.FeedException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

public class MBMessageServiceImpl
extends MBMessageServiceBaseImpl {
    public MBMessage addDiscussionMessage(long groupId, String className, long classPK, String permissionClassName, long permissionClassPK, long permissionOwnerId, long threadId, long parentMessageId, String subject, String body, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.getGuestOrUser();
        MBDiscussionPermission.check(this.getPermissionChecker(), user.getCompanyId(), serviceContext.getScopeGroupId(), permissionClassName, permissionClassPK, permissionOwnerId, "ADD_DISCUSSION");
        return this.mbMessageLocalService.addDiscussionMessage(user.getUserId(), null, groupId, className, classPK, threadId, parentMessageId, subject, body, serviceContext);
    }

    public MBMessage addMessage(long groupId, long categoryId, long threadId, long parentMessageId, String subject, String body, String format, List<ObjectValuePair<String, InputStream>> inputStreamOVPs, boolean anonymous, double priority, boolean allowPingbacks, ServiceContext serviceContext) throws PortalException, SystemException {
        return this.addMessage(parentMessageId, subject, body, format, inputStreamOVPs, anonymous, priority, allowPingbacks, serviceContext);
    }

    public MBMessage addMessage(long groupId, long categoryId, String subject, String body, String format, List<ObjectValuePair<String, InputStream>> inputStreamOVPs, boolean anonymous, double priority, boolean allowPingbacks, ServiceContext serviceContext) throws PortalException, SystemException {
        MBCategoryPermission.check(this.getPermissionChecker(), groupId, categoryId, "ADD_MESSAGE");
        if (!MBCategoryPermission.contains(this.getPermissionChecker(), groupId, categoryId, "ADD_FILE")) {
            inputStreamOVPs = Collections.emptyList();
        }
        if (!MBCategoryPermission.contains(this.getPermissionChecker(), groupId, categoryId, "UPDATE_THREAD_PRIORITY")) {
            priority = -1.0;
        }
        return this.mbMessageLocalService.addMessage(this.getGuestOrUserId(), null, groupId, categoryId, subject, body, format, inputStreamOVPs, anonymous, priority, allowPingbacks, serviceContext);
    }

    public MBMessage addMessage(long categoryId, String subject, String body, ServiceContext serviceContext) throws PortalException, SystemException {
        MBCategory category = this.mbCategoryPersistence.findByPrimaryKey(categoryId);
        List<ObjectValuePair<String, InputStream>> inputStreamOVPs = Collections.emptyList();
        return this.addMessage(category.getGroupId(), categoryId, subject, body, MBMessageConstants.DEFAULT_FORMAT, inputStreamOVPs, false, 0.0, false, serviceContext);
    }

    public MBMessage addMessage(long parentMessageId, String subject, String body, String format, List<ObjectValuePair<String, InputStream>> inputStreamOVPs, boolean anonymous, double priority, boolean allowPingbacks, ServiceContext serviceContext) throws PortalException, SystemException {
        MBMessage parentMessage = this.mbMessagePersistence.findByPrimaryKey(parentMessageId);
        this.checkReplyToPermission(parentMessage.getGroupId(), parentMessage.getCategoryId(), parentMessageId);
        boolean preview = ParamUtil.getBoolean((ServiceContext)serviceContext, (String)"preview");
        int workFlowAction = serviceContext.getWorkflowAction();
        if (workFlowAction == 2 && !preview && !serviceContext.isSignedIn()) {
            MBMessagePermission.check(this.getPermissionChecker(), parentMessageId, "UPDATE");
        }
        if (this.lockLocalService.isLocked(MBThread.class.getName(), parentMessage.getThreadId())) {
            throw new LockedThreadException();
        }
        if (!MBCategoryPermission.contains(this.getPermissionChecker(), parentMessage.getGroupId(), parentMessage.getCategoryId(), "ADD_FILE")) {
            inputStreamOVPs = Collections.emptyList();
        }
        if (!MBCategoryPermission.contains(this.getPermissionChecker(), parentMessage.getGroupId(), parentMessage.getCategoryId(), "UPDATE_THREAD_PRIORITY")) {
            priority = -1.0;
        }
        return this.mbMessageLocalService.addMessage(this.getGuestOrUserId(), null, parentMessage.getGroupId(), parentMessage.getCategoryId(), parentMessage.getThreadId(), parentMessageId, subject, body, format, inputStreamOVPs, anonymous, priority, allowPingbacks, serviceContext);
    }

    public void deleteDiscussionMessage(long groupId, String className, long classPK, String permissionClassName, long permissionClassPK, long permissionOwnerId, long messageId) throws PortalException, SystemException {
        User user = this.getUser();
        MBDiscussionPermission.check(this.getPermissionChecker(), user.getCompanyId(), groupId, permissionClassName, permissionClassPK, messageId, permissionOwnerId, "DELETE_DISCUSSION");
        this.mbMessageLocalService.deleteDiscussionMessage(messageId);
    }

    public void deleteMessage(long messageId) throws PortalException, SystemException {
        MBMessagePermission.check(this.getPermissionChecker(), messageId, "DELETE");
        this.mbMessageLocalService.deleteMessage(messageId);
    }

    public void deleteMessageAttachments(long messageId) throws PortalException, SystemException {
        MBMessagePermission.check(this.getPermissionChecker(), messageId, "DELETE");
        this.mbMessageLocalService.deleteMessageAttachments(messageId);
    }

    public List<MBMessage> getCategoryMessages(long groupId, long categoryId, int status, int start, int end) throws PortalException, SystemException {
        ArrayList<MBMessage> messages = new ArrayList<MBMessage>();
        List categoryMessages = this.mbMessageLocalService.getCategoryMessages(groupId, categoryId, status, start, end);
        for (MBMessage message : categoryMessages) {
            if (!MBMessagePermission.contains(this.getPermissionChecker(), message, "VIEW")) continue;
            messages.add(message);
        }
        return messages;
    }

    public int getCategoryMessagesCount(long groupId, long categoryId, int status) throws SystemException {
        return this.mbMessageLocalService.getCategoryMessagesCount(groupId, categoryId, status);
    }

    public String getCategoryMessagesRSS(long groupId, long categoryId, int status, int max, String type, double version, String displayStyle, String feedURL, String entryURL, ThemeDisplay themeDisplay) throws PortalException, SystemException {
        String name = "";
        String description = "";
        MBCategory category = this.mbCategoryLocalService.fetchMBCategory(categoryId);
        if (category == null) {
            Group group = this.groupLocalService.getGroup(categoryId);
            groupId = group.getGroupId();
            categoryId = 0L;
            name = group.getDescriptiveName();
            description = group.getDescription();
        } else {
            groupId = category.getGroupId();
            name = category.getName();
            description = category.getDescription();
        }
        ArrayList<MBMessage> messages = new ArrayList<MBMessage>();
        int lastIntervalStart = 0;
        boolean listNotExhausted = true;
        MessageCreateDateComparator comparator = new MessageCreateDateComparator(false);
        block0: while (messages.size() < max && listNotExhausted) {
            List messageList = this.mbMessageLocalService.getCategoryMessages(groupId, categoryId, status, lastIntervalStart, lastIntervalStart + max, (OrderByComparator)comparator);
            lastIntervalStart += max;
            listNotExhausted = messageList.size() == max;
            for (MBMessage message : messageList) {
                if (messages.size() >= max) continue block0;
                if (!MBMessagePermission.contains(this.getPermissionChecker(), message, "VIEW")) continue;
                messages.add(message);
            }
        }
        return this.exportToRSS(name, description, type, version, displayStyle, feedURL, entryURL, messages, themeDisplay);
    }

    public String getCompanyMessagesRSS(long companyId, int status, int max, String type, double version, String displayStyle, String feedURL, String entryURL, ThemeDisplay themeDisplay) throws PortalException, SystemException {
        Company company = this.companyPersistence.findByPrimaryKey(companyId);
        String name = company.getName();
        String description = company.getName();
        ArrayList<MBMessage> messages = new ArrayList<MBMessage>();
        int lastIntervalStart = 0;
        boolean listNotExhausted = true;
        MessageCreateDateComparator comparator = new MessageCreateDateComparator(false);
        block0: while (messages.size() < max && listNotExhausted) {
            List messageList = this.mbMessageLocalService.getCompanyMessages(companyId, status, lastIntervalStart, lastIntervalStart + max, (OrderByComparator)comparator);
            lastIntervalStart += max;
            listNotExhausted = messageList.size() == max;
            for (MBMessage message : messageList) {
                if (messages.size() >= max) continue block0;
                if (!MBMessagePermission.contains(this.getPermissionChecker(), message, "VIEW")) continue;
                messages.add(message);
            }
        }
        return this.exportToRSS(name, description, type, version, displayStyle, feedURL, entryURL, messages, themeDisplay);
    }

    public int getGroupMessagesCount(long groupId, int status) throws SystemException {
        if (status == -1) {
            return this.mbMessagePersistence.filterCountByGroupId(groupId);
        }
        return this.mbMessagePersistence.filterCountByG_S(groupId, status);
    }

    public String getGroupMessagesRSS(long groupId, int status, int max, String type, double version, String displayStyle, String feedURL, String entryURL, ThemeDisplay themeDisplay) throws PortalException, SystemException {
        String name = "";
        String description = "";
        ArrayList<MBMessage> messages = new ArrayList<MBMessage>();
        int lastIntervalStart = 0;
        boolean listNotExhausted = true;
        MessageCreateDateComparator comparator = new MessageCreateDateComparator(false);
        block0: while (messages.size() < max && listNotExhausted) {
            List messageList = this.mbMessageLocalService.getGroupMessages(groupId, status, lastIntervalStart, lastIntervalStart + max, (OrderByComparator)comparator);
            lastIntervalStart += max;
            listNotExhausted = messageList.size() == max;
            for (MBMessage message : messageList) {
                if (messages.size() >= max) continue block0;
                if (!MBMessagePermission.contains(this.getPermissionChecker(), message, "VIEW")) continue;
                messages.add(message);
            }
        }
        if (messages.size() > 0) {
            MBMessage message = (MBMessage)messages.get(messages.size() - 1);
            name = message.getSubject();
            description = message.getSubject();
        }
        return this.exportToRSS(name, description, type, version, displayStyle, feedURL, entryURL, messages, themeDisplay);
    }

    public String getGroupMessagesRSS(long groupId, long userId, int status, int max, String type, double version, String displayStyle, String feedURL, String entryURL, ThemeDisplay themeDisplay) throws PortalException, SystemException {
        String name = "";
        String description = "";
        ArrayList<MBMessage> messages = new ArrayList<MBMessage>();
        int lastIntervalStart = 0;
        boolean listNotExhausted = true;
        MessageCreateDateComparator comparator = new MessageCreateDateComparator(false);
        block0: while (messages.size() < max && listNotExhausted) {
            List messageList = this.mbMessageLocalService.getGroupMessages(groupId, userId, status, lastIntervalStart, lastIntervalStart + max, (OrderByComparator)comparator);
            lastIntervalStart += max;
            listNotExhausted = messageList.size() == max;
            for (MBMessage message : messageList) {
                if (messages.size() >= max) continue block0;
                if (!MBMessagePermission.contains(this.getPermissionChecker(), message, "VIEW")) continue;
                messages.add(message);
            }
        }
        if (messages.size() > 0) {
            MBMessage message = (MBMessage)messages.get(messages.size() - 1);
            name = message.getSubject();
            description = message.getSubject();
        }
        return this.exportToRSS(name, description, type, version, displayStyle, feedURL, entryURL, messages, themeDisplay);
    }

    public MBMessage getMessage(long messageId) throws PortalException, SystemException {
        MBMessagePermission.check(this.getPermissionChecker(), messageId, "VIEW");
        return this.mbMessageLocalService.getMessage(messageId);
    }

    public MBMessageDisplay getMessageDisplay(long messageId, int status, String threadView, boolean includePrevAndNext) throws PortalException, SystemException {
        MBMessagePermission.check(this.getPermissionChecker(), messageId, "VIEW");
        return this.mbMessageLocalService.getMessageDisplay(this.getGuestOrUserId(), messageId, status, threadView, includePrevAndNext);
    }

    public int getThreadAnswersCount(long groupId, long categoryId, long threadId) throws SystemException {
        return this.mbMessagePersistence.filterCountByG_C_T_A(groupId, categoryId, threadId, true);
    }

    public List<MBMessage> getThreadMessages(long groupId, long categoryId, long threadId, int status, int start, int end) throws SystemException {
        if (status == -1) {
            return this.mbMessagePersistence.filterFindByG_C_T(groupId, categoryId, threadId, start, end);
        }
        return this.mbMessagePersistence.filterFindByG_C_T_S(groupId, categoryId, threadId, status, start, end);
    }

    public int getThreadMessagesCount(long groupId, long categoryId, long threadId, int status) throws SystemException {
        if (status == -1) {
            return this.mbMessagePersistence.filterCountByG_C_T(groupId, categoryId, threadId);
        }
        return this.mbMessagePersistence.filterCountByG_C_T_S(groupId, categoryId, threadId, status);
    }

    public String getThreadMessagesRSS(long threadId, int status, int max, String type, double version, String displayStyle, String feedURL, String entryURL, ThemeDisplay themeDisplay) throws PortalException, SystemException {
        String name = "";
        String description = "";
        ArrayList<MBMessage> messages = new ArrayList<MBMessage>();
        MBThread thread = this.mbThreadLocalService.getThread(threadId);
        if (MBMessagePermission.contains(this.getPermissionChecker(), thread.getRootMessageId(), "VIEW")) {
            MessageCreateDateComparator comparator = new MessageCreateDateComparator(false);
            List threadMessages = this.mbMessageLocalService.getThreadMessages(threadId, status, (Comparator)comparator);
            for (MBMessage message : threadMessages) {
                if (messages.size() >= max) break;
                if (!MBMessagePermission.contains(this.getPermissionChecker(), message, "VIEW")) continue;
                messages.add(message);
            }
            if (messages.size() > 0) {
                MBMessage message;
                message = (MBMessage)messages.get(messages.size() - 1);
                name = message.getSubject();
                description = message.getSubject();
            }
        }
        return this.exportToRSS(name, description, type, version, displayStyle, feedURL, entryURL, messages, themeDisplay);
    }

    public void restoreMessageAttachmentFromTrash(long messageId, String fileName) throws PortalException, SystemException {
        MBMessage message = this.mbMessagePersistence.findByPrimaryKey(messageId);
        MBCategoryPermission.check(this.getPermissionChecker(), message.getGroupId(), message.getCategoryId(), "ADD_FILE");
        this.mbMessageLocalService.restoreMessageAttachmentFromTrash(this.getUserId(), messageId, fileName);
    }

    public void subscribeMessage(long messageId) throws PortalException, SystemException {
        MBMessagePermission.check(this.getPermissionChecker(), messageId, "SUBSCRIBE");
        this.mbMessageLocalService.subscribeMessage(this.getUserId(), messageId);
    }

    public void unsubscribeMessage(long messageId) throws PortalException, SystemException {
        MBMessagePermission.check(this.getPermissionChecker(), messageId, "SUBSCRIBE");
        this.mbMessageLocalService.unsubscribeMessage(this.getUserId(), messageId);
    }

    public void updateAnswer(long messageId, boolean answer, boolean cascade) throws PortalException, SystemException {
        this.mbMessageLocalService.updateAnswer(messageId, answer, cascade);
    }

    public MBMessage updateDiscussionMessage(String className, long classPK, String permissionClassName, long permissionClassPK, long permissionOwnerId, long messageId, String subject, String body, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.getUser();
        MBDiscussionPermission.check(this.getPermissionChecker(), user.getCompanyId(), serviceContext.getScopeGroupId(), permissionClassName, permissionClassPK, messageId, permissionOwnerId, "UPDATE_DISCUSSION");
        return this.mbMessageLocalService.updateDiscussionMessage(this.getUserId(), messageId, className, classPK, subject, body, serviceContext);
    }

    public MBMessage updateMessage(long messageId, String subject, String body, List<ObjectValuePair<String, InputStream>> inputStreamOVPs, List<String> existingFiles, double priority, boolean allowPingbacks, ServiceContext serviceContext) throws PortalException, SystemException {
        MBMessage message = this.mbMessagePersistence.findByPrimaryKey(messageId);
        boolean preview = ParamUtil.getBoolean((ServiceContext)serviceContext, (String)"preview");
        if (preview && MBMessagePermission.contains(this.getPermissionChecker(), message, "UPDATE")) {
            this.checkReplyToPermission(message.getGroupId(), message.getCategoryId(), message.getParentMessageId());
        } else {
            MBMessagePermission.check(this.getPermissionChecker(), messageId, "UPDATE");
        }
        if (this.lockLocalService.isLocked(MBThread.class.getName(), message.getThreadId())) {
            throw new LockedThreadException();
        }
        if (!MBCategoryPermission.contains(this.getPermissionChecker(), message.getGroupId(), message.getCategoryId(), "ADD_FILE")) {
            inputStreamOVPs = Collections.emptyList();
        }
        if (!MBCategoryPermission.contains(this.getPermissionChecker(), message.getGroupId(), message.getCategoryId(), "UPDATE_THREAD_PRIORITY")) {
            MBThread thread = this.mbThreadLocalService.getThread(message.getThreadId());
            priority = thread.getPriority();
        }
        return this.mbMessageLocalService.updateMessage(this.getGuestOrUserId(), messageId, subject, body, inputStreamOVPs, existingFiles, priority, allowPingbacks, serviceContext);
    }

    protected void checkReplyToPermission(long groupId, long categoryId, long parentMessageId) throws PortalException, SystemException {
        if (parentMessageId > 0L) {
            if (MBCategoryPermission.contains(this.getPermissionChecker(), groupId, categoryId, "ADD_MESSAGE")) {
                return;
            }
            if (!MBCategoryPermission.contains(this.getPermissionChecker(), groupId, categoryId, "REPLY_TO_MESSAGE")) {
                throw new PrincipalException();
            }
        } else {
            MBCategoryPermission.check(this.getPermissionChecker(), groupId, categoryId, "ADD_MESSAGE");
        }
    }

    protected String exportToRSS(String name, String description, String type, double version, String displayStyle, String feedURL, String entryURL, List<MBMessage> messages, ThemeDisplay themeDisplay) throws SystemException {
        SyndFeedImpl syndFeed = new SyndFeedImpl();
        syndFeed.setDescription(description);
        ArrayList<SyndEntryImpl> syndEntries = new ArrayList<SyndEntryImpl>();
        syndFeed.setEntries(syndEntries);
        for (MBMessage message : messages) {
            SyndEntryImpl syndEntry = new SyndEntryImpl();
            if (!message.isAnonymous()) {
                String author = PortalUtil.getUserName((BaseModel)message);
                syndEntry.setAuthor(author);
            }
            SyndContentImpl syndContent = new SyndContentImpl();
            syndContent.setType("html");
            String value = null;
            if (displayStyle.equals("abstract")) {
                value = StringUtil.shorten((String)HtmlUtil.extractText((String)message.getBody()), (int)PropsValues.MESSAGE_BOARDS_RSS_ABSTRACT_LENGTH, (String)"");
            } else if (displayStyle.equals("title")) {
                value = "";
            } else if (message.isFormatBBCode()) {
                value = BBCodeTranslatorUtil.getHTML((String)message.getBody());
                value = MBUtil.replaceMessageBodyPaths(themeDisplay, value);
            } else {
                value = message.getBody();
            }
            syndContent.setValue(value);
            syndEntry.setDescription((SyndContent)syndContent);
            syndEntry.setLink(String.valueOf(entryURL) + "&messageId=" + message.getMessageId());
            syndEntry.setPublishedDate(message.getCreateDate());
            syndEntry.setTitle(message.getSubject());
            syndEntry.setUpdatedDate(message.getModifiedDate());
            syndEntry.setUri(syndEntry.getLink());
            syndEntries.add(syndEntry);
        }
        syndFeed.setFeedType(RSSUtil.getFeedType((String)type, (double)version));
        ArrayList<SyndLinkImpl> syndLinks = new ArrayList<SyndLinkImpl>();
        syndFeed.setLinks(syndLinks);
        SyndLinkImpl selfSyndLink = new SyndLinkImpl();
        syndLinks.add(selfSyndLink);
        selfSyndLink.setHref(feedURL);
        selfSyndLink.setRel("self");
        syndFeed.setPublishedDate(new Date());
        syndFeed.setTitle(name);
        syndFeed.setUri(feedURL);
        try {
            return RSSUtil.export((SyndFeed)syndFeed);
        }
        catch (FeedException fe) {
            throw new SystemException((Throwable)fe);
        }
    }
}

