/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.util;

import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.parsers.bbcode.BBCodeTranslatorUtil;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.BooleanQueryFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.persistence.GroupActionableDynamicQuery;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.messageboards.NoSuchDiscussionException;
import com.liferay.portlet.messageboards.model.MBCategory;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.service.MBCategoryServiceUtil;
import com.liferay.portlet.messageboards.service.MBDiscussionLocalServiceUtil;
import com.liferay.portlet.messageboards.service.MBMessageLocalServiceUtil;
import com.liferay.portlet.messageboards.service.permission.MBMessagePermission;
import com.liferay.portlet.messageboards.service.persistence.MBCategoryActionableDynamicQuery;
import com.liferay.portlet.messageboards.service.persistence.MBMessageActionableDynamicQuery;
import com.liferay.portlet.messageboards.util.MBMessageAttachmentsUtil;
import java.util.List;
import java.util.Locale;
import javax.portlet.PortletURL;

public class MBMessageIndexer
extends BaseIndexer {
    public static final String[] CLASS_NAMES = new String[]{MBMessage.class.getName()};
    public static final String PORTLET_ID = "19";
    private static Log _log = LogFactoryUtil.getLog(MBMessageIndexer.class);

    public MBMessageIndexer() {
        this.setFilterSearch(true);
        this.setPermissionAware(true);
    }

    public void addRelatedEntryFields(Document document, Object obj) throws Exception {
        DLFileEntry dlFileEntry = (DLFileEntry)obj;
        MBMessage message = null;
        try {
            message = MBMessageAttachmentsUtil.getMessage(dlFileEntry.getFileEntryId());
        }
        catch (Exception exception) {
            return;
        }
        document.addKeyword("categoryId", message.getCategoryId());
        document.addKeyword("classNameId", PortalUtil.getClassNameId((String)MBMessage.class.getName()));
        document.addKeyword("classPK", message.getMessageId());
        document.addKeyword("relatedEntry", true);
        document.addKeyword("discussion", false);
        document.addKeyword("threadId", message.getThreadId());
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getPortletId() {
        return PORTLET_ID;
    }

    public boolean hasPermission(PermissionChecker permissionChecker, String entryClassName, long entryClassPK, String actionId) throws Exception {
        return MBMessagePermission.contains(permissionChecker, entryClassPK, "VIEW");
    }

    public void postProcessContextQuery(BooleanQuery contextQuery, SearchContext searchContext) throws Exception {
        long[] categoryIds;
        long threadId;
        this.addStatus(contextQuery, searchContext);
        boolean discussion = GetterUtil.getBoolean((Object)searchContext.getAttribute("discussion"), (boolean)false);
        contextQuery.addRequiredTerm("discussion", discussion);
        if (searchContext.isIncludeDiscussions()) {
            this.addRelatedClassNames(contextQuery, searchContext);
        }
        if ((threadId = GetterUtil.getLong((String)((String)((Object)searchContext.getAttribute("threadId"))))) > 0L) {
            contextQuery.addRequiredTerm("threadId", threadId);
        }
        if ((categoryIds = searchContext.getCategoryIds()) != null && categoryIds.length > 0 && categoryIds[0] != 0L) {
            BooleanQuery categoriesQuery = BooleanQueryFactoryUtil.create((SearchContext)searchContext);
            long[] lArray = categoryIds;
            int n = categoryIds.length;
            int n2 = 0;
            while (n2 < n) {
                block6: {
                    long categoryId = lArray[n2];
                    try {
                        MBCategoryServiceUtil.getCategory((long)categoryId);
                    }
                    catch (Exception exception) {
                        break block6;
                    }
                    categoriesQuery.addTerm("categoryId", categoryId);
                }
                ++n2;
            }
            contextQuery.add((Query)categoriesQuery, BooleanClauseOccur.MUST);
        }
    }

    protected void doDelete(Object obj) throws Exception {
        MBMessage message = (MBMessage)obj;
        this.deleteDocument(message.getCompanyId(), message.getMessageId());
    }

    protected Document doGetDocument(Object obj) throws Exception {
        Indexer indexer;
        MBMessage message = (MBMessage)obj;
        Document document = this.getBaseModelDocument(PORTLET_ID, (BaseModel)message);
        document.addKeyword("categoryId", message.getCategoryId());
        document.addText("content", this.processContent(message));
        document.addKeyword("rootEntryClassPK", message.getRootMessageId());
        document.addText("title", message.getSubject());
        if (message.isAnonymous()) {
            document.remove("userName");
        }
        try {
            MBDiscussionLocalServiceUtil.getThreadDiscussion((long)message.getThreadId());
            document.addKeyword("discussion", true);
        }
        catch (NoSuchDiscussionException noSuchDiscussionException) {
            document.addKeyword("discussion", false);
        }
        document.addKeyword("threadId", message.getThreadId());
        if (message.isDiscussion() && (indexer = IndexerRegistryUtil.getIndexer((String)message.getClassName())) != null) {
            indexer.addRelatedEntryFields(document, obj);
        }
        return document;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletURL portletURL) {
        String messageId = document.get("entryClassPK");
        portletURL.setParameter("struts_action", "/message_boards/view_message");
        portletURL.setParameter("messageId", messageId);
        Summary summary = this.createSummary(document, "title", "content");
        summary.setMaxContentLength(200);
        summary.setPortletURL(portletURL);
        return summary;
    }

    protected void doReindex(Object obj) throws Exception {
        MBMessage message = (MBMessage)obj;
        if (!message.isApproved() && !message.isInTrash()) {
            return;
        }
        if (message.isDiscussion() && message.isRoot()) {
            return;
        }
        Document document = this.getDocument(message);
        SearchEngineUtil.updateDocument((String)this.getSearchEngineId(), (long)message.getCompanyId(), (Document)document);
    }

    protected void doReindex(String className, long classPK) throws Exception {
        MBMessage message = MBMessageLocalServiceUtil.getMessage((long)classPK);
        this.doReindex(message);
        if (message.isRoot()) {
            List messages = MBMessageLocalServiceUtil.getThreadMessages((long)message.getThreadId(), (int)0);
            for (MBMessage curMessage : messages) {
                this.reindex(curMessage);
            }
        } else {
            this.reindex(message);
        }
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexCategories(companyId);
        this.reindexDiscussions(companyId);
        this.reindexRoot(companyId);
    }

    protected String getPortletId(SearchContext searchContext) {
        return PORTLET_ID;
    }

    protected String processContent(MBMessage message) {
        String content = message.getBody();
        try {
            if (message.isFormatBBCode()) {
                content = BBCodeTranslatorUtil.getHTML((String)content);
            }
        }
        catch (Exception e2) {
            _log.error((Object)("Could not parse message " + message.getMessageId() + ": " + e2.getMessage()));
        }
        content = HtmlUtil.extractText((String)content);
        return content;
    }

    protected void reindexCategories(final long companyId) throws PortalException, SystemException {
        MBCategoryActionableDynamicQuery actionableDynamicQuery = new MBCategoryActionableDynamicQuery(){

            protected void performAction(Object object) throws PortalException, SystemException {
                MBCategory category = (MBCategory)object;
                MBMessageIndexer.this.reindexMessages(companyId, category.getGroupId(), category.getCategoryId());
            }
        };
        actionableDynamicQuery.setCompanyId(companyId);
        actionableDynamicQuery.performActions();
    }

    protected void reindexDiscussions(final long companyId) throws PortalException, SystemException {
        GroupActionableDynamicQuery actionableDynamicQuery = new GroupActionableDynamicQuery(){

            protected void performAction(Object object) throws PortalException, SystemException {
                Group group = (Group)object;
                MBMessageIndexer.this.reindexMessages(companyId, group.getGroupId(), -1L);
            }
        };
        actionableDynamicQuery.setCompanyId(companyId);
        actionableDynamicQuery.performActions();
    }

    protected void reindexMessages(long companyId, long groupId, final long categoryId) throws PortalException, SystemException {
        MBMessageActionableDynamicQuery actionableDynamicQuery = new MBMessageActionableDynamicQuery(){

            protected void addCriteria(DynamicQuery dynamicQuery) {
                Property categoryIdProperty = PropertyFactoryUtil.forName((String)"categoryId");
                dynamicQuery.add(categoryIdProperty.eq((Object)categoryId));
                Property statusProperty = PropertyFactoryUtil.forName((String)"status");
                Object[] statuses = new Integer[]{0, 8};
                dynamicQuery.add(statusProperty.in(statuses));
            }

            protected void performAction(Object object) throws PortalException {
                MBMessage message = (MBMessage)object;
                if (message.isDiscussion() && message.isRoot()) {
                    return;
                }
                Document document = MBMessageIndexer.this.getDocument(message);
                this.addDocument(document);
            }
        };
        actionableDynamicQuery.setCompanyId(companyId);
        actionableDynamicQuery.setGroupId(groupId);
        actionableDynamicQuery.setSearchEngineId(this.getSearchEngineId());
        actionableDynamicQuery.performActions();
    }

    protected void reindexRoot(final long companyId) throws PortalException, SystemException {
        GroupActionableDynamicQuery actionableDynamicQuery = new GroupActionableDynamicQuery(){

            protected void performAction(Object object) throws PortalException, SystemException {
                Group group = (Group)object;
                MBMessageIndexer.this.reindexMessages(companyId, group.getGroupId(), 0L);
            }
        };
        actionableDynamicQuery.setCompanyId(companyId);
        actionableDynamicQuery.performActions();
    }
}

