/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.rolesadmin.lar;

import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.lar.BasePortletDataHandler;
import com.liferay.portal.kernel.lar.DataLevel;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.PortletDataHandlerBoolean;
import com.liferay.portal.kernel.lar.PortletDataHandlerControl;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.portal.kernel.lar.StagedModelType;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.Team;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.service.persistence.RoleExportActionableDynamicQuery;
import com.liferay.portal.util.PortalUtil;
import java.util.List;
import javax.portlet.PortletPreferences;

public class RolesAdminPortletDataHandler
extends BasePortletDataHandler {
    public static final String NAMESPACE = "roles_admin";

    public RolesAdminPortletDataHandler() {
        this.setDataLevel(DataLevel.PORTAL);
        this.setDeletionSystemEventStagedModelTypes(new StagedModelType[]{new StagedModelType(Role.class)});
        this.setExportControls(new PortletDataHandlerControl[]{new PortletDataHandlerBoolean(NAMESPACE, "roles", true, true, new PortletDataHandlerControl[]{new PortletDataHandlerBoolean(NAMESPACE, "system-roles", true, false)}, Role.class.getName())});
        this.setSupportsDataStrategyCopyAsNew(false);
    }

    protected PortletPreferences doDeleteData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        if (portletDataContext.addPrimaryKey(RolesAdminPortletDataHandler.class, "deleteData")) {
            return portletPreferences;
        }
        List roles = RoleLocalServiceUtil.getRoles((long)portletDataContext.getCompanyId());
        for (Role role : roles) {
            if (PortalUtil.isSystemRole((String)role.getName())) continue;
            RoleLocalServiceUtil.deleteRole((Role)role);
        }
        return portletPreferences;
    }

    protected String doExportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        portletDataContext.addPortalPermissions();
        Element rootElement = this.addExportDataRootElement(portletDataContext);
        rootElement.addAttribute("group-id", String.valueOf(portletDataContext.getScopeGroupId()));
        ActionableDynamicQuery actionableDynamicQuery = this.getRoleActionableDynamicQuery(portletDataContext, true);
        actionableDynamicQuery.performActions();
        return this.getExportDataRootElementString(rootElement);
    }

    protected PortletPreferences doImportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences, String data) throws Exception {
        portletDataContext.importPortalPermissions();
        Element rolesElement = portletDataContext.getImportDataGroupElement(Role.class);
        List roleElements = rolesElement.elements();
        for (Element roleElement : roleElements) {
            StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)roleElement);
        }
        return null;
    }

    protected void doPrepareManifestSummary(PortletDataContext portletDataContext, PortletPreferences portletPreferences) throws Exception {
        ActionableDynamicQuery actionableDynamicQuery = this.getRoleActionableDynamicQuery(portletDataContext, false);
        actionableDynamicQuery.performCount();
    }

    protected ActionableDynamicQuery getRoleActionableDynamicQuery(final PortletDataContext portletDataContext, final boolean export) throws SystemException {
        return new RoleExportActionableDynamicQuery(portletDataContext){

            protected void addCriteria(DynamicQuery dynamicQuery) {
                portletDataContext.addDateRangeCriteria(dynamicQuery, "modifiedDate");
                long classNameId = PortalUtil.getClassNameId(Team.class);
                Property classNameIdProperty = PropertyFactoryUtil.forName((String)"classNameId");
                dynamicQuery.add(classNameIdProperty.ne((Object)classNameId));
            }

            protected void performAction(Object object) throws PortalException, SystemException {
                if (!export) {
                    return;
                }
                Role role = (Role)object;
                long defaultUserId = UserLocalServiceUtil.getDefaultUserId((long)portletDataContext.getCompanyId());
                if (!portletDataContext.getBooleanParameter(RolesAdminPortletDataHandler.NAMESPACE, "system-roles") && role.getUserId() == defaultUserId) {
                    return;
                }
                super.performAction(object);
            }
        };
    }
}

