/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.rss.util;

import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.webcache.WebCacheException;
import com.liferay.portal.kernel.webcache.WebCacheItem;
import com.liferay.portal.security.lang.DoPrivilegedBean;
import com.liferay.portal.util.HttpImpl;
import com.liferay.portal.util.PropsValues;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.io.SyndFeedInput;
import com.sun.syndication.io.XmlReader;
import java.io.Reader;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.params.HttpClientParams;

public class RSSWebCacheItem
implements WebCacheItem {
    private static final long _REFRESH_TIME = 1200000L;
    private String _url;

    public RSSWebCacheItem(String url) {
        this._url = url;
    }

    public Object convert(String key) throws WebCacheException {
        SyndFeed feed = null;
        try {
            HttpImpl httpImpl = null;
            Http httpObject = HttpUtil.getHttp();
            if (httpObject instanceof DoPrivilegedBean) {
                DoPrivilegedBean doPrivilegedBean = (DoPrivilegedBean)httpObject;
                httpImpl = (HttpImpl)doPrivilegedBean.getActualBean();
            } else {
                httpImpl = (HttpImpl)httpObject;
            }
            HostConfiguration hostConfiguration = httpImpl.getHostConfiguration(this._url);
            HttpClient httpClient = httpImpl.getClient(hostConfiguration);
            httpImpl.proxifyState(httpClient.getState(), hostConfiguration);
            HttpClientParams httpClientParams = httpClient.getParams();
            httpClientParams.setConnectionManagerTimeout((long)PropsValues.RSS_CONNECTION_TIMEOUT);
            httpClientParams.setSoTimeout(PropsValues.RSS_CONNECTION_TIMEOUT);
            GetMethod getMethod = new GetMethod(httpImpl.encodeParameters(this._url));
            httpClient.executeMethod(hostConfiguration, (HttpMethod)getMethod);
            SyndFeedInput input = new SyndFeedInput();
            feed = input.build((Reader)new XmlReader(getMethod.getResponseBodyAsStream()));
        }
        catch (Exception e2) {
            throw new WebCacheException(String.valueOf(this._url) + " " + e2.toString());
        }
        return feed;
    }

    public long getRefreshTime() {
        return 1200000L;
    }
}

