/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.trash.util;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.trash.TrashHandlerRegistryUtil;
import com.liferay.portal.kernel.trash.TrashRenderer;
import com.liferay.portal.kernel.util.FastDateFormatFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.ContainerModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.permission.PortletPermissionUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.documentlibrary.store.DLStoreUtil;
import com.liferay.portlet.trash.model.TrashEntry;
import com.liferay.portlet.trash.model.impl.TrashEntryImpl;
import com.liferay.portlet.trash.service.TrashEntryLocalServiceUtil;
import com.liferay.portlet.trash.util.Trash;
import com.liferay.portlet.trash.util.TrashUtil;
import com.liferay.portlet.trash.util.comparator.EntryCreateDateComparator;
import com.liferay.portlet.trash.util.comparator.EntryTypeComparator;
import com.liferay.portlet.trash.util.comparator.EntryUserNameComparator;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

@DoPrivileged
public class TrashImpl
implements Trash {
    private static Log _log = LogFactoryUtil.getLog(TrashImpl.class);

    public void addBaseModelBreadcrumbEntries(HttpServletRequest request, String className, long classPK, PortletURL containerModelURL) throws PortalException, SystemException {
        this.addBreadcrumbEntries(request, className, classPK, "classPK", containerModelURL);
    }

    public void addContainerModelBreadcrumbEntries(HttpServletRequest request, String className, long classPK, PortletURL containerModelURL) throws PortalException, SystemException {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)className);
        String rootContainerModelName = LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)trashHandler.getRootContainerModelName());
        if (classPK == 0L) {
            PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)rootContainerModelName, null);
            return;
        }
        containerModelURL.setParameter("containerModelId", "0");
        PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)rootContainerModelName, (String)containerModelURL.toString());
        this.addBreadcrumbEntries(request, className, classPK, "containerModelId", containerModelURL);
    }

    public void deleteEntriesAttachments(long companyId, long repositoryId, Date date, String[] attachmentFileNames) throws PortalException, SystemException {
        String[] stringArray = attachmentFileNames;
        int n = attachmentFileNames.length;
        int n2 = 0;
        while (n2 < n) {
            String attachmentFileName = stringArray[n2];
            String trashTime = TrashUtil.getTrashTime((String)attachmentFileName, (String)"_TRASH_TIME_");
            long timestamp = GetterUtil.getLong((String)trashTime);
            if (timestamp < date.getTime()) {
                DLStoreUtil.deleteDirectory((long)companyId, (long)repositoryId, (String)attachmentFileName);
            }
            ++n2;
        }
    }

    public List<TrashEntry> getEntries(Hits hits) {
        ArrayList<TrashEntry> entries = new ArrayList<TrashEntry>();
        Document[] documentArray = hits.getDocs();
        int n = documentArray.length;
        int n2 = 0;
        while (n2 < n) {
            block5: {
                Document document = documentArray[n2];
                String entryClassName = GetterUtil.getString((String)document.get("entryClassName"));
                long classPK = GetterUtil.getLong((String)document.get("entryClassPK"));
                try {
                    TrashEntry entry = TrashEntryLocalServiceUtil.fetchEntry((String)entryClassName, (long)classPK);
                    if (entry == null) {
                        String userName = GetterUtil.getString((String)document.get("removedByUserName"));
                        Date removedDate = document.getDate("removedDate");
                        entry = new TrashEntryImpl();
                        entry.setClassName(entryClassName);
                        entry.setClassPK(classPK);
                        entry.setUserName(userName);
                        entry.setCreateDate(removedDate);
                        String rootEntryClassName = GetterUtil.getString((String)document.get("rootEntryClassName"));
                        long rootEntryClassPK = GetterUtil.getLong((String)document.get("rootEntryClassPK"));
                        TrashEntry rootTrashEntry = TrashEntryLocalServiceUtil.fetchEntry((String)rootEntryClassName, (long)rootEntryClassPK);
                        if (rootTrashEntry != null) {
                            entry.setRootEntry(rootTrashEntry);
                        }
                    }
                    entries.add(entry);
                }
                catch (Exception exception) {
                    if (!_log.isWarnEnabled()) break block5;
                    _log.warn((Object)("Unable to find trash entry for " + entryClassName + " with primary key " + classPK));
                }
            }
            ++n2;
        }
        return entries;
    }

    public OrderByComparator getEntryOrderByComparator(String orderByCol, String orderByType) {
        boolean orderByAsc = false;
        if (orderByType.equals("asc")) {
            orderByAsc = true;
        }
        EntryUserNameComparator orderByComparator = null;
        if (orderByCol.equals("removed-by")) {
            orderByComparator = new EntryUserNameComparator(orderByAsc);
        } else if (orderByCol.equals("removed-date")) {
            orderByComparator = new EntryCreateDateComparator(orderByAsc);
        } else if (orderByCol.equals("type")) {
            orderByComparator = new EntryTypeComparator(orderByAsc);
        }
        return orderByComparator;
    }

    public int getMaxAge(Group group) throws PortalException, SystemException {
        if (group.isLayout()) {
            group = group.getParentGroup();
        }
        int trashEntriesMaxAge = PrefsPropsUtil.getInteger((long)group.getCompanyId(), (String)"trash.entries.max.age", (int)PropsValues.TRASH_ENTRIES_MAX_AGE);
        UnicodeProperties typeSettingsProperties = group.getTypeSettingsProperties();
        return GetterUtil.getInteger((String)typeSettingsProperties.getProperty("trashEntriesMaxAge"), (int)trashEntriesMaxAge);
    }

    public String getNewName(String oldName, String token) {
        StringBundler sb = new StringBundler(3);
        sb.append(oldName);
        sb.append(" ");
        sb.append(token);
        return sb.toString();
    }

    public String getNewName(ThemeDisplay themeDisplay, String className, long classPK, String oldName) throws PortalException, SystemException {
        TrashRenderer trashRenderer = null;
        if (Validator.isNotNull((String)className) && classPK > 0L) {
            TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)className);
            trashRenderer = trashHandler.getTrashRenderer(classPK);
        }
        Format dateFormatDateTime = FastDateFormatFactoryUtil.getDateTime((Locale)themeDisplay.getLocale(), (TimeZone)themeDisplay.getTimeZone());
        StringBundler sb = new StringBundler(3);
        sb.append("(");
        sb.append(StringUtil.replace((String)dateFormatDateTime.format(new Date()), (char)'/', (char)'.'));
        sb.append(")");
        if (trashRenderer != null) {
            return trashRenderer.getNewName(oldName, sb.toString());
        }
        return this.getNewName(oldName, sb.toString());
    }

    public String getOriginalTitle(String title) {
        return this.getOriginalTitle(title, "/");
    }

    public String getTrashTime(String title, String separator) {
        int index = title.lastIndexOf(separator);
        if (index < 0) {
            return "";
        }
        return title.substring(index + 1, title.length());
    }

    public String getTrashTitle(long trashEntryId) {
        return this.getTrashTitle(trashEntryId, "/");
    }

    public PortletURL getViewContentURL(HttpServletRequest request, String className, long classPK) throws PortalException, SystemException {
        TrashRenderer trashRenderer;
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (!(themeDisplay.isSignedIn() && this.isTrashEnabled(themeDisplay.getScopeGroupId()) && PortletPermissionUtil.hasControlPanelAccessPermission((PermissionChecker)themeDisplay.getPermissionChecker(), (long)themeDisplay.getScopeGroupId(), (String)"182"))) {
            return null;
        }
        TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)className);
        if (trashHandler.isInTrashContainer(classPK)) {
            TrashEntry trashEntry = trashHandler.getTrashEntry(classPK);
            className = trashEntry.getClassName();
            classPK = trashEntry.getClassPK();
            trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)className);
        }
        if ((trashRenderer = trashHandler.getTrashRenderer(classPK)) == null) {
            return null;
        }
        Layout layout = themeDisplay.getLayout();
        PortletURL portletURL = PortalUtil.getControlPanelPortletURL((HttpServletRequest)request, (String)"182", (long)layout.getLayoutId(), (String)"RENDER_PHASE");
        portletURL.setParameter("struts_action", "/trash/view_content");
        portletURL.setParameter("redirect", themeDisplay.getURLCurrent());
        TrashEntry trashEntry = TrashEntryLocalServiceUtil.getEntry((String)className, (long)classPK);
        if (trashEntry.getRootEntry() != null) {
            portletURL.setParameter("className", className);
            portletURL.setParameter("classPK", String.valueOf(classPK));
        } else {
            portletURL.setParameter("trashEntryId", String.valueOf(trashEntry.getEntryId()));
        }
        portletURL.setParameter("type", trashRenderer.getType());
        portletURL.setParameter("showActions", Boolean.FALSE.toString());
        portletURL.setParameter("showAssetMetadata", Boolean.TRUE.toString());
        portletURL.setParameter("showEditURL", Boolean.FALSE.toString());
        return portletURL;
    }

    public boolean isInTrash(String className, long classPK) throws PortalException, SystemException {
        TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)className);
        if (trashHandler == null) {
            return false;
        }
        return trashHandler.isInTrash(classPK);
    }

    public boolean isTrashEnabled(long groupId) throws PortalException, SystemException {
        Group group = GroupLocalServiceUtil.getGroup((long)groupId);
        UnicodeProperties typeSettingsProperties = group.getParentLiveGroupTypeSettingsProperties();
        boolean companyTrashEnabled = PrefsPropsUtil.getBoolean((long)group.getCompanyId(), (String)"trash.enabled");
        if (!companyTrashEnabled) {
            return false;
        }
        return GetterUtil.getBoolean((String)typeSettingsProperties.getProperty("trashEnabled"), (boolean)true);
    }

    protected void addBreadcrumbEntries(HttpServletRequest request, String className, long classPK, String paramName, PortletURL containerModelURL) throws PortalException, SystemException {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)className);
        List containerModels = trashHandler.getParentContainerModels(classPK);
        Collections.reverse(containerModels);
        containerModelURL.setParameter("struts_action", "/trash/view");
        PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"recycle-bin"), (String)containerModelURL.toString());
        for (ContainerModel containerModel : containerModels) {
            TrashHandler containerModelTrashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)containerModel.getModelClassName());
            if (!containerModelTrashHandler.isInTrash(containerModel.getContainerModelId())) continue;
            containerModelURL.setParameter("struts_action", "/trash/view_content");
            containerModelURL.setParameter(paramName, String.valueOf(containerModel.getContainerModelId()));
            String name = containerModel.getContainerModelName();
            if (containerModelTrashHandler.isInTrash(containerModel.getContainerModelId())) {
                name = TrashUtil.getOriginalTitle((String)name);
            }
            PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)name, (String)containerModelURL.toString());
        }
        TrashRenderer trashRenderer = trashHandler.getTrashRenderer(classPK);
        PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)trashRenderer.getTitle(themeDisplay.getLocale()), null);
    }

    protected String getOriginalTitle(String title, String prefix) {
        block4: {
            if (!title.startsWith(prefix)) {
                return title;
            }
            long trashEntryId = GetterUtil.getLong((String)(title = title.substring(prefix.length())));
            if (trashEntryId <= 0L) {
                return title;
            }
            try {
                TrashEntry trashEntry = TrashEntryLocalServiceUtil.getEntry((long)trashEntryId);
                title = trashEntry.getTypeSettingsProperty("title");
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block4;
                _log.debug((Object)("No trash entry exists with ID " + trashEntryId));
            }
        }
        return title;
    }

    protected String getTrashTitle(long trashEntryId, String prefix) {
        return prefix.concat(String.valueOf(trashEntryId));
    }
}

