/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.wiki.NoSuchPageException;
import com.liferay.portlet.wiki.model.WikiNode;
import com.liferay.portlet.wiki.model.WikiPage;
import com.liferay.portlet.wiki.service.base.WikiPageServiceBaseImpl;
import com.liferay.portlet.wiki.service.permission.WikiNodePermission;
import com.liferay.portlet.wiki.service.permission.WikiPagePermission;
import com.liferay.portlet.wiki.util.WikiUtil;
import com.liferay.portlet.wiki.util.comparator.PageCreateDateComparator;
import com.liferay.util.RSSUtil;
import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndContentImpl;
import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndFeedImpl;
import com.sun.syndication.feed.synd.SyndLinkImpl;
import com.sun.syndication.io.FeedException;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class WikiPageServiceImpl
extends WikiPageServiceBaseImpl {
    public WikiPage addPage(long nodeId, String title, String content, String summary, boolean minorEdit, ServiceContext serviceContext) throws PortalException, SystemException {
        WikiNodePermission.check(this.getPermissionChecker(), nodeId, "ADD_PAGE");
        return this.wikiPageLocalService.addPage(this.getUserId(), nodeId, title, content, summary, minorEdit, serviceContext);
    }

    public WikiPage addPage(long nodeId, String title, String content, String summary, boolean minorEdit, String format, String parentTitle, String redirectTitle, ServiceContext serviceContext) throws PortalException, SystemException {
        WikiNodePermission.check(this.getPermissionChecker(), nodeId, "ADD_PAGE");
        return this.wikiPageLocalService.addPage(this.getUserId(), nodeId, title, 1.0, content, summary, minorEdit, format, true, parentTitle, redirectTitle, serviceContext);
    }

    public void addPageAttachment(long nodeId, String title, String fileName, File file, String mimeType) throws PortalException, SystemException {
        WikiNodePermission.check(this.getPermissionChecker(), nodeId, "ADD_ATTACHMENT");
        this.wikiPageLocalService.addPageAttachment(this.getUserId(), nodeId, title, fileName, file, mimeType);
    }

    public void addPageAttachment(long nodeId, String title, String fileName, InputStream inputStream, String mimeType) throws PortalException, SystemException {
        WikiNodePermission.check(this.getPermissionChecker(), nodeId, "ADD_ATTACHMENT");
        this.wikiPageLocalService.addPageAttachment(this.getUserId(), nodeId, title, fileName, inputStream, mimeType);
    }

    public void addPageAttachments(long nodeId, String title, List<ObjectValuePair<String, InputStream>> inputStreamOVPs) throws PortalException, SystemException {
        WikiNodePermission.check(this.getPermissionChecker(), nodeId, "ADD_ATTACHMENT");
        this.wikiPageLocalService.addPageAttachments(this.getUserId(), nodeId, title, inputStreamOVPs);
    }

    public void addTempPageAttachment(long nodeId, String fileName, String tempFolderName, InputStream inputStream, String mimeType) throws PortalException, SystemException {
        WikiNode node = this.wikiNodeLocalService.getNode(nodeId);
        WikiNodePermission.check(this.getPermissionChecker(), node, "ADD_ATTACHMENT");
        this.wikiPageLocalService.addTempPageAttachment(node.getGroupId(), this.getUserId(), fileName, tempFolderName, inputStream, mimeType);
    }

    public void changeParent(long nodeId, String title, String newParentTitle, ServiceContext serviceContext) throws PortalException, SystemException {
        WikiPagePermission.check(this.getPermissionChecker(), nodeId, title, "DELETE");
        WikiNodePermission.check(this.getPermissionChecker(), nodeId, "ADD_PAGE");
        this.wikiPageLocalService.changeParent(this.getUserId(), nodeId, title, newParentTitle, serviceContext);
    }

    public void copyPageAttachments(long templateNodeId, String templateTitle, long nodeId, String title) throws PortalException, SystemException {
        WikiNodePermission.check(this.getPermissionChecker(), nodeId, "ADD_ATTACHMENT");
        this.wikiPageLocalService.copyPageAttachments(this.getUserId(), templateNodeId, templateTitle, nodeId, title);
    }

    public void deletePage(long nodeId, String title) throws PortalException, SystemException {
        WikiPagePermission.check(this.getPermissionChecker(), nodeId, title, "DELETE");
        this.wikiPageLocalService.deletePage(nodeId, title);
    }

    public void deletePage(long nodeId, String title, double version) throws PortalException, SystemException {
        this.discardDraft(nodeId, title, version);
    }

    public void deletePageAttachment(long nodeId, String title, String fileName) throws PortalException, SystemException {
        WikiPagePermission.check(this.getPermissionChecker(), nodeId, title, "DELETE");
        this.wikiPageLocalService.deletePageAttachment(nodeId, title, fileName);
    }

    public void deletePageAttachments(long nodeId, String title) throws PortalException, SystemException {
        WikiPagePermission.check(this.getPermissionChecker(), nodeId, title, "DELETE");
        this.wikiPageLocalService.deletePageAttachments(nodeId, title);
    }

    public void deleteTempPageAttachment(long nodeId, String fileName, String tempFolderName) throws PortalException, SystemException {
        WikiNode node = this.wikiNodeLocalService.getNode(nodeId);
        WikiNodePermission.check(this.getPermissionChecker(), node, "ADD_ATTACHMENT");
        this.wikiPageLocalService.deleteTempPageAttachment(node.getGroupId(), this.getUserId(), fileName, tempFolderName);
    }

    public void deleteTrashPageAttachments(long nodeId, String title) throws PortalException, SystemException {
        WikiPagePermission.check(this.getPermissionChecker(), nodeId, title, "DELETE");
        this.wikiPageLocalService.deleteTrashPageAttachments(nodeId, title);
    }

    public void discardDraft(long nodeId, String title, double version) throws PortalException, SystemException {
        WikiPagePermission.check(this.getPermissionChecker(), nodeId, title, version, "DELETE");
        this.wikiPageLocalService.discardDraft(nodeId, title, version);
    }

    public List<WikiPage> getChildren(long groupId, long nodeId, boolean head, String parentTitle) throws PortalException, SystemException {
        WikiNodePermission.check(this.getPermissionChecker(), nodeId, "VIEW");
        return this.wikiPagePersistence.filterFindByG_N_H_P_S(groupId, nodeId, head, parentTitle, 0);
    }

    public WikiPage getDraftPage(long nodeId, String title) throws PortalException, SystemException {
        WikiPagePermission.check(this.getPermissionChecker(), nodeId, title, "VIEW");
        return this.wikiPageLocalService.getDraftPage(nodeId, title);
    }

    public List<WikiPage> getNodePages(long nodeId, int max) throws PortalException, SystemException {
        ArrayList<WikiPage> pages = new ArrayList<WikiPage>();
        int lastIntervalStart = 0;
        boolean listNotExhausted = true;
        block0: while (pages.size() < max && listNotExhausted) {
            List pageList = this.wikiPageLocalService.getPages(nodeId, true, lastIntervalStart, lastIntervalStart + max);
            lastIntervalStart += max;
            listNotExhausted = pageList.size() == max;
            for (WikiPage page : pageList) {
                if (pages.size() >= max) continue block0;
                if (!WikiPagePermission.contains(this.getPermissionChecker(), page, "VIEW")) continue;
                pages.add(page);
            }
        }
        return pages;
    }

    public String getNodePagesRSS(long nodeId, int max, String type, double version, String displayStyle, String feedURL, String entryURL) throws PortalException, SystemException {
        return this.getNodePagesRSS(nodeId, max, type, version, displayStyle, feedURL, entryURL, null);
    }

    public String getNodePagesRSS(long nodeId, int max, String type, double version, String displayStyle, String feedURL, String entryURL, String attachmentURLPrefix) throws PortalException, SystemException {
        WikiNodePermission.check(this.getPermissionChecker(), nodeId, "VIEW");
        WikiNode node = this.wikiNodePersistence.findByPrimaryKey(nodeId);
        List<WikiPage> pages = this.getNodePages(nodeId, max);
        return this.exportToRSS(node.getCompanyId(), node.getName(), node.getDescription(), type, version, displayStyle, feedURL, entryURL, attachmentURLPrefix, pages, false, null);
    }

    public List<WikiPage> getOrphans(long groupId, long nodeId) throws PortalException, SystemException {
        WikiNodePermission.check(this.getPermissionChecker(), nodeId, "VIEW");
        List pages = this.wikiPagePersistence.filterFindByG_N_H_S(groupId, nodeId, true, 0);
        return WikiUtil.filterOrphans(pages);
    }

    public WikiPage getPage(long groupId, long nodeId, String title) throws PortalException, SystemException {
        List pages = this.wikiPagePersistence.filterFindByG_N_T_H(groupId, nodeId, title, true, 0, 1);
        if (!pages.isEmpty()) {
            return (WikiPage)pages.get(0);
        }
        StringBundler sb = new StringBundler(5);
        sb.append("{nodeId=");
        sb.append(nodeId);
        sb.append(", title=");
        sb.append(title);
        sb.append("}");
        throw new NoSuchPageException(sb.toString());
    }

    public WikiPage getPage(long nodeId, String title) throws PortalException, SystemException {
        WikiPagePermission.check(this.getPermissionChecker(), nodeId, title, "VIEW");
        return this.wikiPageLocalService.getPage(nodeId, title);
    }

    public WikiPage getPage(long nodeId, String title, Boolean head) throws PortalException, SystemException {
        WikiPagePermission.check(this.getPermissionChecker(), nodeId, title, "VIEW");
        return this.wikiPageLocalService.getPage(nodeId, title, head);
    }

    public WikiPage getPage(long nodeId, String title, double version) throws PortalException, SystemException {
        WikiPagePermission.check(this.getPermissionChecker(), nodeId, title, "VIEW");
        return this.wikiPageLocalService.getPage(nodeId, title, version);
    }

    public List<WikiPage> getPages(long groupId, long nodeId, boolean head, int status, int start, int end, OrderByComparator obc) throws PortalException, SystemException {
        WikiNodePermission.check(this.getPermissionChecker(), nodeId, "VIEW");
        if (status == -1) {
            return this.wikiPagePersistence.filterFindByG_N_H(groupId, nodeId, head, start, end, obc);
        }
        return this.wikiPagePersistence.filterFindByG_N_H_S(groupId, nodeId, head, status, start, end, obc);
    }

    public List<WikiPage> getPages(long groupId, long userId, long nodeId, int status, int start, int end) throws PortalException, SystemException {
        WikiNodePermission.check(this.getPermissionChecker(), nodeId, "VIEW");
        if (userId > 0L) {
            return this.wikiPagePersistence.filterFindByG_U_N_S(groupId, userId, nodeId, status, start, end, (OrderByComparator)new PageCreateDateComparator(false));
        }
        return this.wikiPagePersistence.filterFindByG_N_S(groupId, nodeId, status, start, end, (OrderByComparator)new PageCreateDateComparator(false));
    }

    public int getPagesCount(long groupId, long nodeId, boolean head) throws PortalException, SystemException {
        WikiNodePermission.check(this.getPermissionChecker(), nodeId, "VIEW");
        return this.wikiPagePersistence.filterCountByG_N_H_S(groupId, nodeId, head, 0);
    }

    public int getPagesCount(long groupId, long userId, long nodeId, int status) throws PortalException, SystemException {
        WikiNodePermission.check(this.getPermissionChecker(), nodeId, "VIEW");
        if (userId > 0L) {
            return this.wikiPagePersistence.filterCountByG_U_N_S(groupId, userId, nodeId, status);
        }
        return this.wikiPagePersistence.filterCountByG_N_S(groupId, nodeId, status);
    }

    public String getPagesRSS(long companyId, long nodeId, String title, int max, String type, double version, String displayStyle, String feedURL, String entryURL, Locale locale) throws PortalException, SystemException {
        return this.getPagesRSS(companyId, nodeId, title, max, type, version, displayStyle, feedURL, entryURL, null, locale);
    }

    public String getPagesRSS(long companyId, long nodeId, String title, int max, String type, double version, String displayStyle, String feedURL, String entryURL, String attachmentURLPrefix, Locale locale) throws PortalException, SystemException {
        WikiPagePermission.check(this.getPermissionChecker(), nodeId, title, "VIEW");
        List pages = this.wikiPageLocalService.getPages(nodeId, title, 0, max, (OrderByComparator)new PageCreateDateComparator(true));
        return this.exportToRSS(companyId, title, title, type, version, displayStyle, feedURL, entryURL, attachmentURLPrefix, pages, true, locale);
    }

    public List<WikiPage> getRecentChanges(long groupId, long nodeId, int start, int end) throws PortalException, SystemException {
        WikiNodePermission.check(this.getPermissionChecker(), nodeId, "VIEW");
        Calendar calendar = CalendarFactoryUtil.getCalendar();
        calendar.add(3, -1);
        return this.wikiPageFinder.filterFindByCreateDate(groupId, nodeId, calendar.getTime(), false, start, end);
    }

    public int getRecentChangesCount(long groupId, long nodeId) throws PortalException, SystemException {
        WikiNodePermission.check(this.getPermissionChecker(), nodeId, "VIEW");
        Calendar calendar = CalendarFactoryUtil.getCalendar();
        calendar.add(3, -1);
        return this.wikiPageFinder.filterCountByCreateDate(groupId, nodeId, calendar.getTime(), false);
    }

    public String[] getTempPageAttachmentNames(long nodeId, String tempFolderName) throws PortalException, SystemException {
        WikiNode node = this.wikiNodeLocalService.getNode(nodeId);
        WikiNodePermission.check(this.getPermissionChecker(), node, "ADD_ATTACHMENT");
        return this.wikiPageLocalService.getTempPageAttachmentNames(node.getGroupId(), this.getUserId(), tempFolderName);
    }

    public void movePage(long nodeId, String title, String newTitle, ServiceContext serviceContext) throws PortalException, SystemException {
        WikiPagePermission.check(this.getPermissionChecker(), nodeId, title, "DELETE");
        WikiNodePermission.check(this.getPermissionChecker(), nodeId, "ADD_PAGE");
        this.wikiPageLocalService.movePage(this.getUserId(), nodeId, title, newTitle, serviceContext);
    }

    public FileEntry movePageAttachmentToTrash(long nodeId, String title, String fileName) throws PortalException, SystemException {
        WikiPagePermission.check(this.getPermissionChecker(), nodeId, title, "DELETE");
        return this.wikiPageLocalService.movePageAttachmentToTrash(this.getUserId(), nodeId, title, fileName);
    }

    public WikiPage movePageToTrash(long nodeId, String title) throws PortalException, SystemException {
        WikiPagePermission.check(this.getPermissionChecker(), nodeId, title, "DELETE");
        return this.wikiPageLocalService.movePageToTrash(this.getUserId(), nodeId, title);
    }

    public WikiPage movePageToTrash(long nodeId, String title, double version) throws PortalException, SystemException {
        WikiPagePermission.check(this.getPermissionChecker(), nodeId, title, version, "DELETE");
        return this.wikiPageLocalService.movePageToTrash(this.getUserId(), nodeId, title, version);
    }

    public void restorePageAttachmentFromTrash(long nodeId, String title, String fileName) throws PortalException, SystemException {
        WikiNodePermission.check(this.getPermissionChecker(), nodeId, "ADD_ATTACHMENT");
        this.wikiPageLocalService.restorePageAttachmentFromTrash(this.getUserId(), nodeId, title, fileName);
    }

    public void restorePageFromTrash(long resourcePrimKey) throws PortalException, SystemException {
        WikiPage page = this.wikiPageLocalService.getPage(resourcePrimKey);
        WikiPagePermission.check(this.getPermissionChecker(), page, "DELETE");
        this.wikiPageLocalService.restorePageFromTrash(this.getUserId(), page);
    }

    public WikiPage revertPage(long nodeId, String title, double version, ServiceContext serviceContext) throws PortalException, SystemException {
        WikiPagePermission.check(this.getPermissionChecker(), nodeId, title, "UPDATE");
        return this.wikiPageLocalService.revertPage(this.getUserId(), nodeId, title, version, serviceContext);
    }

    public void subscribePage(long nodeId, String title) throws PortalException, SystemException {
        WikiPagePermission.check(this.getPermissionChecker(), nodeId, title, "SUBSCRIBE");
        this.wikiPageLocalService.subscribePage(this.getUserId(), nodeId, title);
    }

    public void unsubscribePage(long nodeId, String title) throws PortalException, SystemException {
        WikiPagePermission.check(this.getPermissionChecker(), nodeId, title, "SUBSCRIBE");
        this.wikiPageLocalService.unsubscribePage(this.getUserId(), nodeId, title);
    }

    public WikiPage updatePage(long nodeId, String title, double version, String content, String summary, boolean minorEdit, String format, String parentTitle, String redirectTitle, ServiceContext serviceContext) throws PortalException, SystemException {
        WikiPagePermission.check(this.getPermissionChecker(), nodeId, title, "UPDATE");
        return this.wikiPageLocalService.updatePage(this.getUserId(), nodeId, title, version, content, summary, minorEdit, format, parentTitle, redirectTitle, serviceContext);
    }

    protected String exportToRSS(long companyId, String name, String description, String type, double version, String displayStyle, String feedURL, String entryURL, String attachmentURLPrefix, List<WikiPage> pages, boolean diff, Locale locale) throws PortalException, SystemException {
        SyndFeedImpl syndFeed = new SyndFeedImpl();
        syndFeed.setDescription(description);
        ArrayList<SyndEntryImpl> syndEntries = new ArrayList<SyndEntryImpl>();
        syndFeed.setEntries(syndEntries);
        WikiPage latestPage = null;
        StringBundler sb = new StringBundler(6);
        for (WikiPage page : pages) {
            String value;
            SyndEntryImpl syndEntry = new SyndEntryImpl();
            String author = PortalUtil.getUserName((BaseModel)page);
            syndEntry.setAuthor(author);
            SyndContentImpl syndContent = new SyndContentImpl();
            syndContent.setType("html");
            sb.setIndex(0);
            sb.append(entryURL);
            if (entryURL.endsWith("/")) {
                sb.append(HttpUtil.encodeURL((String)page.getTitle()));
            }
            if (diff) {
                if (latestPage != null || pages.size() == 1) {
                    sb.append("?");
                    sb.append(PortalUtil.getPortletNamespace((String)"36"));
                    sb.append("version=");
                    sb.append(page.getVersion());
                    value = null;
                    if (latestPage == null) {
                        value = WikiUtil.convert(page, null, null, attachmentURLPrefix);
                    } else {
                        try {
                            value = WikiUtil.diffHtml(latestPage, page, null, null, attachmentURLPrefix);
                        }
                        catch (PortalException pe) {
                            throw pe;
                        }
                        catch (SystemException se) {
                            throw se;
                        }
                        catch (Exception e2) {
                            throw new SystemException((Throwable)e2);
                        }
                    }
                    syndContent.setValue(value);
                    syndEntry.setDescription((SyndContent)syndContent);
                    syndEntries.add(syndEntry);
                }
            } else {
                value = null;
                value = displayStyle.equals("abstract") ? StringUtil.shorten((String)HtmlUtil.extractText((String)page.getContent()), (int)PropsValues.WIKI_RSS_ABSTRACT_LENGTH, (String)"") : (displayStyle.equals("title") ? "" : WikiUtil.convert(page, null, null, attachmentURLPrefix));
                syndContent.setValue(value);
                syndEntry.setDescription((SyndContent)syndContent);
                syndEntries.add(syndEntry);
            }
            syndEntry.setLink(sb.toString());
            syndEntry.setPublishedDate(page.getCreateDate());
            String title = String.valueOf(page.getTitle()) + " " + page.getVersion();
            if (page.isMinorEdit()) {
                title = String.valueOf(title) + " (" + LanguageUtil.get((Locale)locale, (String)"minor-edit") + ")";
            }
            syndEntry.setTitle(title);
            syndEntry.setUpdatedDate(page.getModifiedDate());
            syndEntry.setUri(sb.toString());
            latestPage = page;
        }
        syndFeed.setFeedType(RSSUtil.getFeedType((String)type, (double)version));
        ArrayList<SyndLinkImpl> syndLinks = new ArrayList<SyndLinkImpl>();
        syndFeed.setLinks(syndLinks);
        SyndLinkImpl syndLinkSelf = new SyndLinkImpl();
        syndLinks.add(syndLinkSelf);
        syndLinkSelf.setHref(feedURL);
        syndLinkSelf.setRel("self");
        syndFeed.setPublishedDate(new Date());
        syndFeed.setTitle(name);
        syndFeed.setUri(feedURL);
        try {
            return RSSUtil.export((SyndFeed)syndFeed);
        }
        catch (FeedException fe) {
            throw new SystemException((Throwable)fe);
        }
    }
}

