/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.service.permission;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.staging.permission.StagingPermissionUtil;
import com.liferay.portal.kernel.workflow.permission.WorkflowPermissionUtil;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.wiki.NoSuchPageException;
import com.liferay.portlet.wiki.NoSuchPageResourceException;
import com.liferay.portlet.wiki.model.WikiPage;
import com.liferay.portlet.wiki.service.WikiPageLocalServiceUtil;
import com.liferay.portlet.wiki.service.permission.WikiNodePermission;

public class WikiPagePermission {
    public static void check(PermissionChecker permissionChecker, long resourcePrimKey, String actionId) throws PortalException, SystemException {
        if (!WikiPagePermission.contains(permissionChecker, resourcePrimKey, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, long nodeId, String title, double version, String actionId) throws PortalException, SystemException {
        if (!WikiPagePermission.contains(permissionChecker, nodeId, title, version, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, long nodeId, String title, String actionId) throws PortalException, SystemException {
        if (!WikiPagePermission.contains(permissionChecker, nodeId, title, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, WikiPage page, String actionId) throws PortalException {
        if (!WikiPagePermission.contains(permissionChecker, page, actionId)) {
            throw new PrincipalException();
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, long resourcePrimKey, String actionId) throws PortalException, SystemException {
        try {
            WikiPage page = WikiPageLocalServiceUtil.getPage((long)resourcePrimKey, null);
            return WikiPagePermission.contains(permissionChecker, page, actionId);
        }
        catch (NoSuchPageResourceException noSuchPageResourceException) {
            return false;
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, long nodeId, String title, double version, String actionId) throws PortalException, SystemException {
        try {
            WikiPage page = WikiPageLocalServiceUtil.getPage((long)nodeId, (String)title, (double)version);
            return WikiPagePermission.contains(permissionChecker, page, actionId);
        }
        catch (NoSuchPageException noSuchPageException) {
            return WikiNodePermission.contains(permissionChecker, nodeId, "VIEW");
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, long nodeId, String title, String actionId) throws PortalException, SystemException {
        try {
            WikiPage page = WikiPageLocalServiceUtil.getPage((long)nodeId, (String)title, null);
            return WikiPagePermission.contains(permissionChecker, page, actionId);
        }
        catch (NoSuchPageException noSuchPageException) {
            return WikiNodePermission.contains(permissionChecker, nodeId, "VIEW");
        }
    }

    /*
     * Unable to fully structure code
     */
    public static boolean contains(PermissionChecker permissionChecker, WikiPage page, String actionId) {
        block12: {
            hasPermission = StagingPermissionUtil.hasPermission((PermissionChecker)permissionChecker, (long)page.getGroupId(), (String)WikiPage.class.getName(), (long)page.getPageId(), (String)"36", (String)actionId);
            if (hasPermission != null) {
                return hasPermission;
            }
            if (page.isDraft()) {
                if (actionId.equals("VIEW") && !WikiPagePermission.contains(permissionChecker, page, "UPDATE")) {
                    return false;
                }
                if (actionId.equals("DELETE") && page.getStatusByUserId() == permissionChecker.getUserId()) {
                    return true;
                }
            } else if (page.isPending()) {
                hasPermission = WorkflowPermissionUtil.hasPermission((PermissionChecker)permissionChecker, (long)page.getGroupId(), (String)WikiPage.class.getName(), (long)page.getResourcePrimKey(), (String)actionId);
                if (hasPermission != null && hasPermission.booleanValue()) {
                    return true;
                }
            } else if (page.isScheduled() && actionId.equals("VIEW") && !WikiPagePermission.contains(permissionChecker, page, "UPDATE")) {
                return false;
            }
            if (!actionId.equals("VIEW")) break block12;
            redirectPage = page.getRedirectPage();
            if (redirectPage != null) {
                page = redirectPage;
            }
            if (!PropsValues.PERMISSIONS_VIEW_DYNAMIC_INHERITANCE) break block12;
            node = page.getNode();
            if (WikiNodePermission.contains(permissionChecker, node, actionId)) ** GOTO lbl28
            return false;
lbl-1000:
            // 1 sources

            {
                if (!WikiPagePermission._hasPermission(permissionChecker, page, actionId)) {
                    return false;
                }
                page = page.getParentPage();
lbl28:
                // 2 sources

                ** while (page != null)
            }
lbl29:
            // 1 sources

            return true;
        }
        return WikiPagePermission._hasPermission(permissionChecker, page, actionId);
    }

    private static boolean _hasPermission(PermissionChecker permissionChecker, WikiPage page, String actionId) {
        return permissionChecker.hasOwnerPermission(page.getCompanyId(), WikiPage.class.getName(), page.getResourcePrimKey(), page.getUserId(), actionId) || permissionChecker.hasPermission(page.getGroupId(), WikiPage.class.getName(), page.getResourcePrimKey(), actionId);
    }
}

