/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.cal;

import com.liferay.portal.kernel.cal.DayAndPosition;
import com.liferay.portal.kernel.cal.Duration;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.TimeZoneUtil;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;

public class Recurrence
implements Serializable {
    public static final int DAILY = 3;
    public static final int MONTHLY = 5;
    public static final int NO_RECURRENCE = 7;
    public static final int WEEKLY = 4;
    public static final int YEARLY = 6;
    protected DayAndPosition[] byDay;
    protected int[] byMonth;
    protected int[] byMonthDay;
    protected int[] byWeekNo;
    protected int[] byYearDay;
    protected Calendar dtStart;
    protected Duration duration;
    protected int frequency;
    protected int interval;
    protected int occurrence = 0;
    protected Calendar until;

    public Recurrence() {
        this(null, new Duration(), 7);
    }

    public Recurrence(Calendar start, Duration dur) {
        this(start, dur, 7);
    }

    public Recurrence(Calendar start, Duration dur, int freq) {
        this.setDtStart(start);
        this.duration = (Duration)dur.clone();
        this.frequency = freq;
        this.interval = 1;
    }

    public DayAndPosition[] getByDay() {
        if (this.byDay == null) {
            return null;
        }
        DayAndPosition[] b = new DayAndPosition[this.byDay.length];
        int i = 0;
        while (i < this.byDay.length) {
            b[i] = (DayAndPosition)this.byDay[i].clone();
            ++i;
        }
        return b;
    }

    public int[] getByMonth() {
        if (this.byMonth == null) {
            return null;
        }
        int[] b = new int[this.byMonth.length];
        System.arraycopy(this.byMonth, 0, b, 0, this.byMonth.length);
        return b;
    }

    public int[] getByMonthDay() {
        if (this.byMonthDay == null) {
            return null;
        }
        int[] b = new int[this.byMonthDay.length];
        System.arraycopy(this.byMonthDay, 0, b, 0, this.byMonthDay.length);
        return b;
    }

    public int[] getByWeekNo() {
        if (this.byWeekNo == null) {
            return null;
        }
        int[] b = new int[this.byWeekNo.length];
        System.arraycopy(this.byWeekNo, 0, b, 0, this.byWeekNo.length);
        return b;
    }

    public int[] getByYearDay() {
        if (this.byYearDay == null) {
            return null;
        }
        int[] b = new int[this.byYearDay.length];
        System.arraycopy(this.byYearDay, 0, b, 0, this.byYearDay.length);
        return b;
    }

    public Calendar getCandidateStartTime(Calendar current) {
        if (this.dtStart.getTime().getTime() > current.getTime().getTime()) {
            throw new IllegalArgumentException("Current time before DtStart");
        }
        int minInterval = this.getMinimumInterval();
        Calendar candidate = (Calendar)current.clone();
        candidate.clear(15);
        candidate.clear(16);
        candidate.setTimeZone(TimeZoneUtil.getTimeZone("UTC"));
        candidate.setMinimalDaysInFirstWeek(4);
        candidate.setFirstDayOfWeek(this.dtStart.getFirstDayOfWeek());
        if (this.frequency == 7) {
            candidate.setTime(this.dtStart.getTime());
            return candidate;
        }
        Recurrence.reduce_constant_length_field(13, this.dtStart, candidate);
        Recurrence.reduce_constant_length_field(12, this.dtStart, candidate);
        Recurrence.reduce_constant_length_field(11, this.dtStart, candidate);
        switch (minInterval) {
            case 3: {
                break;
            }
            case 4: {
                Recurrence.reduce_constant_length_field(7, this.dtStart, candidate);
                break;
            }
            case 5: {
                Recurrence.reduce_day_of_month(this.dtStart, candidate);
                break;
            }
            case 6: {
                Recurrence.reduce_day_of_year(this.dtStart, candidate);
            }
        }
        return candidate;
    }

    public Calendar getDtEnd() {
        Calendar tempEnd = (Calendar)this.dtStart.clone();
        tempEnd.setTime(new Date(this.dtStart.getTime().getTime() + this.duration.getInterval()));
        return tempEnd;
    }

    public Calendar getDtStart() {
        return (Calendar)this.dtStart.clone();
    }

    public Duration getDuration() {
        return (Duration)this.duration.clone();
    }

    public int getFrequency() {
        return this.frequency;
    }

    public int getInterval() {
        return this.interval;
    }

    public int getOccurrence() {
        return this.occurrence;
    }

    public Calendar getUntil() {
        return this.until != null ? (Calendar)this.until.clone() : null;
    }

    public int getWeekStart() {
        return this.dtStart.getFirstDayOfWeek();
    }

    public boolean isInRecurrence(Calendar current) {
        return this.isInRecurrence(current, false);
    }

    public boolean isInRecurrence(Calendar current, boolean debug) {
        Calendar myCurrent = (Calendar)current.clone();
        myCurrent.clear(15);
        myCurrent.clear(16);
        myCurrent.setTimeZone(TimeZoneUtil.getTimeZone("UTC"));
        myCurrent.setMinimalDaysInFirstWeek(4);
        myCurrent.setFirstDayOfWeek(this.dtStart.getFirstDayOfWeek());
        myCurrent.set(13, 0);
        myCurrent.set(14, 0);
        if (myCurrent.getTime().getTime() < this.dtStart.getTime().getTime()) {
            if (debug) {
                System.err.println("current < start");
            }
            return false;
        }
        Calendar candidate = this.getCandidateStartTime(myCurrent);
        while (candidate.getTime().getTime() + this.duration.getInterval() > myCurrent.getTime().getTime()) {
            if (this.candidateIsInRecurrence(candidate, debug)) {
                return true;
            }
            candidate.add(13, -1);
            if (candidate.getTime().getTime() < this.dtStart.getTime().getTime()) {
                if (debug) {
                    System.err.println("No candidates after dtStart");
                }
                return false;
            }
            candidate = this.getCandidateStartTime(candidate);
        }
        if (debug) {
            System.err.println("No matching candidates");
        }
        return false;
    }

    public void setByDay(DayAndPosition[] b) {
        if (b == null) {
            this.byDay = null;
            return;
        }
        this.byDay = new DayAndPosition[b.length];
        int i = 0;
        while (i < b.length) {
            this.byDay[i] = (DayAndPosition)b[i].clone();
            ++i;
        }
    }

    public void setByMonth(int[] b) {
        if (b == null) {
            this.byMonth = null;
            return;
        }
        this.byMonth = new int[b.length];
        System.arraycopy(b, 0, this.byMonth, 0, b.length);
    }

    public void setByMonthDay(int[] b) {
        if (b == null) {
            this.byMonthDay = null;
            return;
        }
        this.byMonthDay = new int[b.length];
        System.arraycopy(b, 0, this.byMonthDay, 0, b.length);
    }

    public void setByWeekNo(int[] b) {
        if (b == null) {
            this.byWeekNo = null;
            return;
        }
        this.byWeekNo = new int[b.length];
        System.arraycopy(b, 0, this.byWeekNo, 0, b.length);
    }

    public void setByYearDay(int[] b) {
        if (b == null) {
            this.byYearDay = null;
            return;
        }
        this.byYearDay = new int[b.length];
        System.arraycopy(b, 0, this.byYearDay, 0, b.length);
    }

    public void setDtEnd(Calendar end) {
        Calendar tempEnd = (Calendar)end.clone();
        tempEnd.clear(15);
        tempEnd.clear(16);
        tempEnd.setTimeZone(TimeZoneUtil.getTimeZone("UTC"));
        this.duration.setInterval(tempEnd.getTime().getTime() - this.dtStart.getTime().getTime());
    }

    public void setDtStart(Calendar start) {
        int oldStart = this.dtStart != null ? this.dtStart.getFirstDayOfWeek() : 2;
        if (start == null) {
            this.dtStart = CalendarFactoryUtil.getCalendar(TimeZoneUtil.getTimeZone("UTC"));
            this.dtStart.setTime(new Date(0L));
        } else {
            this.dtStart = (Calendar)start.clone();
            this.dtStart.clear(15);
            this.dtStart.clear(16);
            this.dtStart.setTimeZone(TimeZoneUtil.getTimeZone("UTC"));
        }
        this.dtStart.setMinimalDaysInFirstWeek(4);
        this.dtStart.setFirstDayOfWeek(oldStart);
        this.dtStart.set(13, 0);
        this.dtStart.set(14, 0);
    }

    public void setDuration(Duration d) {
        this.duration = (Duration)d.clone();
    }

    public void setFrequency(int freq) {
        if (this.frequency != 3 && this.frequency != 4 && this.frequency != 5 && this.frequency != 6 && this.frequency != 7) {
            throw new IllegalArgumentException("Invalid frequency");
        }
        this.frequency = freq;
    }

    public void setInterval(int intr) {
        this.interval = intr > 0 ? intr : 1;
    }

    public void setOccurrence(int occur) {
        this.occurrence = occur;
    }

    public void setUntil(Calendar u) {
        if (u == null) {
            this.until = null;
            return;
        }
        this.until = (Calendar)u.clone();
        this.until.clear(15);
        this.until.clear(16);
        this.until.setTimeZone(TimeZoneUtil.getTimeZone("UTC"));
    }

    public void setWeekStart(int weekstart) {
        this.dtStart.setFirstDayOfWeek(weekstart);
    }

    public String toString() {
        StringBundler sb = new StringBundler();
        sb.append(this.getClass().getName());
        sb.append("[dtStart=");
        sb.append(this.dtStart != null ? this.dtStart.toString() : "null");
        sb.append(",duration=");
        sb.append(this.duration != null ? this.duration.toString() : "null");
        sb.append(",frequency=");
        sb.append(this.frequency);
        sb.append(",interval=");
        sb.append(this.interval);
        sb.append(",until=");
        sb.append(this.until != null ? this.until.toString() : "null");
        sb.append(",byDay=");
        if (this.byDay == null) {
            sb.append("null");
        } else {
            sb.append("[");
            int i = 0;
            while (i < this.byDay.length) {
                if (i != 0) {
                    sb.append(",");
                }
                if (this.byDay[i] != null) {
                    sb.append(this.byDay[i].toString());
                } else {
                    sb.append("null");
                }
                ++i;
            }
            sb.append("]");
        }
        sb.append(",byMonthDay=");
        sb.append(this.stringizeIntArray(this.byMonthDay));
        sb.append(",byYearDay=");
        sb.append(this.stringizeIntArray(this.byYearDay));
        sb.append(",byWeekNo=");
        sb.append(this.stringizeIntArray(this.byWeekNo));
        sb.append(",byMonth=");
        sb.append(this.stringizeIntArray(this.byMonth));
        sb.append(']');
        return sb.toString();
    }

    protected static long getDayNumber(Calendar cal) {
        Calendar tempCal = (Calendar)cal.clone();
        tempCal.set(14, 0);
        tempCal.set(13, 0);
        tempCal.set(12, 0);
        tempCal.set(11, 0);
        return tempCal.getTime().getTime() / 86400000L;
    }

    protected static long getMonthNumber(Calendar cal) {
        return (long)(cal.get(1) - 1970) * 12L + (long)(cal.get(2) - 0);
    }

    protected static long getWeekNumber(Calendar cal) {
        Calendar tempCal = (Calendar)cal.clone();
        tempCal.set(14, 0);
        tempCal.set(13, 0);
        tempCal.set(12, 0);
        tempCal.set(11, 0);
        int delta = tempCal.getFirstDayOfWeek() - tempCal.get(7);
        if (delta > 0) {
            delta -= 7;
        }
        long weekEpoch = (long)(tempCal.getFirstDayOfWeek() - 5) * 24L * 60L * 60L * 1000L;
        return (tempCal.getTime().getTime() - weekEpoch) / 604800000L;
    }

    protected static void reduce_constant_length_field(int field, Calendar start, Calendar candidate) {
        if (start.getMaximum(field) != start.getLeastMaximum(field) || start.getMinimum(field) != start.getGreatestMinimum(field)) {
            throw new IllegalArgumentException("Not a constant length field");
        }
        int fieldLength = start.getMaximum(field) - start.getMinimum(field) + 1;
        int delta = start.get(field) - candidate.get(field);
        if (delta > 0) {
            delta -= fieldLength;
        }
        candidate.add(field, delta);
    }

    protected static void reduce_day_of_month(Calendar start, Calendar candidate) {
        Calendar tempCal = (Calendar)candidate.clone();
        tempCal.add(2, -1);
        int delta = start.get(5) - candidate.get(5);
        if (delta > 0) {
            delta -= tempCal.getActualMaximum(5);
        }
        candidate.add(5, delta);
        while (start.get(5) != candidate.get(5)) {
            tempCal.add(2, -1);
            candidate.add(5, -tempCal.getActualMaximum(5));
        }
    }

    protected static void reduce_day_of_year(Calendar start, Calendar candidate) {
        if (start.get(2) > candidate.get(2) || start.get(2) == candidate.get(2) && start.get(5) > candidate.get(5)) {
            candidate.add(1, -1);
        }
        candidate.set(2, start.get(2));
        candidate.set(5, start.get(5));
        while (start.get(2) != candidate.get(2) || start.get(5) != candidate.get(5)) {
            candidate.add(1, -1);
            candidate.set(2, start.get(2));
            candidate.set(5, start.get(5));
        }
    }

    protected boolean candidateIsInRecurrence(Calendar candidate, boolean debug) {
        if (this.until != null && candidate.getTime().getTime() > this.until.getTime().getTime()) {
            if (debug) {
                System.err.println("after until");
            }
            return false;
        }
        if (this.getRecurrenceCount(candidate) % this.interval != 0) {
            if (debug) {
                System.err.println("not an interval rep");
            }
            return false;
        }
        if (this.occurrence > 0 && this.getRecurrenceCount(candidate) >= this.occurrence) {
            return false;
        }
        if (!(this.matchesByDay(candidate) && this.matchesByMonthDay(candidate) && this.matchesByYearDay(candidate) && this.matchesByWeekNo(candidate) && this.matchesByMonth(candidate))) {
            if (debug) {
                System.err.println("doesn't match a by*");
            }
            return false;
        }
        if (debug) {
            System.err.println("All checks succeeded");
        }
        return true;
    }

    protected int getMinimumInterval() {
        if (this.frequency == 3 || this.byDay != null || this.byMonthDay != null || this.byYearDay != null) {
            return 3;
        }
        if (this.frequency == 4 || this.byWeekNo != null) {
            return 4;
        }
        if (this.frequency == 5 || this.byMonth != null) {
            return 5;
        }
        if (this.frequency == 6) {
            return 6;
        }
        if (this.frequency == 7) {
            return 7;
        }
        throw new IllegalStateException("Internal error: Unknown frequency value");
    }

    protected int getRecurrenceCount(Calendar candidate) {
        switch (this.frequency) {
            case 7: {
                return 0;
            }
            case 3: {
                return (int)(Recurrence.getDayNumber(candidate) - Recurrence.getDayNumber(this.dtStart));
            }
            case 4: {
                Calendar tempCand = (Calendar)candidate.clone();
                tempCand.setFirstDayOfWeek(this.dtStart.getFirstDayOfWeek());
                return (int)(Recurrence.getWeekNumber(tempCand) - Recurrence.getWeekNumber(this.dtStart));
            }
            case 5: {
                return (int)(Recurrence.getMonthNumber(candidate) - Recurrence.getMonthNumber(this.dtStart));
            }
            case 6: {
                return candidate.get(1) - this.dtStart.get(1);
            }
        }
        throw new IllegalStateException("bad frequency internally...");
    }

    protected boolean matchesByDay(Calendar candidate) {
        if (this.byDay == null || this.byDay.length == 0) {
            return true;
        }
        int i = 0;
        while (i < this.byDay.length) {
            if (this.matchesIndividualByDay(candidate, this.byDay[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean matchesByField(int[] array, int field, Calendar candidate, boolean allowNegative) {
        if (array == null || array.length == 0) {
            return true;
        }
        int i = 0;
        while (i < array.length) {
            int val;
            if (allowNegative && array[i] < 0) {
                int max = candidate.getActualMaximum(field);
                val = max + 1 + array[i];
            } else {
                val = array[i];
            }
            if (val == candidate.get(field)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean matchesByMonth(Calendar candidate) {
        return this.matchesByField(this.byMonth, 2, candidate, false);
    }

    protected boolean matchesByMonthDay(Calendar candidate) {
        return this.matchesByField(this.byMonthDay, 5, candidate, true);
    }

    protected boolean matchesByWeekNo(Calendar candidate) {
        return this.matchesByField(this.byWeekNo, 3, candidate, true);
    }

    protected boolean matchesByYearDay(Calendar candidate) {
        return this.matchesByField(this.byYearDay, 6, candidate, true);
    }

    protected boolean matchesIndividualByDay(Calendar candidate, DayAndPosition pos) {
        if (pos.getDayOfWeek() != candidate.get(7)) {
            return false;
        }
        int position = pos.getDayPosition();
        if (position == 0) {
            return true;
        }
        int field = 5;
        if (position > 0) {
            int candidatePosition = (candidate.get(field) - 1) / 7 + 1;
            return position == candidatePosition;
        }
        int negativeCandidatePosition = (candidate.getActualMaximum(field) - candidate.get(field)) / 7 + 1;
        return -position == negativeCandidatePosition;
    }

    protected String stringizeIntArray(int[] a) {
        if (a == null) {
            return "null";
        }
        StringBundler sb = new StringBundler(2 * a.length + 1);
        sb.append("[");
        int i = 0;
        while (i < a.length) {
            if (i != 0) {
                sb.append(",");
            }
            sb.append(a[i]);
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }
}

