/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.dao.db;

import com.liferay.portal.kernel.dao.db.IndexMetadata;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;

public class IndexMetadataFactoryUtil {
    private static final String _INDEX_NAME_PREFIX = "IX_";

    public static IndexMetadata createIndexMetadata(boolean unique, String tableName, String ... columnNames) {
        String specification = IndexMetadataFactoryUtil._getSpecification(tableName, columnNames);
        String indexName = IndexMetadataFactoryUtil._getIndexName(specification);
        StringBundler sb = new StringBundler(5);
        if (!unique) {
            sb.append("create ");
        } else {
            sb.append("create unique ");
        }
        sb.append("index ");
        sb.append(indexName);
        sb.append(" on ");
        sb.append(specification);
        String createSQL = sb.toString();
        sb.setIndex(0);
        sb.append("drop index ");
        sb.append(indexName);
        sb.append(" on ");
        sb.append(tableName);
        String dropSQL = sb.toString();
        return new IndexMetadata(indexName, tableName, unique, specification, createSQL, dropSQL);
    }

    private static String _getIndexName(String specification) {
        String specificationHash = StringUtil.toHexString(specification.hashCode());
        specificationHash = specificationHash.toUpperCase();
        return _INDEX_NAME_PREFIX.concat(specificationHash);
    }

    private static String _getSpecification(String tableName, String[] columnNames) {
        StringBundler sb = new StringBundler(6);
        sb.append(tableName);
        sb.append(" ");
        sb.append("(");
        if (columnNames != null && columnNames.length > 0) {
            sb.append(StringUtil.merge(columnNames, ", "));
        }
        sb.append(")");
        sb.append(";");
        return sb.toString();
    }
}

