/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.io.delta;

import com.liferay.portal.kernel.io.delta.ByteChannelReader;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class RollingChecksum {
    private static MessageDigest _messageDigest;
    private int _a;
    private int _b;
    private int _blockLength;
    private ByteChannelReader _byteChannelReader;
    private int _filePosition;

    static {
        try {
            _messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new ExceptionInInitializerError(nsae);
        }
    }

    public RollingChecksum(ReadableByteChannel readableByteChannel, int blockLength) throws IOException {
        this._blockLength = blockLength;
        this._byteChannelReader = new ByteChannelReader(readableByteChannel, this._blockLength * 16);
        this.generateWeakChecksum();
    }

    public int currentBlockLength() {
        return Math.min(this._byteChannelReader.remaining(), this._blockLength);
    }

    public byte getFirstByte() {
        return this._byteChannelReader.get(0);
    }

    public int getPosition() {
        return this._filePosition;
    }

    public boolean hasNext() throws IOException {
        this._byteChannelReader.maybeRead(1);
        return this._byteChannelReader.remaining() >= 1;
    }

    public void nextBlock() throws IOException {
        this._filePosition += this._byteChannelReader.skip(this._blockLength);
        this.generateWeakChecksum();
    }

    public void nextByte() throws IOException {
        int blockLength = this.currentBlockLength();
        byte x = this._byteChannelReader.get();
        ++this._filePosition;
        this._a -= x;
        this._b -= blockLength * x;
        this._byteChannelReader.maybeRead(this._blockLength);
        if (this._byteChannelReader.remaining() >= this._blockLength) {
            x = this._byteChannelReader.get(this._blockLength - 1);
            this._a += x;
            this._b += this._a;
        }
    }

    public byte[] strongChecksum() {
        ByteBuffer buffer = this._byteChannelReader.getBuffer();
        int oldPosition = buffer.position();
        int oldLimit = buffer.limit();
        buffer.limit(buffer.position() + this.currentBlockLength());
        _messageDigest.update(buffer);
        buffer.limit(oldLimit);
        buffer.position(oldPosition);
        return _messageDigest.digest();
    }

    public int weakChecksum() {
        return this._a & 0xFFFF | this._b << 16;
    }

    protected void generateWeakChecksum() throws IOException {
        this._byteChannelReader.maybeRead(this._blockLength);
        this._a = 0;
        this._b = 0;
        int i = 0;
        while (i < this.currentBlockLength()) {
            this._a += this._byteChannelReader.get(i);
            this._b += this._a;
            ++i;
        }
    }
}

