/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.lar;

import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.PortletDataException;
import com.liferay.portal.kernel.lar.PortletDataHandler;
import com.liferay.portal.kernel.lar.PortletDataHandlerControl;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Time;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import javax.portlet.PortletPreferences;

public abstract class BasePortletDataHandler
implements PortletDataHandler {
    private static final boolean _ALWAYS_EXPORTABLE = false;
    private static final boolean _ALWAYS_STAGED = false;
    private static final boolean _DATA_LOCALIZED = false;
    private static final boolean _PUBLISH_TO_LIVE_BY_DEFAULT = false;
    private static Log _log = LogFactoryUtil.getLog(BasePortletDataHandler.class);

    @Override
    public PortletPreferences deleteData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws PortletDataException {
        long startTime = 0L;
        if (_log.isInfoEnabled()) {
            _log.info("Deleting portlet " + portletId);
            startTime = System.currentTimeMillis();
        }
        try {
            PortletPreferences portletPreferences2 = this.doDeleteData(portletDataContext, portletId, portletPreferences);
            return portletPreferences2;
        }
        catch (Exception e) {
            throw new PortletDataException(e);
        }
        finally {
            if (_log.isInfoEnabled()) {
                long duration = System.currentTimeMillis() - startTime;
                _log.info("Deleted portlet in " + Time.getDuration(duration));
            }
        }
    }

    @Override
    public String exportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws PortletDataException {
        long startTime = 0L;
        if (_log.isInfoEnabled()) {
            _log.info("Exporting portlet " + portletId);
            startTime = System.currentTimeMillis();
        }
        try {
            String string = this.doExportData(portletDataContext, portletId, portletPreferences);
            return string;
        }
        catch (Exception e) {
            throw new PortletDataException(e);
        }
        finally {
            if (_log.isInfoEnabled()) {
                long duration = System.currentTimeMillis() - startTime;
                _log.info("Exported portlet in " + Time.getDuration(duration));
            }
        }
    }

    @Override
    public String[] getDataPortletPreferences() {
        return new String[0];
    }

    @Override
    public PortletDataHandlerControl[] getExportControls() {
        return new PortletDataHandlerControl[0];
    }

    @Override
    public PortletDataHandlerControl[] getExportMetadataControls() {
        return new PortletDataHandlerControl[0];
    }

    @Override
    public PortletDataHandlerControl[] getImportControls() {
        return new PortletDataHandlerControl[0];
    }

    @Override
    public PortletDataHandlerControl[] getImportMetadataControls() {
        return new PortletDataHandlerControl[0];
    }

    @Override
    public PortletPreferences importData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences, String data) throws PortletDataException {
        long startTime = 0L;
        if (_log.isInfoEnabled()) {
            _log.info("Importing portlet " + portletId);
            startTime = System.currentTimeMillis();
        }
        long sourceGroupId = portletDataContext.getSourceGroupId();
        try {
            Document document;
            Element rootElement;
            long portletSourceGroupId;
            if (Validator.isXml(data) && (portletSourceGroupId = GetterUtil.getLong((rootElement = (document = SAXReaderUtil.read(data)).getRootElement()).attributeValue("group-id"))) != 0L) {
                portletDataContext.setSourceGroupId(portletSourceGroupId);
            }
            PortletPreferences portletPreferences2 = this.doImportData(portletDataContext, portletId, portletPreferences, data);
            return portletPreferences2;
        }
        catch (Exception e) {
            throw new PortletDataException(e);
        }
        finally {
            portletDataContext.setSourceGroupId(sourceGroupId);
            if (_log.isInfoEnabled()) {
                long duration = System.currentTimeMillis() - startTime;
                _log.info("Imported portlet in " + Time.getDuration(duration));
            }
        }
    }

    @Override
    public boolean isAlwaysExportable() {
        return false;
    }

    @Override
    public boolean isAlwaysStaged() {
        return false;
    }

    @Override
    public boolean isDataLocalized() {
        return false;
    }

    @Override
    public boolean isPublishToLiveByDefault() {
        return false;
    }

    protected PortletPreferences doDeleteData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        return null;
    }

    protected String doExportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        return null;
    }

    protected PortletPreferences doImportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences, String data) throws Exception {
        return null;
    }
}

