/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.repository.cmis.search;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.DateFormatFactoryUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;

public class CMISParameterValueUtil {
    private static final String _INDEX_DATE_FORMAT_PATTERN = PropsUtil.get("index.date.format.pattern");
    private static Log _log = LogFactoryUtil.getLog(CMISParameterValueUtil.class);

    public static String formatParameterValue(String field, String value) {
        return CMISParameterValueUtil.formatParameterValue(field, value, false);
    }

    public static String formatParameterValue(String field, String value, boolean wildcard) {
        if (field.equals("createDate") || field.equals("modified")) {
            try {
                DateFormat searchSimpleDateFormat = DateFormatFactoryUtil.getSimpleDateFormat(_INDEX_DATE_FORMAT_PATTERN);
                Date date = searchSimpleDateFormat.parse(value);
                DateFormat cmisSimpleDateFormat = DateFormatFactoryUtil.getSimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.000'Z'");
                value = cmisSimpleDateFormat.format(date);
            }
            catch (ParseException parseException) {
                _log.warn("Unable to parse date " + value + " for field " + field);
            }
        } else {
            value = StringUtil.replace(value, new String[]{"'", "_"}, new String[]{"\\'", "\\_"});
            if (wildcard) {
                value = StringUtil.replace(value, new String[]{"%", "*"}, new String[]{"\\%", "%"});
            }
        }
        return value;
    }
}

