/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.search;

import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.DateFormatFactoryUtil;
import com.liferay.portal.kernel.util.FastDateFormatFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.Format;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class DocumentImpl
implements Document {
    private static final String _INDEX_DATE_FORMAT_PATTERN = PropsUtil.get("index.date.format.pattern");
    private static final String _SORTABLE_TEXT_FIELD_SUFFIX = "sortable";
    private static final int _SORTABLE_TEXT_FIELDS_TRUNCATED_LENGTH = GetterUtil.getInteger(PropsUtil.get("index.sortable.text.fields.truncated.length"));
    private static final String _UID_FIELD = "_FIELD_";
    private static final String _UID_PORTLET = "_PORTLET_";
    private static Format _dateFormat = FastDateFormatFactoryUtil.getSimpleDateFormat(_INDEX_DATE_FORMAT_PATTERN);
    private static Set<String> _sortableTextFields = SetUtil.fromArray(PropsUtil.getArray("index.sortable.text.fields"));
    private Map<String, Field> _fields = new HashMap<String, Field>();

    public static String getLocalizedName(Locale locale, String name) {
        String languageId = LocaleUtil.toLanguageId(locale);
        String localizedName = name.concat("_").concat(languageId);
        return localizedName;
    }

    public static String getSortableFieldName(String name) {
        return name.concat("_").concat(_SORTABLE_TEXT_FIELD_SUFFIX);
    }

    public static boolean isSortableTextField(String name) {
        return _sortableTextFields.contains(name);
    }

    @Override
    public void add(Field field) {
        this._fields.put(field.getName(), field);
    }

    @Override
    public void addDate(String name, Date value) {
        if (value == null) {
            return;
        }
        this.addKeyword(name, _dateFormat.format(value));
    }

    @Override
    public void addFile(String name, byte[] bytes, String fileExt) {
        UnsyncByteArrayInputStream is = new UnsyncByteArrayInputStream(bytes);
        this.addFile(name, is, fileExt);
    }

    @Override
    public void addFile(String name, File file, String fileExt) throws IOException {
        FileInputStream is = new FileInputStream(file);
        this.addFile(name, is, fileExt);
    }

    @Override
    public void addFile(String name, InputStream is, String fileExt) {
        this.addText(name, FileUtil.extractText(is, fileExt));
    }

    @Override
    public void addKeyword(String name, boolean value) {
        this.addKeyword(name, String.valueOf(value));
    }

    @Override
    public void addKeyword(String name, Boolean value) {
        this.addKeyword(name, String.valueOf(value));
    }

    @Override
    public void addKeyword(String name, boolean[] values) {
        if (values == null) {
            return;
        }
        this.addKeyword(name, ArrayUtil.toStringArray(values));
    }

    @Override
    public void addKeyword(String name, Boolean[] values) {
        if (values == null) {
            return;
        }
        this.addKeyword(name, ArrayUtil.toStringArray((Object[])values));
    }

    @Override
    public void addKeyword(String name, double value) {
        this.addKeyword(name, String.valueOf(value));
    }

    @Override
    public void addKeyword(String name, Double value) {
        this.addKeyword(name, String.valueOf(value));
    }

    @Override
    public void addKeyword(String name, double[] values) {
        if (values == null) {
            return;
        }
        this.addKeyword(name, ArrayUtil.toStringArray(values));
    }

    @Override
    public void addKeyword(String name, Double[] values) {
        if (values == null) {
            return;
        }
        this.addKeyword(name, ArrayUtil.toStringArray((Object[])values));
    }

    @Override
    public void addKeyword(String name, float value) {
        this.addKeyword(name, String.valueOf(value));
    }

    @Override
    public void addKeyword(String name, Float value) {
        this.addKeyword(name, String.valueOf(value));
    }

    @Override
    public void addKeyword(String name, float[] values) {
        if (values == null) {
            return;
        }
        this.addKeyword(name, ArrayUtil.toStringArray(values));
    }

    @Override
    public void addKeyword(String name, Float[] values) {
        if (values == null) {
            return;
        }
        this.addKeyword(name, ArrayUtil.toStringArray((Object[])values));
    }

    @Override
    public void addKeyword(String name, int value) {
        this.addKeyword(name, String.valueOf(value));
    }

    @Override
    public void addKeyword(String name, int[] values) {
        if (values == null) {
            return;
        }
        this.addKeyword(name, ArrayUtil.toStringArray(values));
    }

    @Override
    public void addKeyword(String name, Integer value) {
        this.addKeyword(name, String.valueOf(value));
    }

    @Override
    public void addKeyword(String name, Integer[] values) {
        if (values == null) {
            return;
        }
        this.addKeyword(name, ArrayUtil.toStringArray((Object[])values));
    }

    @Override
    public void addKeyword(String name, long value) {
        this.addKeyword(name, String.valueOf(value));
    }

    @Override
    public void addKeyword(String name, Long value) {
        this.addKeyword(name, String.valueOf(value));
    }

    @Override
    public void addKeyword(String name, long[] values) {
        if (values == null) {
            return;
        }
        this.addKeyword(name, ArrayUtil.toStringArray(values));
    }

    @Override
    public void addKeyword(String name, Long[] values) {
        if (values == null) {
            return;
        }
        this.addKeyword(name, ArrayUtil.toStringArray((Object[])values));
    }

    @Override
    public void addKeyword(String name, short value) {
        this.addKeyword(name, String.valueOf(value));
    }

    @Override
    public void addKeyword(String name, Short value) {
        this.addKeyword(name, String.valueOf(value));
    }

    @Override
    public void addKeyword(String name, short[] values) {
        if (values == null) {
            return;
        }
        this.addKeyword(name, ArrayUtil.toStringArray(values));
    }

    @Override
    public void addKeyword(String name, Short[] values) {
        if (values == null) {
            return;
        }
        this.addKeyword(name, ArrayUtil.toStringArray((Object[])values));
    }

    @Override
    public void addKeyword(String name, String value) {
        this.addKeyword(name, value, false);
    }

    @Override
    public void addKeyword(String name, String value, boolean lowerCase) {
        if (lowerCase && Validator.isNotNull(value)) {
            value = value.toLowerCase();
        }
        Field field = new Field(name, value);
        String[] stringArray = Field.UNSCORED_FIELD_NAMES;
        int n = Field.UNSCORED_FIELD_NAMES.length;
        int n2 = 0;
        while (n2 < n) {
            String fieldName = stringArray[n2];
            if (name.equalsIgnoreCase(fieldName)) {
                field.setBoost(0.0f);
            }
            ++n2;
        }
        this._fields.put(name, field);
    }

    @Override
    public void addKeyword(String name, String[] values) {
        if (values == null) {
            return;
        }
        Field field = new Field(name, values);
        this._fields.put(name, field);
    }

    @Override
    public void addLocalizedKeyword(String name, Map<Locale, String> values) {
        this.addLocalizedKeyword(name, values, false);
    }

    @Override
    public void addLocalizedKeyword(String name, Map<Locale, String> values, boolean lowerCase) {
        if (values == null || values.isEmpty()) {
            return;
        }
        if (lowerCase) {
            HashMap<Locale, String> lowerCaseValues = new HashMap<Locale, String>(values.size());
            for (Map.Entry<Locale, String> entry : values.entrySet()) {
                String value = GetterUtil.getString(entry.getValue());
                lowerCaseValues.put(entry.getKey(), value.toLowerCase());
            }
            values = lowerCaseValues;
        }
        Field field = new Field(name, values);
        this._fields.put(name, field);
    }

    @Override
    public void addLocalizedText(String name, Map<Locale, String> values) {
        if (values == null || values.isEmpty()) {
            return;
        }
        Field field = new Field(name, values);
        field.setTokenized(true);
        this._fields.put(name, field);
    }

    @Override
    public void addModifiedDate() {
        this.addModifiedDate(new Date());
    }

    @Override
    public void addModifiedDate(Date modifiedDate) {
        this.addDate("modified", modifiedDate);
    }

    @Override
    public void addNumber(String name, double value) {
        this.addNumber(name, String.valueOf(value), Double.class);
    }

    @Override
    public void addNumber(String name, Double value) {
        this.addNumber(name, String.valueOf(value), Double.class);
    }

    @Override
    public void addNumber(String name, double[] values) {
        this.addNumber(name, ArrayUtil.toStringArray(values), Double.class);
    }

    @Override
    public void addNumber(String name, Double[] values) {
        this.addNumber(name, ArrayUtil.toStringArray((Object[])values), Double.class);
    }

    @Override
    public void addNumber(String name, float value) {
        this.addNumber(name, String.valueOf(value), Float.class);
    }

    @Override
    public void addNumber(String name, Float value) {
        this.addNumber(name, String.valueOf(value), Float.class);
    }

    @Override
    public void addNumber(String name, float[] values) {
        this.addNumber(name, ArrayUtil.toStringArray(values), Float.class);
    }

    @Override
    public void addNumber(String name, Float[] values) {
        this.addNumber(name, ArrayUtil.toStringArray((Object[])values), Float.class);
    }

    @Override
    public void addNumber(String name, int value) {
        this.addNumber(name, String.valueOf(value), Integer.class);
    }

    @Override
    public void addNumber(String name, int[] values) {
        this.addNumber(name, ArrayUtil.toStringArray(values), Integer.class);
    }

    @Override
    public void addNumber(String name, Integer value) {
        this.addNumber(name, String.valueOf(value), Integer.class);
    }

    @Override
    public void addNumber(String name, Integer[] values) {
        this.addNumber(name, ArrayUtil.toStringArray((Object[])values), Integer.class);
    }

    @Override
    public void addNumber(String name, long value) {
        this.addNumber(name, String.valueOf(value), Long.class);
    }

    @Override
    public void addNumber(String name, Long value) {
        this.addNumber(name, String.valueOf(value), Long.class);
    }

    @Override
    public void addNumber(String name, long[] values) {
        this.addNumber(name, ArrayUtil.toStringArray(values), Long.class);
    }

    @Override
    public void addNumber(String name, Long[] values) {
        this.addNumber(name, ArrayUtil.toStringArray((Object[])values), Long.class);
    }

    @Override
    public void addNumber(String name, String value) {
        this.addNumber(name, value, Long.class);
    }

    public void addNumber(String name, String value, Class<? extends Number> clazz) {
        if (Validator.isNotNull(value)) {
            Field field = new Field(name, value);
            field.setNumeric(true);
            field.setNumericClass(clazz);
            this._fields.put(name, field);
        }
    }

    @Override
    public void addNumber(String name, String[] values) {
        this.addNumber(name, values, Long.class);
    }

    public void addNumber(String name, String[] values, Class<? extends Number> clazz) {
        if (values == null) {
            return;
        }
        Field field = new Field(name, values);
        field.setNumeric(true);
        field.setNumericClass(clazz);
        this._fields.put(name, field);
    }

    @Override
    public void addText(String name, String value) {
        if (Validator.isNull(value)) {
            return;
        }
        Field field = new Field(name, value);
        field.setTokenized(true);
        this._fields.put(name, field);
        if (_sortableTextFields.contains(name)) {
            String truncatedValue = value;
            if (value.length() > _SORTABLE_TEXT_FIELDS_TRUNCATED_LENGTH) {
                truncatedValue = value.substring(0, _SORTABLE_TEXT_FIELDS_TRUNCATED_LENGTH);
            }
            this.addKeyword(DocumentImpl.getSortableFieldName(name), truncatedValue, true);
        }
    }

    @Override
    public void addText(String name, String[] values) {
        if (values == null) {
            return;
        }
        Field field = new Field(name, values);
        field.setTokenized(true);
        this._fields.put(name, field);
    }

    @Override
    public void addUID(String portletId, long field1) {
        this.addUID(portletId, String.valueOf(field1));
    }

    @Override
    public void addUID(String portletId, long field1, String field2) {
        this.addUID(portletId, String.valueOf(field1), field2);
    }

    @Override
    public void addUID(String portletId, Long field1) {
        this.addUID(portletId, (long)field1);
    }

    @Override
    public void addUID(String portletId, Long field1, String field2) {
        this.addUID(portletId, (long)field1, field2);
    }

    @Override
    public void addUID(String portletId, String field1) {
        this.addUID(portletId, field1, null);
    }

    @Override
    public void addUID(String portletId, String field1, String field2) {
        this.addUID(portletId, field1, field2, null);
    }

    @Override
    public void addUID(String portletId, String field1, String field2, String field3) {
        this.addUID(portletId, field1, field2, field3, null);
    }

    @Override
    public void addUID(String portletId, String field1, String field2, String field3, String field4) {
        String uid = String.valueOf(portletId) + _UID_PORTLET + field1;
        if (field2 != null) {
            uid = String.valueOf(uid) + _UID_FIELD + field2;
        }
        if (field3 != null) {
            uid = String.valueOf(uid) + _UID_FIELD + field3;
        }
        if (field4 != null) {
            uid = String.valueOf(uid) + _UID_FIELD + field4;
        }
        this.addKeyword("uid", uid);
    }

    @Override
    public String get(Locale locale, String name) {
        String localizedName = DocumentImpl.getLocalizedName(locale, name);
        Field field = this._fields.get(localizedName);
        if (field == null) {
            field = this._fields.get(name);
        }
        if (field == null) {
            return "";
        }
        return field.getValue();
    }

    @Override
    public String get(String name) {
        Field field = this._fields.get(name);
        if (field == null) {
            return "";
        }
        return field.getValue();
    }

    @Override
    public Date getDate(String name) throws ParseException {
        DateFormat dateFormat = DateFormatFactoryUtil.getSimpleDateFormat(_INDEX_DATE_FORMAT_PATTERN);
        return dateFormat.parse(this.get(name));
    }

    @Override
    public Map<String, Field> getFields() {
        return this._fields;
    }

    @Override
    public String getPortletId() {
        String uid = this.getUID();
        int pos = uid.indexOf(_UID_PORTLET);
        return uid.substring(0, pos);
    }

    @Override
    public String getUID() {
        Field field = this._fields.get("uid");
        if (field == null) {
            throw new RuntimeException("UID is not set");
        }
        return field.getValue();
    }

    @Override
    public String[] getValues(String name) {
        Field field = this._fields.get(name);
        if (field == null) {
            return new String[]{""};
        }
        return field.getValues();
    }

    @Override
    public void remove(String name) {
        this._fields.remove(name);
    }

    public void setFields(Map<String, Field> fields) {
        this._fields = fields;
    }

    public String toString() {
        StringBundler sb = new StringBundler();
        sb.append("{");
        boolean firstField = true;
        for (Field field : this._fields.values()) {
            if (!firstField) {
                sb.append(",");
                sb.append(" ");
            } else {
                firstField = false;
            }
            sb.append(field.getName());
            sb.append("=");
            sb.append(Arrays.toString(field.getValues()));
        }
        sb.append("}");
        return sb.toString();
    }
}

