/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.search;

import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.theme.ThemeDisplay;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class SearchContextFactory {
    public static SearchContext getInstance(HttpServletRequest request) {
        SearchContext searchContext = new SearchContext();
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("THEME_DISPLAY");
        searchContext.setCompanyId(themeDisplay.getCompanyId());
        searchContext.setGroupIds(new long[]{themeDisplay.getScopeGroupId()});
        searchContext.setLayout(themeDisplay.getLayout());
        searchContext.setLocale(themeDisplay.getLocale());
        searchContext.setTimeZone(themeDisplay.getTimeZone());
        searchContext.setUserId(themeDisplay.getUserId());
        HashMap<String, Serializable> attributes = new HashMap<String, Serializable>();
        Map parameters = request.getParameterMap();
        for (Map.Entry entry : parameters.entrySet()) {
            String name = (String)entry.getKey();
            String[] values = (String[])entry.getValue();
            if (values == null || values.length <= 0) continue;
            if (values.length == 1) {
                attributes.put(name, (Serializable)((Object)values[0]));
                continue;
            }
            attributes.put(name, (Serializable)values);
        }
        searchContext.setAttributes(attributes);
        long[] assetCategoryIds = StringUtil.split(ParamUtil.getString(request, "assetCategoryIds"), 0L);
        String[] assetTagNames = StringUtil.split(ParamUtil.getString(request, "assetTagNames"));
        searchContext.setAssetCategoryIds(assetCategoryIds);
        searchContext.setAssetTagNames(assetTagNames);
        String keywords = ParamUtil.getString(request, "keywords");
        searchContext.setKeywords(keywords);
        QueryConfig queryConfig = new QueryConfig();
        queryConfig.setLocale(themeDisplay.getLocale());
        searchContext.setQueryConfig(queryConfig);
        return searchContext;
    }
}

