/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import com.liferay.portal.kernel.util.ArrayUtil;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class DynamicServletRequest
extends HttpServletRequestWrapper {
    private boolean _inherit;
    private Map<String, String[]> _params = new HashMap<String, String[]>();

    public DynamicServletRequest(HttpServletRequest request) {
        this(request, null, true);
    }

    public DynamicServletRequest(HttpServletRequest request, boolean inherit) {
        this(request, null, inherit);
    }

    public DynamicServletRequest(HttpServletRequest request, Map<String, String[]> params) {
        this(request, params, true);
    }

    public DynamicServletRequest(HttpServletRequest request, Map<String, String[]> params, boolean inherit) {
        super(request);
        this._inherit = inherit;
        if (params != null) {
            this._params.putAll(params);
        }
        if (this._inherit && request instanceof DynamicServletRequest) {
            DynamicServletRequest dynamicRequest = (DynamicServletRequest)request;
            this.setRequest(dynamicRequest.getRequest());
            params = dynamicRequest.getDynamicParameterMap();
            for (Map.Entry<String, String[]> entry : params.entrySet()) {
                String name = entry.getKey();
                String[] oldValues = entry.getValue();
                String[] curValues = this._params.get(name);
                if (curValues == null) {
                    this._params.put(name, oldValues);
                    continue;
                }
                String[] newValues = ArrayUtil.append(oldValues, curValues);
                this._params.put(name, newValues);
            }
        }
    }

    public Map<String, String[]> getDynamicParameterMap() {
        return this._params;
    }

    public String getParameter(String name) {
        String[] values = this._params.get(name);
        if (this._inherit && values == null) {
            return super.getParameter(name);
        }
        if (values != null && values.length > 0) {
            return values[0];
        }
        return null;
    }

    public Map<String, String[]> getParameterMap() {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        if (this._inherit) {
            map.putAll(super.getParameterMap());
        }
        map.putAll(this._params);
        return map;
    }

    public Enumeration<String> getParameterNames() {
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        if (this._inherit) {
            Enumeration enu = super.getParameterNames();
            while (enu.hasMoreElements()) {
                names.add((String)enu.nextElement());
            }
        }
        names.addAll(this._params.keySet());
        return Collections.enumeration(names);
    }

    public String[] getParameterValues(String name) {
        String[] values = this._params.get(name);
        if (this._inherit && values == null) {
            return super.getParameterValues(name);
        }
        return values;
    }

    public void setParameter(String name, String value) {
        this._params.put(name, new String[]{value});
    }

    public void setParameterValues(String name, String[] values) {
        this._params.put(name, values);
    }
}

