/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import com.liferay.portal.kernel.servlet.ServletContextUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;

public class FileTimestampUtil {
    private static Map<String, Long> _timestamps = new ConcurrentHashMap<String, Long>();

    public static long getTimestamp(ServletContext servletContext, String path) {
        return FileTimestampUtil.getTimestamp(servletContext, path, 0L);
    }

    public static long getTimestamp(ServletContext servletContext, String path, long defaultTimestamp) {
        File uriFile;
        if (Validator.isNull(path)) {
            return defaultTimestamp;
        }
        if (path.charAt(0) != '/') {
            return defaultTimestamp;
        }
        Long timestamp = _timestamps.get(path);
        if (timestamp != null) {
            return timestamp;
        }
        timestamp = defaultTimestamp;
        String uriRealPath = ServletContextUtil.getRealPath(servletContext, path);
        if (uriRealPath != null && (uriFile = new File(uriRealPath)).exists()) {
            timestamp = uriFile.lastModified();
        }
        _timestamps.put(path, timestamp);
        return timestamp;
    }

    public static void reset() {
        _timestamps.clear();
    }
}

