/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PortalDelegatorServlet
extends HttpServlet {
    private static Map<String, HttpServlet> _delegates = new HashMap<String, HttpServlet>();

    public static void addDelegate(String subContext, HttpServlet delegate) {
        if (subContext == null) {
            throw new IllegalArgumentException();
        }
        if (delegate == null) {
            throw new IllegalArgumentException();
        }
        _delegates.put(subContext, delegate);
    }

    public static void removeDelegate(String subContext) {
        if (subContext == null) {
            throw new IllegalArgumentException();
        }
        _delegates.remove(subContext);
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String uri = request.getPathInfo();
        if (uri == null || uri.length() == 0) {
            throw new ServletException("Path information is not specified");
        }
        String[] paths = uri.split("/");
        if (paths.length < 2) {
            throw new ServletException("Path " + uri + " is invalid");
        }
        HttpServlet delegate = _delegates.get(paths[1]);
        if (delegate == null) {
            throw new ServletException("No servlet registred for context " + paths[1]);
        }
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        try {
            ClassLoader delegateClassLoader = delegate.getClass().getClassLoader();
            currentThread.setContextClassLoader(delegateClassLoader);
            delegate.service((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            currentThread.setContextClassLoader(contextClassLoader);
        }
    }
}

