/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import com.liferay.portal.kernel.concurrent.ConcurrentHashSet;
import com.liferay.portal.kernel.servlet.PortletSessionListenerManager;
import com.liferay.portal.kernel.servlet.filters.compoundsessionid.CompoundSessionIdSplitterUtil;
import java.io.Serializable;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

public class PortletSessionTracker
implements HttpSessionListener,
HttpSessionBindingListener,
Serializable {
    private static PortletSessionTracker _instance = new PortletSessionTracker();
    private transient ConcurrentMap<String, Set<HttpSession>> _sessions = new ConcurrentHashMap<String, Set<HttpSession>>();

    public static void add(HttpSession session) {
        _instance._add(session);
    }

    public static HttpSessionBindingListener getInstance() {
        return _instance;
    }

    public static void invalidate(HttpSession session) {
        _instance._invalidate(session.getId());
    }

    public static void invalidate(String sessionId) {
        _instance._invalidate(sessionId);
    }

    public void sessionCreated(HttpSessionEvent httpSessionEvent) {
    }

    public void sessionDestroyed(HttpSessionEvent httpSessionEvent) {
        this._invalidate(httpSessionEvent.getSession().getId());
    }

    public void valueBound(HttpSessionBindingEvent event) {
    }

    public void valueUnbound(HttpSessionBindingEvent event) {
        PortletSessionTracker.invalidate(event.getSession().getId());
    }

    private PortletSessionTracker() {
        PortletSessionListenerManager.addHttpSessionListener(this);
    }

    private void _add(HttpSession session) {
        Set previousSessions;
        Set<Object> sessions;
        String sessionId = session.getId();
        if (CompoundSessionIdSplitterUtil.hasSessionDelimiter()) {
            sessionId = CompoundSessionIdSplitterUtil.parseSessionId(sessionId);
        }
        if ((sessions = (ConcurrentHashSet<HttpSession>)this._sessions.get(sessionId)) == null && (previousSessions = (Set)this._sessions.putIfAbsent(sessionId, sessions = new ConcurrentHashSet<HttpSession>())) != null) {
            sessions = previousSessions;
        }
        sessions.add(session);
    }

    private void _invalidate(String sessionId) {
        Set sessions;
        if (CompoundSessionIdSplitterUtil.hasSessionDelimiter()) {
            sessionId = CompoundSessionIdSplitterUtil.parseSessionId(sessionId);
        }
        if ((sessions = (Set)this._sessions.remove(sessionId)) == null) {
            return;
        }
        for (HttpSession session : sessions) {
            try {
                session.invalidate();
            }
            catch (Exception exception) {}
        }
    }
}

