/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import com.liferay.portal.kernel.servlet.ProtectedPrincipal;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class ProtectedServletRequest
extends HttpServletRequestWrapper {
    private String _authType;
    private String _remoteUser;
    private Principal _userPrincipal;

    public ProtectedServletRequest(HttpServletRequest request, String remoteUser) {
        this(request, remoteUser, null);
    }

    public ProtectedServletRequest(HttpServletRequest request, String remoteUser, String authType) {
        super(request);
        if (request instanceof ProtectedServletRequest) {
            ProtectedServletRequest parentRequest = (ProtectedServletRequest)request;
            this.setRequest(parentRequest.getRequest());
        }
        this._remoteUser = remoteUser;
        if (remoteUser != null) {
            this._userPrincipal = new ProtectedPrincipal(remoteUser);
        }
        this._authType = authType;
    }

    public String getAuthType() {
        if (this._authType == null) {
            return super.getAuthType();
        }
        return this._authType;
    }

    public String getRemoteUser() {
        if (this._remoteUser != null) {
            return this._remoteUser;
        }
        return super.getRemoteUser();
    }

    public Principal getUserPrincipal() {
        if (this._userPrincipal != null) {
            return this._userPrincipal;
        }
        return super.getUserPrincipal();
    }
}

