/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet.taglib;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.BodyContentWrapper;
import com.liferay.portal.kernel.servlet.taglib.TagSupport;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.StringBundler;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTag;

public class BaseBodyTagSupport
extends TagSupport {
    protected BodyContent bodyContent;
    private static Log _log = LogFactoryUtil.getLog(BaseBodyTagSupport.class);

    public int doAfterBody() throws JspException {
        return 0;
    }

    public void doInitBody() throws JspException {
    }

    @Override
    public int doStartTag() throws JspException {
        return 2;
    }

    public BodyContent getBodyContent() {
        return this.bodyContent;
    }

    public StringBundler getBodyContentAsStringBundler() {
        String bodyContentString;
        if (!(this instanceof BodyTag)) {
            throw new RuntimeException(String.valueOf(this.getClass().getName()) + " must implement " + BodyTag.class.getName());
        }
        BodyContent bodyContent = this.getBodyContent();
        if (bodyContent instanceof BodyContentWrapper) {
            BodyContentWrapper bodyContentWrapper = (BodyContentWrapper)bodyContent;
            return bodyContentWrapper.getStringBundler();
        }
        if (ServerDetector.isTomcat() && _log.isWarnEnabled()) {
            _log.warn("BodyContent is not BodyContentWrapper. Check JspFactorySwapper.");
        }
        if ((bodyContentString = bodyContent.getString()) == null) {
            bodyContentString = "";
        }
        return new StringBundler(bodyContentString);
    }

    @Override
    public void release() {
        this.bodyContent = null;
        super.release();
    }

    public void setBodyContent(BodyContent bodyContent) {
        this.bodyContent = bodyContent;
    }

    public void writeBodyContent(Writer writer) throws IOException {
        StringBundler sb = this.getBodyContentAsStringBundler();
        sb.writeTo(writer);
    }
}

