/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet.taglib.aui;

import com.liferay.portal.kernel.servlet.BrowserSnifferUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.http.HttpServletRequest;

public class ScriptData {
    private ConcurrentMap<String, PortletData> _portletDataMap = new ConcurrentHashMap<String, PortletData>();

    public void append(String portletId, String content, String use) {
        PortletData portletData = this._getPortletData(portletId);
        portletData.append(content, use);
    }

    public void append(String portletId, StringBundler contentSB, String use) {
        PortletData portletData = this._getPortletData(portletId);
        portletData.append(contentSB, use);
    }

    public void writeTo(HttpServletRequest request, Writer writer) throws IOException {
        writer.write("<script type=\"text/javascript\">\n// <![CDATA[\n");
        StringBundler callbackSB = new StringBundler();
        for (PortletData portletData : this._portletDataMap.values()) {
            portletData._rawSB.writeTo(writer);
            callbackSB.append(portletData._callbackSB);
        }
        if (callbackSB.index() == 0) {
            writer.write("\n// ]]>\n</script>");
            return;
        }
        String loadMethod = "use";
        if (BrowserSnifferUtil.isIe(request) && BrowserSnifferUtil.getMajorVersion(request) < 8.0f) {
            loadMethod = "ready";
        }
        writer.write("AUI().");
        writer.write(loadMethod);
        writer.write("(");
        TreeSet useSet = new TreeSet();
        for (PortletData portletData : this._portletDataMap.values()) {
            useSet.addAll(portletData._useSet);
        }
        for (String use : useSet) {
            writer.write("'");
            writer.write(use);
            writer.write("'");
            writer.write(", ");
        }
        writer.write("function(A) {");
        callbackSB.writeTo(writer);
        writer.write("});");
        writer.write("\n// ]]>\n</script>");
    }

    private PortletData _getPortletData(String portletId) {
        PortletData oldPortletData;
        PortletData portletData;
        if (Validator.isNull(portletId)) {
            portletId = "";
        }
        if ((portletData = (PortletData)this._portletDataMap.get(portletId)) == null && (oldPortletData = this._portletDataMap.putIfAbsent(portletId, portletData = new PortletData())) != null) {
            portletData = oldPortletData;
        }
        return portletData;
    }

    private class PortletData
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private StringBundler _callbackSB = new StringBundler();
        private StringBundler _rawSB = new StringBundler();
        private Set<String> _useSet = new TreeSet<String>();

        private PortletData() {
        }

        public void append(String content, String use) {
            if (Validator.isNull(use)) {
                this._rawSB.append(content);
            } else {
                this._callbackSB.append("(function() {");
                this._callbackSB.append(content);
                this._callbackSB.append("})();");
                String[] useArray = StringUtil.split(use);
                int i = 0;
                while (i < useArray.length) {
                    this._useSet.add(useArray[i]);
                    ++i;
                }
            }
        }

        public void append(StringBundler contentSB, String use) {
            if (Validator.isNull(use)) {
                this._rawSB.append(contentSB);
            } else {
                this._callbackSB.append("(function() {");
                this._callbackSB.append(contentSB);
                this._callbackSB.append("})();");
                String[] useArray = StringUtil.split(use);
                int i = 0;
                while (i < useArray.length) {
                    this._useSet.add(useArray[i]);
                    ++i;
                }
            }
        }
    }
}

