/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.templateparser;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.Layout;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class TemplateNode
extends LinkedHashMap<String, Object> {
    private static final String _LAYOUT_TYPE_PRIVATE_GROUP = "private-group";
    private static final String _LAYOUT_TYPE_PRIVATE_USER = "private-user";
    private static final String _LAYOUT_TYPE_PUBLIC = "public";
    private static Log _log = LogFactoryUtil.getLog(TemplateNode.class);
    private Map<String, TemplateNode> _childTemplateNodes = new LinkedHashMap<String, TemplateNode>();
    private List<TemplateNode> _siblingTemplateNodes = new ArrayList<TemplateNode>();
    private ThemeDisplay _themeDisplay;

    public TemplateNode(ThemeDisplay themeDisplay, String name, String data, String type) {
        this._themeDisplay = themeDisplay;
        this.put("name", name);
        this.put("data", data);
        this.put("type", type);
        this.put("options", new ArrayList());
    }

    public void appendChild(TemplateNode templateNode) {
        this._childTemplateNodes.put(templateNode.getName(), templateNode);
        this.put(templateNode.getName(), templateNode);
    }

    public void appendChildren(List<TemplateNode> templateNodes) {
        for (TemplateNode templateNode : templateNodes) {
            this.appendChild(templateNode);
        }
    }

    public void appendOption(String option) {
        List<String> options = this.getOptions();
        options.add(option);
    }

    public void appendOptions(List<String> options) {
        List<String> curOptions = this.getOptions();
        curOptions.addAll(options);
    }

    public void appendSibling(TemplateNode templateNode) {
        this._siblingTemplateNodes.add(templateNode);
    }

    public TemplateNode getChild(String name) {
        return this._childTemplateNodes.get(name);
    }

    public List<TemplateNode> getChildren() {
        return new ArrayList<TemplateNode>(this._childTemplateNodes.values());
    }

    public String getData() {
        String type = this.getType();
        if (type.equals("link_to_layout")) {
            String data = (String)this.get("data");
            int pos = data.indexOf(64);
            if (pos != -1) {
                data = data.substring(0, pos);
            }
            return data;
        }
        return (String)this.get("data");
    }

    public String getFriendlyUrl() {
        if (this._themeDisplay == null) {
            return this.getUrl();
        }
        String type = this.getType();
        if (!type.equals("link_to_layout")) {
            return "";
        }
        String layoutType = this.getLayoutType();
        boolean privateLayout = layoutType.startsWith("private");
        try {
            Layout layout = LayoutLocalServiceUtil.getLayout(this._themeDisplay.getScopeGroupId(), privateLayout, this.getLayoutId());
            return PortalUtil.getLayoutFriendlyURL(layout, this._themeDisplay);
        }
        catch (Exception e) {
            if (_log.isDebugEnabled()) {
                _log.debug("Error finding friendly URL on page " + this._themeDisplay.getURLCurrent(), e);
            }
            return this.getUrl();
        }
    }

    public String getName() {
        return (String)this.get("name");
    }

    public List<String> getOptions() {
        return (List)this.get("options");
    }

    public List<TemplateNode> getSiblings() {
        return this._siblingTemplateNodes;
    }

    public String getType() {
        return (String)this.get("type");
    }

    public String getUrl() {
        String type = this.getType();
        if (!type.equals("link_to_layout")) {
            return "";
        }
        StringBundler sb = new StringBundler(5);
        String layoutType = this.getLayoutType();
        if (layoutType.equals(_LAYOUT_TYPE_PRIVATE_GROUP)) {
            sb.append(PortalUtil.getPathFriendlyURLPrivateGroup());
        } else if (layoutType.equals(_LAYOUT_TYPE_PRIVATE_USER)) {
            sb.append(PortalUtil.getPathFriendlyURLPrivateUser());
        } else if (layoutType.equals(_LAYOUT_TYPE_PUBLIC)) {
            sb.append(PortalUtil.getPathFriendlyURLPublic());
        } else {
            sb.append("@friendly_url_current@");
        }
        sb.append("/");
        sb.append("@group_id@");
        sb.append("/");
        sb.append(this.getLayoutId());
        return sb.toString();
    }

    protected long getLayoutId() {
        String data = (String)this.get("data");
        int pos = data.indexOf(64);
        if (pos != -1) {
            data = data.substring(0, pos);
        }
        return GetterUtil.getLong(data);
    }

    protected String getLayoutType() {
        String data = (String)this.get("data");
        int pos = data.indexOf(64);
        if (pos != -1) {
            data = data.substring(pos + 1);
        }
        return data;
    }
}

