/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.test;

import com.liferay.portal.kernel.process.ClassPathUtil;
import com.liferay.portal.kernel.test.DescriptionComparator;
import com.liferay.portal.kernel.util.MethodCache;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.junit.After;
import org.junit.Before;
import org.junit.runner.manipulation.Sorter;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;

public class NewClassLoaderJUnitTestRunner
extends BlockJUnit4ClassRunner {
    public NewClassLoaderJUnitTestRunner(Class<?> clazz) throws InitializationError {
        super(clazz);
        this.sort(new Sorter((Comparator)new DescriptionComparator()));
    }

    protected ClassLoader createClassLoader(FrameworkMethod frameworkMethod) {
        String jvmClassPath = ClassPathUtil.getJVMClassPath(true);
        URL[] urls = null;
        try {
            urls = ClassPathUtil.getClassPathURLs(jvmClassPath);
        }
        catch (MalformedURLException murle) {
            throw new RuntimeException(murle);
        }
        return new URLClassLoader(urls, null);
    }

    protected Statement methodBlock(FrameworkMethod frameworkMethod) {
        TestClass testClass = this.getTestClass();
        List beforeFrameworkMethods = testClass.getAnnotatedMethods(Before.class);
        List afterFrameworkMethods = testClass.getAnnotatedMethods(After.class);
        Class clazz = testClass.getJavaClass();
        return new RunInNewClassLoaderStatement(clazz, beforeFrameworkMethods, frameworkMethod, afterFrameworkMethods);
    }

    private class RunInNewClassLoaderStatement
    extends Statement {
        private List<MethodKey> _afterMethodKeys;
        private List<MethodKey> _beforeMethodKeys;
        private ClassLoader _newClassLoader;
        private String _testClassName;
        private MethodKey _testMethodKey;

        public RunInNewClassLoaderStatement(Class<?> testClass, List<FrameworkMethod> beforeFrameworkMethods, FrameworkMethod testFrameworkMethod, List<FrameworkMethod> afterFrameworkMethods) {
            this._testClassName = testClass.getName();
            this._beforeMethodKeys = new ArrayList<MethodKey>(beforeFrameworkMethods.size());
            for (FrameworkMethod frameworkMethod : beforeFrameworkMethods) {
                this._beforeMethodKeys.add(new MethodKey(frameworkMethod.getMethod()));
            }
            this._testMethodKey = new MethodKey(testFrameworkMethod.getMethod());
            this._afterMethodKeys = new ArrayList<MethodKey>(afterFrameworkMethods.size());
            for (FrameworkMethod frameworkMethod : afterFrameworkMethods) {
                this._afterMethodKeys.add(new MethodKey(frameworkMethod.getMethod()));
            }
            this._newClassLoader = NewClassLoaderJUnitTestRunner.this.createClassLoader(testFrameworkMethod);
        }

        public void evaluate() throws Throwable {
            MethodCache.reset();
            Thread currentThread = Thread.currentThread();
            ClassLoader contextClassLoader = currentThread.getContextClassLoader();
            currentThread.setContextClassLoader(this._newClassLoader);
            try {
                try {
                    Class<?> clazz = this._newClassLoader.loadClass(this._testClassName);
                    Object object = clazz.newInstance();
                    for (MethodKey beforeMethodKey : this._beforeMethodKeys) {
                        this._invoke(beforeMethodKey, object);
                    }
                    this._invoke(this._testMethodKey, object);
                    for (MethodKey afterMethodKey : this._afterMethodKeys) {
                        this._invoke(afterMethodKey, object);
                    }
                }
                catch (InvocationTargetException ite) {
                    throw ite.getTargetException();
                }
            }
            finally {
                currentThread.setContextClassLoader(contextClassLoader);
            }
        }

        private void _invoke(MethodKey methodKey, Object object) throws Exception {
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[0]);
            methodHandler.invoke(object);
        }
    }
}

