/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.test;

import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.InputStream;
import java.sql.Blob;
import java.util.Arrays;
import java.util.Map;

public class TestCase
extends junit.framework.TestCase {
    protected void assertEquals(Blob expectedBlob, Blob actualBlob) throws Exception {
        int expectValue;
        InputStream expectInputStream = expectedBlob.getBinaryStream();
        InputStream actualInputStream = actualBlob.getBinaryStream();
        do {
            expectValue = expectInputStream.read();
            int actualValue = actualInputStream.read();
            TestCase.assertEquals((int)expectValue, (int)actualValue);
        } while (expectValue != -1);
        expectInputStream.close();
        actualInputStream.close();
    }

    protected void assertEquals(double expectedDouble, double actualDouble) throws Exception {
        TestCase.assertEquals((double)expectedDouble, (double)actualDouble, (double)0.0);
    }

    protected void assertEquals(Map<String, ?> expectedMap, Map<String, ?> actualMap) {
        TestCase.assertEquals((String)"The maps are different sizes", (int)expectedMap.size(), (int)actualMap.size());
        for (String name : expectedMap.keySet()) {
            TestCase.assertEquals((String)("The values for key '" + name + "' are different"), (String)MapUtil.getString(expectedMap, name), (String)MapUtil.getString(actualMap, name));
        }
    }

    protected void assertEqualsIgnoreCase(String expectedString, String actualString) {
        if (expectedString != null) {
            expectedString = expectedString.toLowerCase();
        }
        if (actualString != null) {
            actualString = actualString.toLowerCase();
        }
        TestCase.assertEquals((String)expectedString, (String)actualString);
    }

    protected void assertEqualsSorted(String[] expectedStringArray, String[] actualStringArray) {
        if (expectedStringArray != null) {
            Arrays.sort(expectedStringArray);
        }
        if (actualStringArray != null) {
            Arrays.sort(actualStringArray);
        }
        TestCase.assertEquals((String)StringUtil.merge(expectedStringArray), (String)StringUtil.merge(actualStringArray));
    }

    protected void assertLessThan(double expectedDouble, double actualDouble) throws Exception {
        if (actualDouble > expectedDouble) {
            TestCase.fail((String)(String.valueOf(actualDouble) + " is not less than " + expectedDouble));
        }
    }
}

