/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import java.util.HashMap;
import java.util.Map;

public class ClassResolverUtil {
    private static final Map<String, Class<?>> _primitiveClasses = new HashMap(9, 1.0f);

    static {
        _primitiveClasses.put("boolean", Boolean.TYPE);
        _primitiveClasses.put("byte", Byte.TYPE);
        _primitiveClasses.put("char", Character.TYPE);
        _primitiveClasses.put("short", Short.TYPE);
        _primitiveClasses.put("int", Integer.TYPE);
        _primitiveClasses.put("long", Long.TYPE);
        _primitiveClasses.put("float", Float.TYPE);
        _primitiveClasses.put("double", Double.TYPE);
        _primitiveClasses.put("void", Void.TYPE);
    }

    public static Class<?> resolve(String className, ClassLoader classLoader) throws ClassNotFoundException {
        try {
            return Class.forName(className, false, classLoader);
        }
        catch (ClassNotFoundException cnfe) {
            Class<?> clazz = _primitiveClasses.get(className);
            if (clazz != null) {
                return clazz;
            }
            throw cnfe;
        }
    }
}

