/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class ServiceLoader {
    private static Log _log = LogFactoryUtil.getLog(ServiceLoader.class);

    public static <S> List<S> load(Class<S> clazz) throws Exception {
        Thread currentThread = Thread.currentThread();
        ClassLoader classLoader = currentThread.getContextClassLoader();
        Enumeration<URL> enu = classLoader.getResources("META-INF/services/" + clazz.getName());
        ArrayList services = new ArrayList();
        while (enu.hasMoreElements()) {
            URL url = enu.nextElement();
            try {
                ServiceLoader._load(services, classLoader, clazz, url);
            }
            catch (Exception exception) {
                _log.error("Unable to load " + clazz + "with " + classLoader);
            }
        }
        return services;
    }

    private static <S> void _load(List<S> services, ClassLoader classLoader, Class<S> clazz, URL url) throws Exception {
        InputStream inputStream = url.openStream();
        try {
            String line;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            while ((line = bufferedReader.readLine()) != null) {
                String name;
                int comment = line.indexOf(35);
                if (comment >= 0) {
                    line = line.substring(0, comment);
                }
                if ((name = line.trim()).length() == 0) continue;
                Class<?> serviceClass = Class.forName(name, true, classLoader);
                Class<S> serviceImplClass = serviceClass.asSubclass(clazz);
                Constructor<S> constructor = serviceImplClass.getConstructor(new Class[0]);
                S service = constructor.newInstance(new Object[0]);
                services.add(service);
            }
        }
        finally {
            inputStream.close();
        }
    }
}

