/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.memory.SoftReferenceThreadLocal;
import com.liferay.portal.kernel.util.CharBufferPool;
import com.liferay.portal.kernel.util.GetterUtil;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Constructor;

public class StringBundler {
    private static final int _DEFAULT_ARRAY_CAPACITY = 16;
    private static final String _FALSE = "false";
    private static final int _THREADLOCAL_BUFFER_LIMIT = GetterUtil.getInteger(System.getProperty(String.valueOf(StringBundler.class.getName()) + ".threadlocal.buffer.limit"));
    private static final String _TRUE = "true";
    private static final int _UNSAFE_CREATE_LIMIT = GetterUtil.getInteger(System.getProperty(String.valueOf(StringBundler.class.getName()) + ".unsafe.create.limit"));
    private static ThreadLocal<StringBuilder> _stringBuilderThreadLocal;
    private static Constructor<String> _stringConstructor;
    private static int _threadLocalBufferLimit;
    private static int _unsafeCreateLimit;
    private String[] _array;
    private int _arrayIndex;

    static {
        if (_THREADLOCAL_BUFFER_LIMIT > 0) {
            _stringBuilderThreadLocal = new SoftReferenceThreadLocal<StringBuilder>();
            _threadLocalBufferLimit = _THREADLOCAL_BUFFER_LIMIT;
        } else {
            _stringBuilderThreadLocal = null;
            _threadLocalBufferLimit = Integer.MAX_VALUE;
        }
        if (_UNSAFE_CREATE_LIMIT > 0) {
            try {
                _unsafeCreateLimit = _UNSAFE_CREATE_LIMIT;
                _stringConstructor = String.class.getDeclaredConstructor(Integer.TYPE, Integer.TYPE, char[].class);
                _stringConstructor.setAccessible(true);
            }
            catch (Exception exception) {}
        } else {
            _unsafeCreateLimit = Integer.MAX_VALUE;
            _stringConstructor = null;
        }
    }

    public StringBundler() {
        this._array = new String[16];
    }

    public StringBundler(int initialCapacity) {
        if (initialCapacity <= 0) {
            initialCapacity = 16;
        }
        this._array = new String[initialCapacity];
    }

    public StringBundler(String s) {
        this._array = new String[16];
        this._array[0] = s;
        this._arrayIndex = 1;
    }

    public StringBundler(String[] stringArray) {
        this(stringArray, 0);
    }

    public StringBundler(String[] stringArray, int extraSpace) {
        this._array = new String[stringArray.length + extraSpace];
        int i = 0;
        while (i < stringArray.length) {
            String s = stringArray[i];
            if (s != null && s.length() > 0) {
                this._array[this._arrayIndex++] = s;
            }
            ++i;
        }
    }

    public StringBundler append(boolean b) {
        if (b) {
            return this.append(_TRUE);
        }
        return this.append(_FALSE);
    }

    public StringBundler append(char c) {
        return this.append(String.valueOf(c));
    }

    public StringBundler append(char[] chars) {
        if (chars == null) {
            return this.append("null");
        }
        return this.append(new String(chars));
    }

    public StringBundler append(double d) {
        return this.append(Double.toString(d));
    }

    public StringBundler append(float f) {
        return this.append(Float.toString(f));
    }

    public StringBundler append(int i) {
        return this.append(Integer.toString(i));
    }

    public StringBundler append(long l) {
        return this.append(Long.toString(l));
    }

    public StringBundler append(Object obj) {
        return this.append(String.valueOf(obj));
    }

    public StringBundler append(String s) {
        if (s == null) {
            s = "null";
        }
        if (s.length() == 0) {
            return this;
        }
        if (this._arrayIndex >= this._array.length) {
            this.expandCapacity(this._array.length * 2);
        }
        this._array[this._arrayIndex++] = s;
        return this;
    }

    public StringBundler append(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return this;
        }
        if (this._array.length - this._arrayIndex < stringArray.length) {
            this.expandCapacity((this._array.length + stringArray.length) * 2);
        }
        int i = 0;
        while (i < stringArray.length) {
            String s = stringArray[i];
            if (s != null && s.length() > 0) {
                this._array[this._arrayIndex++] = s;
            }
            ++i;
        }
        return this;
    }

    public StringBundler append(StringBundler sb) {
        if (sb == null || sb._arrayIndex == 0) {
            return this;
        }
        if (this._array.length - this._arrayIndex < sb._arrayIndex) {
            this.expandCapacity((this._array.length + sb._arrayIndex) * 2);
        }
        System.arraycopy(sb._array, 0, this._array, this._arrayIndex, sb._arrayIndex);
        this._arrayIndex += sb._arrayIndex;
        return this;
    }

    public int capacity() {
        return this._array.length;
    }

    public int index() {
        return this._arrayIndex;
    }

    public int length() {
        int length = 0;
        int i = 0;
        while (i < this._arrayIndex) {
            length += this._array[i].length();
            ++i;
        }
        return length;
    }

    public void setIndex(int newIndex) {
        if (newIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(newIndex);
        }
        if (newIndex > this._array.length) {
            String[] newArray = new String[newIndex];
            System.arraycopy(this._array, 0, newArray, 0, this._arrayIndex);
            this._array = newArray;
        }
        if (this._arrayIndex < newIndex) {
            int i = this._arrayIndex;
            while (i < newIndex) {
                this._array[i] = "";
                ++i;
            }
        }
        if (this._arrayIndex > newIndex) {
            int i = newIndex;
            while (i < this._arrayIndex) {
                this._array[i] = null;
                ++i;
            }
        }
        this._arrayIndex = newIndex;
    }

    public void setStringAt(String s, int index) {
        if (index < 0 || index >= this._arrayIndex) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        this._array[index] = s;
    }

    public String stringAt(int index) {
        if (index < 0 || index >= this._arrayIndex) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this._array[index];
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean unsafeCreate) {
        if (this._arrayIndex == 0) {
            return "";
        }
        if (this._arrayIndex == 1) {
            return this._array[0];
        }
        if (this._arrayIndex == 2) {
            return this._array[0].concat(this._array[1]);
        }
        if (this._arrayIndex == 3) {
            return this._array[0].concat(this._array[1]).concat(this._array[2]);
        }
        int length = 0;
        int i = 0;
        while (i < this._arrayIndex) {
            length += this._array[i].length();
            ++i;
        }
        StringBuilder sb = null;
        if (length > _unsafeCreateLimit && _stringConstructor != null && CharBufferPool.isEnabled() && unsafeCreate) {
            char[] charBuffer = CharBufferPool.borrow(length);
            int offset = 0;
            int i2 = 0;
            while (i2 < this._arrayIndex) {
                String s = this._array[i2];
                s.getChars(0, s.length(), charBuffer, offset);
                offset += s.length();
                ++i2;
            }
            try {
                return _stringConstructor.newInstance(0, length, charBuffer);
            }
            catch (Exception exception) {
                _stringConstructor = null;
                return this.toString(false);
            }
        }
        if (length > _threadLocalBufferLimit) {
            sb = _stringBuilderThreadLocal.get();
            if (sb == null) {
                sb = new StringBuilder(length);
                _stringBuilderThreadLocal.set(sb);
            } else if (sb.capacity() < length) {
                sb.setLength(length);
            }
            sb.setLength(0);
        } else {
            sb = new StringBuilder(length);
        }
        int i3 = 0;
        while (i3 < this._arrayIndex) {
            sb.append(this._array[i3]);
            ++i3;
        }
        return sb.toString();
    }

    public void writeTo(Writer writer) throws IOException {
        int i = 0;
        while (i < this._arrayIndex) {
            writer.write(this._array[i]);
            ++i;
        }
    }

    protected void expandCapacity(int newCapacity) {
        String[] newArray = new String[newCapacity];
        System.arraycopy(this._array, 0, newArray, 0, this._arrayIndex);
        this._array = newArray;
    }
}

