/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.workflow;

public class WorkflowConstants {
    public static final int ACTION_PUBLISH = 1;
    public static final int ACTION_SAVE_DRAFT = 2;
    public static final String CONTEXT_COMPANY_ID = "companyId";
    public static final String CONTEXT_ENTRY_CLASS_NAME = "entryClassName";
    public static final String CONTEXT_ENTRY_CLASS_PK = "entryClassPK";
    public static final String CONTEXT_ENTRY_TYPE = "entryType";
    public static final String CONTEXT_GROUP_ID = "groupId";
    public static final String CONTEXT_NOTIFICATION_SENDER_ADDRESS = "notificationSenderAddress";
    public static final String CONTEXT_NOTIFICATION_SENDER_NAME = "notificationSenderName";
    public static final String CONTEXT_NOTIFICATION_SUBJECT = "notificationSubject";
    public static final String CONTEXT_SERVICE_CONTEXT = "serviceContext";
    public static final String CONTEXT_TASK_COMMENTS = "taskComments";
    public static final String CONTEXT_TRANSITION_NAME = "transitionName";
    public static final String CONTEXT_USER_ID = "userId";
    public static final long DEFAULT_GROUP_ID = 0L;
    public static final String LABEL_ANY = "any";
    public static final String LABEL_APPROVED = "approved";
    public static final String LABEL_DENIED = "denied";
    public static final String LABEL_DRAFT = "draft";
    public static final String LABEL_DRAFT_FROM_APPROVED = "draft";
    public static final String LABEL_EXPIRED = "expired";
    public static final String LABEL_INACTIVE = "inactive";
    public static final String LABEL_INCOMPLETE = "incomplete";
    public static final String LABEL_PENDING = "pending";
    public static final String LABEL_SCHEDULED = "scheduled";
    public static final int STATUS_ANY = -1;
    public static final int STATUS_APPROVED = 0;
    public static final int STATUS_DENIED = 4;
    public static final int STATUS_DRAFT = 2;
    public static final int STATUS_DRAFT_FROM_APPROVED = 9;
    public static final int STATUS_EXPIRED = 3;
    public static final int STATUS_INACTIVE = 5;
    public static final int STATUS_INCOMPLETE = 6;
    public static final int STATUS_PENDING = 1;
    public static final int STATUS_SCHEDULED = 7;

    public static String toLabel(int status) {
        if (status == -1) {
            return LABEL_ANY;
        }
        if (status == 0) {
            return LABEL_APPROVED;
        }
        if (status == 4) {
            return LABEL_DENIED;
        }
        if (status == 2 || status == 9) {
            return "draft";
        }
        if (status == 3) {
            return LABEL_EXPIRED;
        }
        if (status == 5) {
            return LABEL_INACTIVE;
        }
        if (status == 6) {
            return LABEL_INCOMPLETE;
        }
        if (status == 1) {
            return LABEL_PENDING;
        }
        if (status == 7) {
            return LABEL_SCHEDULED;
        }
        return LABEL_ANY;
    }

    public static int toStatus(String label) {
        if (label.equals(LABEL_ANY)) {
            return -1;
        }
        if (label.equals(LABEL_APPROVED)) {
            return 0;
        }
        if (label.equals(LABEL_DENIED)) {
            return 4;
        }
        if (label.equals("draft") || label.equals("draft")) {
            return 2;
        }
        if (label.equals(LABEL_EXPIRED)) {
            return 3;
        }
        if (label.equals(LABEL_INACTIVE)) {
            return 5;
        }
        if (label.equals(LABEL_INCOMPLETE)) {
            return 6;
        }
        if (label.equals(LABEL_PENDING)) {
            return 1;
        }
        if (label.equals(LABEL_SCHEDULED)) {
            return 7;
        }
        return -1;
    }
}

