/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.permission;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.security.pacl.permission.PortalRuntimePermission;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.permission.UserPermission;

public class UserPermissionUtil {
    private static UserPermission _userPermission;

    public static void check(PermissionChecker permissionChecker, long userId, long organizationId, long locationId, String actionId) throws PrincipalException {
        UserPermissionUtil.check(permissionChecker, userId, new long[]{organizationId, locationId}, actionId);
    }

    public static void check(PermissionChecker permissionChecker, long userId, long[] organizationIds, String actionId) throws PrincipalException {
        UserPermissionUtil.getUserPermission().check(permissionChecker, userId, organizationIds, actionId);
    }

    public static void check(PermissionChecker permissionChecker, long userId, String actionId) throws PrincipalException {
        UserPermissionUtil.getUserPermission().check(permissionChecker, userId, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long userId, long organizationId, long locationId, String actionId) {
        return UserPermissionUtil.contains(permissionChecker, userId, new long[]{organizationId, locationId}, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long userId, long[] organizationIds, String actionId) {
        return UserPermissionUtil.getUserPermission().contains(permissionChecker, userId, organizationIds, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long userId, String actionId) {
        return UserPermissionUtil.getUserPermission().contains(permissionChecker, userId, actionId);
    }

    public static UserPermission getUserPermission() {
        PortalRuntimePermission.checkGetBeanProperty(UserPermissionUtil.class);
        return _userPermission;
    }

    public static boolean hasMembershipProtected(PermissionChecker permissionChecker, Group group, Role role, User user) throws PortalException, SystemException {
        return UserPermissionUtil.getUserPermission().hasMembershipProtected(permissionChecker, group, role, user);
    }

    public static boolean hasMembershipProtected(PermissionChecker permissionChecker, Group group, User user) throws PortalException, SystemException {
        return UserPermissionUtil.getUserPermission().hasMembershipProtected(permissionChecker, group, user);
    }

    public static boolean hasMembershipProtected(PermissionChecker permissionChecker, Organization organization, Role role, User user) throws SystemException {
        return UserPermissionUtil.getUserPermission().hasMembershipProtected(permissionChecker, organization, role, user);
    }

    public static boolean hasMembershipProtected(PermissionChecker permissionChecker, Organization organization, User user) throws PortalException, SystemException {
        return UserPermissionUtil.getUserPermission().hasMembershipProtected(permissionChecker, organization, user);
    }

    public void setUserPermission(UserPermission userPermission) {
        PortalRuntimePermission.checkSetBeanProperty(this.getClass());
        _userPermission = userPermission;
    }
}

