/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.LayoutTypePortlet;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import java.util.Enumeration;
import java.util.Map;
import javax.portlet.MimeResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;

public class PortletURLUtil {
    private static final int _CURRENT_URL_PARAMETER_THRESHOLD = 32768;
    private static final String[] _PORTLET_URL_REFRESH_URL_RESERVED_PARAMETERS = PropsUtil.getArray("portlet.url.refresh.url.reserved.parameters");

    public static PortletURL clone(LiferayPortletURL liferayPortletURL, String lifecycle, MimeResponse mimeResponse) throws PortletException {
        PortletMode portletMode;
        LiferayPortletURL newURLImpl = null;
        if (lifecycle.equals("ACTION_PHASE")) {
            newURLImpl = (LiferayPortletURL)mimeResponse.createActionURL();
        } else if (lifecycle.equals("RENDER_PHASE")) {
            newURLImpl = (LiferayPortletURL)mimeResponse.createRenderURL();
        }
        newURLImpl.setPortletId(liferayPortletURL.getPortletId());
        WindowState windowState = liferayPortletURL.getWindowState();
        if (windowState != null) {
            newURLImpl.setWindowState(windowState);
        }
        if ((portletMode = liferayPortletURL.getPortletMode()) != null) {
            newURLImpl.setPortletMode(portletMode);
        }
        newURLImpl.setParameters(liferayPortletURL.getParameterMap());
        return newURLImpl;
    }

    public static PortletURL clone(PortletURL portletURL, MimeResponse mimeResponse) throws PortletException {
        LiferayPortletURL liferayPortletURL = (LiferayPortletURL)portletURL;
        return PortletURLUtil.clone(liferayPortletURL, liferayPortletURL.getLifecycle(), mimeResponse);
    }

    public static PortletURL clone(PortletURL portletURL, String lifecycle, MimeResponse mimeResponse) throws PortletException {
        LiferayPortletURL liferayPortletURL = (LiferayPortletURL)portletURL;
        return PortletURLUtil.clone(liferayPortletURL, lifecycle, mimeResponse);
    }

    public static PortletURL getCurrent(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) {
        PortletURL portletURL = liferayPortletResponse.createRenderURL();
        Enumeration enu = liferayPortletRequest.getParameterNames();
        while (enu.hasMoreElements()) {
            String param = (String)enu.nextElement();
            String[] values = liferayPortletRequest.getParameterValues(param);
            boolean addParam = true;
            int i = 0;
            while (i < values.length) {
                if (values[i].length() > 32768) {
                    addParam = false;
                    break;
                }
                ++i;
            }
            if (!addParam) continue;
            portletURL.setParameter(param, values);
        }
        return portletURL;
    }

    public static PortletURL getCurrent(PortletRequest portletRequest, MimeResponse mimeResponse) {
        return PortletURLUtil.getCurrent((LiferayPortletRequest)portletRequest, (LiferayPortletResponse)mimeResponse);
    }

    public static String getRefreshURL(HttpServletRequest request, ThemeDisplay themeDisplay) {
        String doAsUserId;
        StringBundler sb = new StringBundler(32);
        sb.append(themeDisplay.getPathMain());
        sb.append("/portal/render_portlet?p_l_id=");
        long plid = themeDisplay.getPlid();
        sb.append(plid);
        Portlet portlet = (Portlet)request.getAttribute("RENDER_PORTLET");
        String portletId = portlet.getPortletId();
        sb.append("&p_p_id=");
        sb.append(portletId);
        sb.append("&p_p_lifecycle=0&p_t_lifecycle=");
        sb.append(themeDisplay.getLifecycle());
        WindowState windowState = WindowState.NORMAL;
        if (themeDisplay.isStatePopUp()) {
            windowState = LiferayWindowState.POP_UP;
        } else {
            LayoutTypePortlet layoutTypePortlet = themeDisplay.getLayoutTypePortlet();
            if (layoutTypePortlet.hasStateMaxPortletId(portletId)) {
                windowState = WindowState.MAXIMIZED;
            } else if (layoutTypePortlet.hasStateMinPortletId(portletId)) {
                windowState = WindowState.MINIMIZED;
            }
        }
        sb.append("&p_p_state=");
        sb.append(windowState);
        sb.append("&p_p_mode=view&p_p_col_id=");
        String columnId = (String)request.getAttribute("RENDER_PORTLET_COLUMN_ID");
        sb.append(columnId);
        Integer columnPos = (Integer)request.getAttribute("RENDER_PORTLET_COLUMN_POS");
        sb.append("&p_p_col_pos=");
        sb.append(columnPos);
        Integer columnCount = (Integer)request.getAttribute("RENDER_PORTLET_COLUMN_COUNT");
        sb.append("&p_p_col_count=");
        sb.append(columnCount);
        if (portlet.isStatic()) {
            sb.append("&p_p_static=1");
            if (portlet.isStaticStart()) {
                sb.append("&p_p_static_start=1");
            }
        }
        sb.append("&p_p_isolated=1");
        long sourceGroupId = ParamUtil.getLong(request, "p_v_l_s_g_id");
        if (sourceGroupId > 0L) {
            sb.append("&p_v_l_s_g_id=");
            sb.append(sourceGroupId);
        }
        if (Validator.isNotNull(doAsUserId = themeDisplay.getDoAsUserId())) {
            sb.append("&doAsUserId=");
            sb.append(HttpUtil.encodeURL(doAsUserId));
        }
        String currentURL = PortalUtil.getCurrentURL(request);
        sb.append("&currentURL=");
        sb.append(HttpUtil.encodeURL(currentURL));
        String ppid = ParamUtil.getString(request, "p_p_id");
        if (!ppid.equals(portletId)) {
            return sb.toString();
        }
        String namespace = PortalUtil.getPortletNamespace(portletId);
        Map parameters = request.getParameterMap();
        for (Map.Entry entry : parameters.entrySet()) {
            String name = (String)entry.getKey();
            if (PortalUtil.isReservedParameter(name) || name.equals("currentURL") || PortletURLUtil.isRefreshURLReservedParameter(name, namespace)) continue;
            String[] values = (String[])entry.getValue();
            int i = 0;
            while (i < values.length) {
                sb.append("&");
                sb.append(name);
                sb.append("=");
                sb.append(HttpUtil.encodeURL(values[i]));
                ++i;
            }
        }
        return sb.toString();
    }

    protected static boolean isRefreshURLReservedParameter(String parameter, String namespace) {
        if (_PORTLET_URL_REFRESH_URL_RESERVED_PARAMETERS == null || _PORTLET_URL_REFRESH_URL_RESERVED_PARAMETERS.length == 0) {
            return false;
        }
        int i = 0;
        while (i < _PORTLET_URL_REFRESH_URL_RESERVED_PARAMETERS.length) {
            String reservedParameter = namespace.concat(_PORTLET_URL_REFRESH_URL_RESERVED_PARAMETERS[i]);
            if (parameter.equals(reservedParameter)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

