/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.util;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.image.ImageBag;
import com.liferay.portal.kernel.image.ImageToolUtil;
import com.liferay.portal.kernel.io.FileFilter;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.documentlibrary.DuplicateDirectoryException;
import com.liferay.portlet.documentlibrary.store.DLStoreUtil;
import com.liferay.portlet.documentlibrary.util.DLProcessor;
import com.liferay.portlet.documentlibrary.util.DLUtil;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.InputStream;

public abstract class DLPreviewableProcessor
implements DLProcessor {
    public static final String PREVIEW_PATH = "document_preview/";
    public static final String PREVIEW_TMP_PATH = String.valueOf(SystemProperties.get("java.io.tmpdir")) + "/liferay/" + "document_preview/";
    public static final long REPOSITORY_ID = 0L;
    public static final int THUMBNAIL_INDEX_CUSTOM_1 = 1;
    public static final int THUMBNAIL_INDEX_CUSTOM_2 = 2;
    public static final int THUMBNAIL_INDEX_DEFAULT = 0;
    public static final String THUMBNAIL_PATH = "document_thumbnail/";
    public static final String THUMBNAIL_TMP_PATH = String.valueOf(SystemProperties.get("java.io.tmpdir")) + "/liferay/" + "document_thumbnail/";
    private static Log _log = LogFactoryUtil.getLog(DLPreviewableProcessor.class);

    public static void deleteFiles() {
        long[] companyIds;
        long[] lArray = companyIds = PortalUtil.getCompanyIds();
        int n = companyIds.length;
        int n2 = 0;
        while (n2 < n) {
            long companyId = lArray[n2];
            try {
                DLStoreUtil.deleteDirectory(companyId, 0L, PREVIEW_PATH);
            }
            catch (Exception exception) {}
            try {
                DLStoreUtil.deleteDirectory(companyId, 0L, THUMBNAIL_PATH);
            }
            catch (Exception exception) {}
            ++n2;
        }
    }

    public static void deleteFiles(FileEntry fileEntry, String thumbnailType) {
        DLPreviewableProcessor.deleteFiles(fileEntry.getCompanyId(), fileEntry.getGroupId(), fileEntry.getFileEntryId(), -1L, thumbnailType);
    }

    public static void deleteFiles(FileVersion fileVersion, String thumbnailType) {
        DLPreviewableProcessor.deleteFiles(fileVersion.getCompanyId(), fileVersion.getGroupId(), fileVersion.getFileEntryId(), fileVersion.getFileVersionId(), thumbnailType);
    }

    @Override
    public void cleanUp(FileEntry fileEntry) {
        DLPreviewableProcessor.deleteFiles(fileEntry, this.getThumbnailType());
    }

    @Override
    public void cleanUp(FileVersion fileVersion) {
        DLPreviewableProcessor.deleteFiles(fileVersion, this.getThumbnailType());
    }

    @Override
    public void exportGeneratedFiles(PortletDataContext portletDataContext, FileEntry fileEntry, Element fileEntryElement) throws Exception {
        this.doExportGeneratedFiles(portletDataContext, fileEntry, fileEntryElement);
    }

    @Override
    public void importGeneratedFiles(PortletDataContext portletDataContext, FileEntry fileEntry, FileEntry importedFileEntry, Element fileEntryElement) throws Exception {
        this.cleanUp(importedFileEntry.getFileVersion());
        this.doImportGeneratedFiles(portletDataContext, fileEntry, importedFileEntry, fileEntryElement);
    }

    @Override
    public boolean isSupported(FileVersion fileVersion) {
        if (fileVersion == null) {
            return false;
        }
        return this.isSupported(fileVersion.getMimeType());
    }

    protected static void deleteFiles(long companyId, long groupId, long fileEntryId, long fileVersionId, String thumbnailType) {
        try {
            DLStoreUtil.deleteDirectory(companyId, 0L, DLPreviewableProcessor.getPathSegment(groupId, fileEntryId, fileVersionId, true));
        }
        catch (Exception exception) {}
        try {
            String dirName = DLPreviewableProcessor.getPathSegment(groupId, fileEntryId, fileVersionId, false);
            if (fileVersionId > 0L) {
                dirName = dirName.concat(".");
                dirName = dirName.concat(thumbnailType);
            }
            DLStoreUtil.deleteDirectory(companyId, 0L, dirName);
        }
        catch (Exception exception) {}
    }

    protected static String getPathSegment(FileVersion fileVersion, boolean preview) {
        return DLPreviewableProcessor.getPathSegment(fileVersion.getGroupId(), fileVersion.getFileEntryId(), fileVersion.getFileVersionId(), preview);
    }

    protected static String getPathSegment(long groupId, long fileEntryId, long fileVersionId, boolean preview) {
        StringBundler sb = null;
        sb = fileVersionId > 0L ? new StringBundler(5) : new StringBundler(3);
        if (preview) {
            sb.append(PREVIEW_PATH);
        } else {
            sb.append(THUMBNAIL_PATH);
        }
        sb.append(groupId);
        sb.append(DLUtil.getDividedPath(fileEntryId));
        if (fileVersionId > 0L) {
            sb.append("/");
            sb.append(fileVersionId);
        }
        return sb.toString();
    }

    protected void addFileToStore(long companyId, String dirName, String filePath, File srcFile) throws PortalException, SystemException {
        try {
            DLStoreUtil.addDirectory(companyId, 0L, dirName);
        }
        catch (DuplicateDirectoryException duplicateDirectoryException) {}
        DLStoreUtil.addFile(companyId, 0L, filePath, false, srcFile);
    }

    protected void addFileToStore(long companyId, String dirName, String filePath, InputStream is) throws PortalException, SystemException {
        try {
            DLStoreUtil.addDirectory(companyId, 0L, dirName);
        }
        catch (DuplicateDirectoryException duplicateDirectoryException) {}
        DLStoreUtil.addFile(companyId, 0L, filePath, false, is);
    }

    protected abstract void doExportGeneratedFiles(PortletDataContext var1, FileEntry var2, Element var3) throws Exception;

    protected InputStream doGetPreviewAsStream(FileVersion fileVersion, int index, String type) throws PortalException, SystemException {
        return DLStoreUtil.getFileAsStream(fileVersion.getCompanyId(), 0L, this.getPreviewFilePath(fileVersion, index, type));
    }

    protected InputStream doGetPreviewAsStream(FileVersion fileVersion, String type) throws PortalException, SystemException {
        return this.doGetPreviewAsStream(fileVersion, 0, type);
    }

    protected int doGetPreviewFileCount(FileVersion fileVersion) throws Exception {
        try {
            String[] fileNames = DLStoreUtil.getFileNames(fileVersion.getCompanyId(), 0L, DLPreviewableProcessor.getPathSegment(fileVersion, true));
            return fileNames.length;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    protected long doGetPreviewFileSize(FileVersion fileVersion, int index) throws PortalException, SystemException {
        return this.doGetPreviewFileSize(fileVersion, index, this.getPreviewType());
    }

    protected long doGetPreviewFileSize(FileVersion fileVersion, int index, String type) throws PortalException, SystemException {
        return DLStoreUtil.getFileSize(fileVersion.getCompanyId(), 0L, this.getPreviewFilePath(fileVersion, index, type));
    }

    protected long doGetPreviewFileSize(FileVersion fileVersion, String type) throws PortalException, SystemException {
        return this.doGetPreviewFileSize(fileVersion, 0, type);
    }

    protected InputStream doGetThumbnailAsStream(FileVersion fileVersion, int index) throws PortalException, SystemException {
        String type = this.getThumbnailType(fileVersion);
        return DLStoreUtil.getFileAsStream(fileVersion.getCompanyId(), 0L, this.getThumbnailFilePath(fileVersion, type, index));
    }

    protected long doGetThumbnailFileSize(FileVersion fileVersion, int index) throws PortalException, SystemException {
        String type = this.getThumbnailType(fileVersion);
        return DLStoreUtil.getFileSize(fileVersion.getCompanyId(), 0L, this.getThumbnailFilePath(fileVersion, type, index));
    }

    protected abstract void doImportGeneratedFiles(PortletDataContext var1, FileEntry var2, FileEntry var3, Element var4) throws Exception;

    protected void exportBinary(PortletDataContext portletDataContext, Element fileEntryElement, FileVersion fileVersion, InputStream is, String binPath, String binPathName) throws SystemException {
        fileEntryElement.addAttribute(binPathName, binPath);
        if (is == null) {
            if (_log.isWarnEnabled()) {
                _log.warn("No input stream found for file entry " + fileVersion.getFileEntryId());
            }
            fileEntryElement.detach();
            return;
        }
        portletDataContext.addZipEntry(binPath, is);
    }

    protected void exportPreview(PortletDataContext portletDataContext, FileEntry fileEntry, Element fileEntryElement, String binPathSuffix, String previewType) throws Exception {
        this.exportPreview(portletDataContext, fileEntry, fileEntryElement, binPathSuffix, previewType, -1);
    }

    protected void exportPreview(PortletDataContext portletDataContext, FileEntry fileEntry, Element fileEntryElement, String binPathSuffix, String previewType, int fileIndex) throws Exception {
        if (portletDataContext.isPerformDirectBinaryImport()) {
            return;
        }
        String binPathSegment = null;
        binPathSegment = fileIndex < 0 ? previewType : Integer.toString(fileIndex + 1);
        String binPath = this.getBinPath(portletDataContext, fileEntry, binPathSegment);
        StringBundler sb = new StringBundler(4);
        sb.append("bin-path-preview-");
        sb.append(binPathSegment);
        sb.append("-");
        sb.append(binPathSuffix);
        String binPathName = sb.toString();
        fileEntryElement.addAttribute(binPathName, binPath);
        FileVersion fileVersion = fileEntry.getFileVersion();
        InputStream is = null;
        try {
            is = fileIndex < 0 ? this.doGetPreviewAsStream(fileVersion, previewType) : this.doGetPreviewAsStream(fileVersion, fileIndex + 1, previewType);
            this.exportBinary(portletDataContext, fileEntryElement, fileVersion, is, binPath, binPathName);
        }
        catch (Throwable throwable) {
            StreamUtil.cleanUp(is);
            throw throwable;
        }
        StreamUtil.cleanUp(is);
    }

    protected void exportThumbnail(PortletDataContext portletDataContext, FileEntry fileEntry, Element fileEntryElement, String binPathName, int index) throws PortalException, SystemException {
        FileVersion fileVersion = fileEntry.getFileVersion();
        if (!this.hasThumbnail(fileVersion, index)) {
            return;
        }
        InputStream is = null;
        try {
            is = this.doGetThumbnailAsStream(fileVersion, index);
            String binPath = this.getBinPath(portletDataContext, fileEntry, index);
            fileEntryElement.addAttribute(binPathName, binPath);
            this.exportBinary(portletDataContext, fileEntryElement, fileVersion, is, binPath, binPathName);
        }
        catch (Throwable throwable) {
            StreamUtil.cleanUp(is);
            throw throwable;
        }
        StreamUtil.cleanUp(is);
    }

    protected void exportThumbnails(PortletDataContext portletDataContext, FileEntry fileEntry, Element fileEntryElement, String binPathSuffix) throws PortalException, SystemException {
        FileVersion fileVersion = fileEntry.getFileVersion();
        if (!this.isSupported(fileVersion) || !this.hasThumbnails(fileVersion)) {
            return;
        }
        if (!portletDataContext.isPerformDirectBinaryImport()) {
            this.exportThumbnail(portletDataContext, fileEntry, fileEntryElement, "bin-path-thumbnail-default-" + binPathSuffix, 0);
            this.exportThumbnail(portletDataContext, fileEntry, fileEntryElement, "bin-path-thumbnail-custom-1-" + binPathSuffix, 1);
            this.exportThumbnail(portletDataContext, fileEntry, fileEntryElement, "bin-path-thumbnail-custom-2-" + binPathSuffix, 2);
        }
    }

    protected String getBinPath(PortletDataContext portletDataContext, FileEntry fileEntry, int index) {
        StringBundler sb = new StringBundler(8);
        sb.append(portletDataContext.getPortletPath("20"));
        sb.append("/bin/");
        sb.append(fileEntry.getFileEntryId());
        sb.append("/");
        sb.append(THUMBNAIL_PATH);
        sb.append(fileEntry.getVersion());
        sb.append("/");
        sb.append(index);
        return sb.toString();
    }

    protected String getBinPath(PortletDataContext portletDataContext, FileEntry fileEntry, String type) {
        StringBundler sb = new StringBundler(8);
        sb.append(portletDataContext.getPortletPath("20"));
        sb.append("/bin/");
        sb.append(fileEntry.getFileEntryId());
        sb.append("/");
        sb.append(PREVIEW_PATH);
        sb.append(fileEntry.getVersion());
        sb.append("/");
        sb.append(type);
        return sb.toString();
    }

    protected String getPreviewFilePath(FileVersion fileVersion) {
        return this.getPreviewFilePath(fileVersion, 0);
    }

    protected String getPreviewFilePath(FileVersion fileVersion, int index) {
        return this.getPreviewFilePath(fileVersion, index, this.getPreviewType());
    }

    protected String getPreviewFilePath(FileVersion fileVersion, int index, String type) {
        StringBundler sb = null;
        sb = index > 0 ? new StringBundler(5) : new StringBundler(3);
        sb.append(DLPreviewableProcessor.getPathSegment(fileVersion, true));
        if (index > 0) {
            sb.append("/");
            sb.append(index - 1);
        }
        sb.append(".");
        sb.append(type);
        return sb.toString();
    }

    protected String getPreviewFilePath(FileVersion fileVersion, String type) {
        return this.getPreviewFilePath(fileVersion, 0, type);
    }

    protected File getPreviewTempFile(String id) {
        return this.getPreviewTempFile(id, 0);
    }

    protected File getPreviewTempFile(String id, int index) {
        return this.getPreviewTempFile(id, index, this.getPreviewType());
    }

    protected File getPreviewTempFile(String id, int index, String type) {
        String previewTempFilePath = this.getPreviewTempFilePath(id, index, type);
        return new File(previewTempFilePath);
    }

    protected File getPreviewTempFile(String id, String type) {
        return this.getPreviewTempFile(id, 0, type);
    }

    protected int getPreviewTempFileCount(FileVersion fileVersion) {
        return this.getPreviewTempFileCount(fileVersion, this.getPreviewType());
    }

    protected int getPreviewTempFileCount(FileVersion fileVersion, String type) {
        String tempFileId = DLUtil.getTempFileId(fileVersion.getFileEntryId(), fileVersion.getVersion());
        StringBundler sb = new StringBundler(5);
        sb.append(tempFileId);
        sb.append("-");
        sb.append("(.*)");
        sb.append(".");
        sb.append(type);
        File dir = new File(PREVIEW_TMP_PATH);
        File[] files = dir.listFiles(new FileFilter(sb.toString()));
        if (_log.isDebugEnabled()) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                _log.debug("Preview page for " + tempFileId + " " + file);
                ++n2;
            }
        }
        return files.length;
    }

    protected String getPreviewTempFilePath(String id) {
        return this.getPreviewTempFilePath(id, 0);
    }

    protected String getPreviewTempFilePath(String id, int index) {
        return this.getPreviewTempFilePath(id, index, this.getPreviewType());
    }

    protected String getPreviewTempFilePath(String id, int index, String type) {
        StringBundler sb = null;
        sb = index > 0 ? new StringBundler(6) : new StringBundler(4);
        sb.append(PREVIEW_TMP_PATH);
        sb.append(id);
        if (index > 0) {
            sb.append("-");
            sb.append(index - 1);
        }
        sb.append(".");
        sb.append(type);
        return sb.toString();
    }

    protected String getPreviewTempFilePath(String id, String type) {
        return this.getPreviewTempFilePath(id, 0, type);
    }

    protected String getPreviewType() {
        return this.getPreviewType(null);
    }

    protected abstract String getPreviewType(FileVersion var1);

    protected String getPreviewType(int index) {
        String[] previewTypes = this.getPreviewTypes();
        if (previewTypes != null && previewTypes.length > index) {
            return previewTypes[index];
        }
        return this.getPreviewType();
    }

    protected String[] getPreviewTypes() {
        return new String[]{this.getPreviewType()};
    }

    protected String getThumbnailFilePath(FileVersion fileVersion, int index) {
        return this.getThumbnailFilePath(fileVersion, this.getThumbnailType(), index);
    }

    protected String getThumbnailFilePath(FileVersion fileVersion, String type, int index) {
        StringBundler sb = new StringBundler(5);
        sb.append(DLPreviewableProcessor.getPathSegment(fileVersion, false));
        if (index != 0) {
            sb.append("-");
            sb.append(index);
        }
        sb.append(".");
        sb.append(type);
        return sb.toString();
    }

    protected File getThumbnailTempFile(String id) {
        return this.getThumbnailTempFile(id, this.getThumbnailType());
    }

    protected File getThumbnailTempFile(String id, String type) {
        String thumbnailTempFilePath = this.getThumbnailTempFilePath(id, type);
        return new File(thumbnailTempFilePath);
    }

    protected String getThumbnailTempFilePath(String id) {
        return this.getThumbnailTempFilePath(id, this.getThumbnailType());
    }

    protected String getThumbnailTempFilePath(String id, String type) {
        StringBundler sb = new StringBundler(4);
        sb.append(THUMBNAIL_TMP_PATH);
        sb.append(id);
        sb.append(".");
        sb.append(type);
        return sb.toString();
    }

    protected String getThumbnailType() {
        return this.getThumbnailType(null);
    }

    protected abstract String getThumbnailType(FileVersion var1);

    protected boolean hasPreview(FileVersion fileVersion, String type) throws Exception {
        String previewFilePath = this.getPreviewFilePath(fileVersion, type);
        return DLStoreUtil.hasFile(fileVersion.getCompanyId(), 0L, previewFilePath);
    }

    protected boolean hasPreviews(FileVersion fileVersion) throws Exception {
        String[] previewTypes;
        int count = 0;
        String[] stringArray = previewTypes = this.getPreviewTypes();
        int n = previewTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String previewType = stringArray[n2];
            if (this.hasPreview(fileVersion, previewType)) {
                ++count;
            }
            ++n2;
        }
        return count == previewTypes.length;
    }

    protected boolean hasThumbnail(FileVersion fileVersion, int index) {
        try {
            String imageType = this.getThumbnailType(fileVersion);
            return DLStoreUtil.hasFile(fileVersion.getCompanyId(), 0L, this.getThumbnailFilePath(fileVersion, imageType, index));
        }
        catch (Exception e) {
            _log.error(e, e);
            return false;
        }
    }

    protected boolean hasThumbnails(FileVersion fileVersion) {
        block6: {
            block5: {
                if (!this.isThumbnailEnabled(0) || this.hasThumbnail(fileVersion, 0)) break block5;
                return false;
            }
            if (!this.isThumbnailEnabled(1) || this.hasThumbnail(fileVersion, 1)) break block6;
            return false;
        }
        try {
            if (this.isThumbnailEnabled(2) && !this.hasThumbnail(fileVersion, 2)) {
                return false;
            }
        }
        catch (Exception e) {
            _log.error(e, e);
        }
        return true;
    }

    protected void importPreview(PortletDataContext portletDataContext, FileEntry fileEntry, FileEntry importedFileEntry, Element fileEntryElement, String binPathSuffix, String previewType) throws Exception {
        this.importPreview(portletDataContext, fileEntry, importedFileEntry, fileEntryElement, binPathSuffix, previewType, -1);
    }

    protected void importPreview(PortletDataContext portletDataContext, FileEntry fileEntry, FileEntry importedFileEntry, Element fileEntryElement, String binPathSuffix, String previewType, int fileIndex) throws Exception {
        if (!portletDataContext.isPerformDirectBinaryImport()) {
            this.importPreviewFromLAR(portletDataContext, importedFileEntry, fileEntryElement, binPathSuffix, previewType, fileIndex);
        } else {
            FileVersion importedFileVersion = importedFileEntry.getFileVersion();
            String previewFilePath = this.getPreviewFilePath(importedFileVersion, previewType);
            FileVersion fileVersion = fileEntry.getFileVersion();
            InputStream is = null;
            try {
                is = fileIndex < 0 ? this.doGetPreviewAsStream(fileVersion, previewType) : this.doGetPreviewAsStream(fileVersion, fileIndex, previewType);
                this.addFileToStore(portletDataContext.getCompanyId(), PREVIEW_PATH, previewFilePath, is);
            }
            catch (Throwable throwable) {
                StreamUtil.cleanUp(is);
                throw throwable;
            }
            StreamUtil.cleanUp(is);
        }
    }

    protected void importPreviewFromLAR(PortletDataContext portletDataContext, FileEntry fileEntry, Element fileEntryElement, String binPathSuffix, String previewType, int fileIndex) throws Exception {
        FileVersion fileVersion = fileEntry.getFileVersion();
        String binPathSegment = null;
        binPathSegment = fileIndex < 0 ? previewType : Integer.toString(fileIndex + 1);
        StringBundler sb = new StringBundler(4);
        sb.append("bin-path-preview-");
        sb.append(binPathSegment);
        sb.append("-");
        sb.append(binPathSuffix);
        String binPathName = sb.toString();
        String binPath = fileEntryElement.attributeValue(binPathName);
        InputStream is = null;
        try {
            is = portletDataContext.getZipEntryAsInputStream(binPath);
            if (is == null) {
                return;
            }
            String previewFilePath = null;
            previewFilePath = fileIndex < 0 ? this.getPreviewFilePath(fileVersion, previewType) : this.getPreviewFilePath(fileVersion, fileIndex + 1);
            this.addFileToStore(portletDataContext.getCompanyId(), PREVIEW_PATH, previewFilePath, is);
        }
        finally {
            StreamUtil.cleanUp(is);
        }
    }

    protected void importThumbnail(PortletDataContext portletDataContext, FileEntry fileEntry, FileEntry importedFileEntry, Element fileEntryElement, String binPathName, int index) throws Exception {
        if (!portletDataContext.isPerformDirectBinaryImport()) {
            this.importThumbnailFromLAR(portletDataContext, importedFileEntry, fileEntryElement, binPathName, index);
        } else {
            FileVersion fileVersion = fileEntry.getFileVersion();
            if (!this.hasThumbnail(fileVersion, index)) {
                return;
            }
            InputStream is = null;
            try {
                is = this.doGetThumbnailAsStream(fileVersion, index);
                FileVersion importedFileVersion = importedFileEntry.getFileVersion();
                String thumbnailFilePath = this.getThumbnailFilePath(importedFileVersion, this.getThumbnailType(importedFileVersion), index);
                this.addFileToStore(portletDataContext.getCompanyId(), THUMBNAIL_PATH, thumbnailFilePath, is);
            }
            catch (Throwable throwable) {
                StreamUtil.cleanUp(is);
                throw throwable;
            }
            StreamUtil.cleanUp(is);
        }
    }

    protected void importThumbnailFromLAR(PortletDataContext portletDataContext, FileEntry fileEntry, Element fileEntryElement, String binPathName, int index) throws Exception {
        FileVersion fileVersion = fileEntry.getFileVersion();
        String binPath = fileEntryElement.attributeValue(binPathName);
        InputStream is = null;
        try {
            is = portletDataContext.getZipEntryAsInputStream(binPath);
            if (is == null) {
                return;
            }
            String thumbnailFilePath = this.getThumbnailFilePath(fileVersion, this.getThumbnailType(fileVersion), index);
            this.addFileToStore(portletDataContext.getCompanyId(), THUMBNAIL_PATH, thumbnailFilePath, is);
        }
        finally {
            StreamUtil.cleanUp(is);
        }
    }

    protected void importThumbnails(PortletDataContext portletDataContext, FileEntry fileEntry, FileEntry importedFileEntry, Element fileEntryElement, String binPathSuffix) throws Exception {
        this.importThumbnail(portletDataContext, fileEntry, importedFileEntry, fileEntryElement, "bin-path-thumbnail-default-" + binPathSuffix, 0);
        this.importThumbnail(portletDataContext, fileEntry, importedFileEntry, fileEntryElement, "bin-path-thumbnail-custom-1-" + binPathSuffix, 1);
        this.importThumbnail(portletDataContext, fileEntry, importedFileEntry, fileEntryElement, "bin-path-thumbnail-custom-2-" + binPathSuffix, 2);
    }

    protected boolean isThumbnailEnabled(int index) throws Exception {
        return index == 0 ? GetterUtil.getBoolean(PropsUtil.get("dl.file.entry.thumbnail.enabled")) : (index == 1 ? PrefsPropsUtil.getInteger("dl.file.entry.thumbnail.custom1.max.height") > 0 || PrefsPropsUtil.getInteger("dl.file.entry.thumbnail.custom1.max.width") > 0 : index == 2 && (PrefsPropsUtil.getInteger("dl.file.entry.thumbnail.custom2.max.height") > 0 || PrefsPropsUtil.getInteger("dl.file.entry.thumbnail.custom2.max.width") > 0));
    }

    protected void storeThumbnailImages(FileVersion fileVersion, File file) throws Exception {
        ImageBag imageBag = ImageToolUtil.read(file);
        RenderedImage renderedImage = imageBag.getRenderedImage();
        this.storeThumbnailImages(fileVersion, renderedImage);
    }

    protected void storeThumbnailImages(FileVersion fileVersion, RenderedImage renderedImage) throws Exception {
        this.storeThumbnailmage(fileVersion, renderedImage, 0);
        this.storeThumbnailmage(fileVersion, renderedImage, 1);
        this.storeThumbnailmage(fileVersion, renderedImage, 2);
    }

    protected void storeThumbnailmage(FileVersion fileVersion, RenderedImage renderedImage, int index) throws Exception {
        if (!this.isThumbnailEnabled(index) || this.hasThumbnail(fileVersion, index)) {
            return;
        }
        String type = this.getThumbnailType(fileVersion);
        String maxHeightPropsKey = "dl.file.entry.thumbnail.max.height";
        String maxWidthPropsKey = "dl.file.entry.thumbnail.max.width";
        if (index == 1) {
            maxHeightPropsKey = "dl.file.entry.thumbnail.custom1.max.height";
            maxWidthPropsKey = "dl.file.entry.thumbnail.custom1.max.width";
        } else if (index == 2) {
            maxHeightPropsKey = "dl.file.entry.thumbnail.custom2.max.height";
            maxWidthPropsKey = "dl.file.entry.thumbnail.custom2.max.width";
        }
        RenderedImage thumbnailRenderedImage = ImageToolUtil.scale(renderedImage, PrefsPropsUtil.getInteger(maxHeightPropsKey), PrefsPropsUtil.getInteger(maxWidthPropsKey));
        byte[] bytes = ImageToolUtil.getBytes(thumbnailRenderedImage, type);
        File file = null;
        try {
            file = FileUtil.createTempFile(bytes);
            this.addFileToStore(fileVersion.getCompanyId(), THUMBNAIL_PATH, this.getThumbnailFilePath(fileVersion, type, index), file);
        }
        finally {
            FileUtil.delete(file);
        }
    }
}

