/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.util;

import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PrefsParamUtil;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Group;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.WorkflowDefinitionLinkLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portlet.documentlibrary.model.DLFileEntryType;
import com.liferay.portlet.documentlibrary.model.DLFileShortcut;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.model.DLFolderConstants;
import com.liferay.portlet.documentlibrary.service.DLAppLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFolderLocalServiceUtil;
import com.liferay.portlet.documentlibrary.util.ImageProcessorUtil;
import com.liferay.portlet.documentlibrary.util.PDFProcessorUtil;
import com.liferay.portlet.documentlibrary.util.VideoProcessorUtil;
import com.liferay.portlet.documentlibrary.util.comparator.RepositoryModelCreateDateComparator;
import com.liferay.portlet.documentlibrary.util.comparator.RepositoryModelModifiedDateComparator;
import com.liferay.portlet.documentlibrary.util.comparator.RepositoryModelNameComparator;
import com.liferay.portlet.documentlibrary.util.comparator.RepositoryModelReadCountComparator;
import com.liferay.portlet.documentlibrary.util.comparator.RepositoryModelSizeComparator;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;

public class DLUtil {
    public static final String OFFICE_EXTENSION = "officeExtension";
    public static final String OFFICE_EXTENSION_PATH = "/officeExtension";
    private static final String _DEFAULT_FILE_ICON = "page";
    private static final String _DEFAULT_GENERIC_NAME = "default";
    private static final long _DIVISOR = 256L;
    private static final boolean _WEBDAV_SERVLET_HTTPS_REQUIRED = GetterUtil.getBoolean(PropsUtil.get("webdav.servlet.https.required"));
    private static Log _log = LogFactoryUtil.getLog(DLUtil.class);
    private static DLUtil _instance = new DLUtil();
    private Set<String> _allMediaGalleryMimeTypes = new TreeSet<String>();
    private String _allMediaGalleryMimeTypesString;
    private Set<String> _fileIcons = new HashSet<String>();
    private Map<String, String> _genericNames = new HashMap<String, String>();

    public static void addPortletBreadcrumbEntries(DLFileShortcut dlFileShortcut, HttpServletRequest request, RenderResponse renderResponse) throws Exception {
        Folder folder = dlFileShortcut.getFolder();
        if (folder.getFolderId() != 0L) {
            DLUtil.addPortletBreadcrumbEntries(folder, request, renderResponse);
        }
        PortletURL portletURL = renderResponse.createRenderURL();
        portletURL.setParameter("struts_action", "/document_library/view_file_entry");
        portletURL.setParameter("fileEntryId", String.valueOf(dlFileShortcut.getToFileEntryId()));
        PortalUtil.addPortletBreadcrumbEntry(request, dlFileShortcut.getToTitle(), portletURL.toString());
    }

    public static void addPortletBreadcrumbEntries(FileEntry fileEntry, HttpServletRequest request, RenderResponse renderResponse) throws Exception {
        Folder folder = fileEntry.getFolder();
        if (folder.getFolderId() != 0L) {
            DLUtil.addPortletBreadcrumbEntries(folder, request, renderResponse);
        }
        PortletURL portletURL = renderResponse.createRenderURL();
        portletURL.setParameter("struts_action", "/document_library/view_file_entry");
        portletURL.setParameter("fileEntryId", String.valueOf(fileEntry.getFileEntryId()));
        PortalUtil.addPortletBreadcrumbEntry(request, fileEntry.getTitle(), portletURL.toString());
    }

    public static void addPortletBreadcrumbEntries(Folder folder, HttpServletRequest request, LiferayPortletResponse liferayPortletResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("THEME_DISPLAY");
        PortletURL portletURL = liferayPortletResponse.createRenderURL();
        portletURL.setParameter("struts_action", "/document_library/view");
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("direction-right", Boolean.TRUE.toString());
        data.put("folder-id", DLUtil._getDefaultFolderId(request));
        PortalUtil.addPortletBreadcrumbEntry(request, themeDisplay.translate("home"), portletURL.toString(), data);
        DLUtil.addPortletBreadcrumbEntries(folder, request, portletURL);
    }

    public static void addPortletBreadcrumbEntries(Folder folder, HttpServletRequest request, PortletURL portletURL) throws Exception {
        HashMap<String, Object> data;
        long defaultFolderId = DLUtil._getDefaultFolderId(request);
        List<Object> ancestorFolders = Collections.emptyList();
        if (folder != null && folder.getFolderId() != defaultFolderId) {
            int n;
            ancestorFolders = folder.getAncestors();
            int n2 = -1;
            int i = 0;
            while (i < ancestorFolders.size()) {
                Folder ancestorFolder = (Folder)ancestorFolders.get(i);
                if (defaultFolderId == ancestorFolder.getFolderId()) {
                    n = i;
                }
                ++i;
            }
            if (n > -1) {
                ancestorFolders = ancestorFolders.subList(0, n);
            }
        }
        Collections.reverse(ancestorFolders);
        for (Folder folder2 : ancestorFolders) {
            portletURL.setParameter("folderId", String.valueOf(folder2.getFolderId()));
            data = new HashMap<String, Object>();
            data.put("direction-right", Boolean.TRUE.toString());
            data.put("folder-id", folder2.getFolderId());
            PortalUtil.addPortletBreadcrumbEntry(request, folder2.getName(), portletURL.toString(), data);
        }
        long l = 0L;
        if (folder != null) {
            l = folder.getFolderId();
        }
        portletURL.setParameter("folderId", String.valueOf(l));
        if (l != 0L && l != defaultFolderId) {
            data = new HashMap();
            data.put("direction-right", Boolean.TRUE.toString());
            data.put("folder-id", l);
            PortalUtil.addPortletBreadcrumbEntry(request, folder.getName(), portletURL.toString(), data);
        }
    }

    public static void addPortletBreadcrumbEntries(Folder folder, HttpServletRequest request, RenderResponse renderResponse) throws Exception {
        String strutsAction = ParamUtil.getString(request, "struts_action");
        long groupId = ParamUtil.getLong(request, "groupId");
        PortletURL portletURL = renderResponse.createRenderURL();
        if (strutsAction.equals("/journal/select_document_library") || strutsAction.equals("/document_library/select_file_entry") || strutsAction.equals("/document_library/select_folder") || strutsAction.equals("/document_library_display/select_folder") || strutsAction.equals("/image_gallery_display/select_folder")) {
            ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("THEME_DISPLAY");
            portletURL.setWindowState(LiferayWindowState.POP_UP);
            portletURL.setParameter("struts_action", strutsAction);
            portletURL.setParameter("groupId", String.valueOf(groupId));
            PortalUtil.addPortletBreadcrumbEntry(request, themeDisplay.translate("home"), portletURL.toString());
        } else {
            portletURL.setParameter("struts_action", "/document_library/view");
        }
        DLUtil.addPortletBreadcrumbEntries(folder, request, portletURL);
    }

    public static void addPortletBreadcrumbEntries(long folderId, HttpServletRequest request, RenderResponse renderResponse) throws Exception {
        Folder folder;
        if (folderId != 0L && (folder = DLAppLocalServiceUtil.getFolder(folderId)).getFolderId() != 0L) {
            DLUtil.addPortletBreadcrumbEntries(folder, request, renderResponse);
        }
    }

    public static int compareVersions(String version1, String version2) {
        int[] splitVersion1 = StringUtil.split(version1, ".", 0);
        int[] splitVersion2 = StringUtil.split(version2, ".", 0);
        if (splitVersion1.length != 2 && splitVersion2.length != 2) {
            return 0;
        }
        if (splitVersion1.length != 2) {
            return -1;
        }
        if (splitVersion2.length != 2) {
            return 1;
        }
        if (splitVersion1[0] > splitVersion2[0]) {
            return 1;
        }
        if (splitVersion1[0] < splitVersion2[0]) {
            return -1;
        }
        if (splitVersion1[1] > splitVersion2[1]) {
            return 1;
        }
        if (splitVersion1[1] < splitVersion2[1]) {
            return -1;
        }
        return 0;
    }

    public static Set<String> getAllMediaGalleryMimeTypes() {
        return DLUtil._instance._allMediaGalleryMimeTypes;
    }

    public static String getDDMStructureKey(DLFileEntryType dlFileEntryType) {
        return DLUtil.getDDMStructureKey(dlFileEntryType.getUuid());
    }

    public static String getDDMStructureKey(String fileEntryTypeUuid) {
        return "auto_" + fileEntryTypeUuid;
    }

    public static String getDeprecatedDDMStructureKey(DLFileEntryType dlFileEntryType) {
        return DLUtil.getDeprecatedDDMStructureKey(dlFileEntryType.getFileEntryTypeId());
    }

    public static String getDeprecatedDDMStructureKey(long fileEntryTypeId) {
        return "auto_" + fileEntryTypeId;
    }

    public static String getDividedPath(long id) {
        StringBundler sb = new StringBundler(16);
        long dividend = id;
        while (dividend / 256L != 0L) {
            sb.append("/");
            sb.append(dividend % 256L);
            dividend /= 256L;
        }
        sb.append("/");
        sb.append(id);
        return sb.toString();
    }

    public static String getFileEntryImage(FileEntry fileEntry, ThemeDisplay themeDisplay) {
        StringBundler sb = new StringBundler(5);
        sb.append("<img style=\"border-width: 0; text-align: left;\" src=\"");
        sb.append(themeDisplay.getPathThemeImages());
        sb.append("/file_system/small/");
        sb.append(fileEntry.getIcon());
        sb.append(".png\">");
        return sb.toString();
    }

    public static String getFileIcon(String extension) {
        return _instance._getFileIcon(extension);
    }

    public static String getGenericName(String extension) {
        return _instance._getGenericName(extension);
    }

    public static long[] getGroupIds(long groupId) throws PortalException, SystemException {
        Group scopeGroup = GroupLocalServiceUtil.getGroup(groupId);
        Group companyGroup = GroupLocalServiceUtil.getCompanyGroup(scopeGroup.getCompanyId());
        if (scopeGroup.isLayout()) {
            return new long[]{groupId, scopeGroup.getParentGroupId(), companyGroup.getGroupId()};
        }
        return new long[]{groupId, companyGroup.getGroupId()};
    }

    public static long[] getGroupIds(ThemeDisplay themeDisplay) throws PortalException, SystemException {
        return DLUtil.getGroupIds(themeDisplay.getScopeGroupId());
    }

    public static String[] getMediaGalleryMimeTypes(PortletPreferences portletPreferences, PortletRequest portletRequest) {
        String mimeTypes = PrefsParamUtil.getString(portletPreferences, portletRequest, "mimeTypes", DLUtil._instance._allMediaGalleryMimeTypesString);
        Object[] mimeTypesArray = StringUtil.split(mimeTypes);
        Arrays.sort(mimeTypesArray);
        return mimeTypesArray;
    }

    public static String getPreviewURL(FileEntry fileEntry, FileVersion fileVersion, ThemeDisplay themeDisplay, String queryString) {
        return DLUtil.getPreviewURL(fileEntry, fileVersion, themeDisplay, queryString, true, true);
    }

    public static String getPreviewURL(FileEntry fileEntry, FileVersion fileVersion, ThemeDisplay themeDisplay, String queryString, boolean appendToken) {
        return DLUtil.getPreviewURL(fileEntry, fileVersion, themeDisplay, queryString, true, true);
    }

    public static String getPreviewURL(FileEntry fileEntry, FileVersion fileVersion, ThemeDisplay themeDisplay, String queryString, boolean appendVersion, boolean absoluteURL) {
        StringBundler sb = new StringBundler(15);
        if (themeDisplay != null && absoluteURL) {
            sb.append(themeDisplay.getPortalURL());
        }
        sb.append(PortalUtil.getPathContext());
        sb.append("/documents/");
        sb.append(fileEntry.getRepositoryId());
        sb.append("/");
        sb.append(fileEntry.getFolderId());
        sb.append("/");
        sb.append(HttpUtil.encodeURL(HtmlUtil.unescape(fileEntry.getTitle())));
        sb.append("/");
        sb.append(fileEntry.getUuid());
        if (appendVersion) {
            sb.append("?version=");
            sb.append(fileVersion.getVersion());
        }
        if (ImageProcessorUtil.isImageSupported(fileVersion)) {
            if (appendVersion) {
                sb.append("&t=");
            } else {
                sb.append("?t=");
            }
            Date modifiedDate = fileVersion.getModifiedDate();
            sb.append(modifiedDate.getTime());
        }
        sb.append(queryString);
        String previewURL = sb.toString();
        if (themeDisplay != null && themeDisplay.isAddSessionIdToURL()) {
            return PortalUtil.getURLWithSessionId(previewURL, themeDisplay.getSessionId());
        }
        return previewURL;
    }

    public static OrderByComparator getRepositoryModelOrderByComparator(String orderByCol, String orderByType) {
        boolean orderByAsc = true;
        if (orderByType.equals("desc")) {
            orderByAsc = false;
        }
        OrderByComparator orderByComparator = null;
        orderByComparator = orderByCol.equals("creationDate") ? new RepositoryModelCreateDateComparator(orderByAsc) : (orderByCol.equals("downloads") ? new RepositoryModelReadCountComparator(orderByAsc) : (orderByCol.equals("modifiedDate") ? new RepositoryModelModifiedDateComparator(orderByAsc) : (orderByCol.equals("size") ? new RepositoryModelSizeComparator(orderByAsc) : new RepositoryModelNameComparator(orderByAsc))));
        return orderByComparator;
    }

    public static String getTempFileId(long id, String version) {
        return DLUtil.getTempFileId(id, version, null);
    }

    public static String getTempFileId(long id, String version, String languageId) {
        if (Validator.isNull(languageId)) {
            return String.valueOf(id).concat(".").concat(version);
        }
        StringBundler sb = new StringBundler(5);
        sb.append(id);
        sb.append(".");
        sb.append(version);
        sb.append(".");
        sb.append(languageId);
        return sb.toString();
    }

    public static String getThumbnailSrc(FileEntry fileEntry, DLFileShortcut dlFileShortcut, ThemeDisplay themeDisplay) throws Exception {
        return DLUtil.getThumbnailSrc(fileEntry, fileEntry.getFileVersion(), dlFileShortcut, themeDisplay);
    }

    public static String getThumbnailSrc(FileEntry fileEntry, FileVersion fileVersion, DLFileShortcut dlFileShortcut, ThemeDisplay themeDisplay) throws Exception {
        StringBundler sb = new StringBundler(4);
        sb.append(themeDisplay.getPathThemeImages());
        sb.append("/file_system/large/");
        sb.append(DLUtil.getGenericName(fileEntry.getExtension()));
        sb.append(".png");
        String thumbnailSrc = sb.toString();
        if (dlFileShortcut == null) {
            String thumbnailQueryString = null;
            if (GetterUtil.getBoolean(PropsUtil.get("dl.file.entry.thumbnail.enabled"))) {
                if (ImageProcessorUtil.hasImages(fileVersion)) {
                    thumbnailQueryString = "&imageThumbnail=1";
                } else if (PDFProcessorUtil.hasImages(fileVersion)) {
                    thumbnailQueryString = "&documentThumbnail=1";
                } else if (VideoProcessorUtil.hasVideo(fileVersion)) {
                    thumbnailQueryString = "&videoThumbnail=1";
                }
            }
            if (Validator.isNotNull(thumbnailQueryString)) {
                thumbnailSrc = DLUtil.getPreviewURL(fileEntry, fileVersion, themeDisplay, thumbnailQueryString, true, true);
            }
        }
        return thumbnailSrc;
    }

    public static String getThumbnailStyle() throws Exception {
        StringBundler sb = new StringBundler(5);
        sb.append("max-height: ");
        sb.append(PrefsPropsUtil.getLong("dl.file.entry.thumbnail.max.height"));
        sb.append("px; max-width: ");
        sb.append(PrefsPropsUtil.getLong("dl.file.entry.thumbnail.max.width"));
        sb.append("px;");
        return sb.toString();
    }

    public static String getTitleWithExtension(FileEntry fileEntry) {
        String title = fileEntry.getTitle();
        String extension = fileEntry.getExtension();
        return DLUtil.getTitleWithExtension(title, extension);
    }

    public static String getTitleWithExtension(String title, String extension) {
        String periodAndExtension;
        if (Validator.isNotNull(extension) && !title.endsWith(periodAndExtension = "." + extension)) {
            title = String.valueOf(title) + periodAndExtension;
        }
        return title;
    }

    public static String getWebDavURL(ThemeDisplay themeDisplay, Folder folder, FileEntry fileEntry) throws PortalException, SystemException {
        return DLUtil.getWebDavURL(themeDisplay, folder, fileEntry, false);
    }

    public static String getWebDavURL(ThemeDisplay themeDisplay, Folder folder, FileEntry fileEntry, boolean openDocumentUrl) throws PortalException, SystemException {
        StringBundler webDavURL = new StringBundler(7);
        boolean secure = false;
        if (themeDisplay.isSecure() || _WEBDAV_SERVLET_HTTPS_REQUIRED) {
            secure = true;
        }
        String portalURL = PortalUtil.getPortalURL(themeDisplay.getServerName(), themeDisplay.getServerPort(), secure);
        webDavURL.append(portalURL);
        webDavURL.append(themeDisplay.getPathContext());
        webDavURL.append("/api/secure/webdav");
        String fileEntryTitle = null;
        if (fileEntry != null) {
            String extension = fileEntry.getExtension();
            fileEntryTitle = HtmlUtil.unescape(fileEntry.getTitle());
            if (openDocumentUrl && DLUtil.isOfficeExtension(extension) && !fileEntryTitle.endsWith("." + extension)) {
                webDavURL.append(OFFICE_EXTENSION_PATH);
                fileEntryTitle = String.valueOf(fileEntryTitle) + "." + extension;
            }
        }
        Group group = themeDisplay.getScopeGroup();
        webDavURL.append(group.getFriendlyURL());
        webDavURL.append("/document_library");
        StringBuilder sb = new StringBuilder();
        if (folder != null && folder.getFolderId() != 0L) {
            Folder curFolder = folder;
            while (true) {
                sb.insert(0, HttpUtil.encodeURL(curFolder.getName(), true));
                sb.insert(0, "/");
                if (curFolder.getParentFolderId() == 0L) break;
                curFolder = DLAppLocalServiceUtil.getFolder(curFolder.getParentFolderId());
            }
        }
        if (fileEntry != null) {
            sb.append("/");
            sb.append(HttpUtil.encodeURL(fileEntryTitle, true));
        }
        webDavURL.append(sb.toString());
        return webDavURL.toString();
    }

    public static boolean hasWorkflowDefinitionLink(long companyId, long groupId, long folderId, long fileEntryTypeId) throws Exception {
        while (folderId != 0L) {
            DLFolder dlFolder = DLFolderLocalServiceUtil.fetchDLFolder(folderId);
            if (dlFolder == null) {
                return false;
            }
            if (dlFolder.isOverrideFileEntryTypes()) break;
            folderId = dlFolder.getParentFolderId();
        }
        return WorkflowDefinitionLinkLocalServiceUtil.hasWorkflowDefinitionLink(companyId, groupId, DLFolderConstants.getClassName(), folderId, fileEntryTypeId) || WorkflowDefinitionLinkLocalServiceUtil.hasWorkflowDefinitionLink(companyId, groupId, DLFolderConstants.getClassName(), folderId, -1L);
    }

    public static boolean isAutoGeneratedDLFileEntryTypeDDMStructureKey(String ddmStructureKey) {
        return ddmStructureKey.startsWith("auto_");
    }

    public static boolean isOfficeExtension(String extension) {
        return extension.equalsIgnoreCase("doc") || extension.equalsIgnoreCase("docx") || extension.equalsIgnoreCase("dot") || extension.equalsIgnoreCase("ppt") || extension.equalsIgnoreCase("pptx") || extension.equalsIgnoreCase("xls") || extension.equalsIgnoreCase("xlsx");
    }

    private static long _getDefaultFolderId(HttpServletRequest request) throws Exception {
        PortletPreferences portletPreferences = PortletPreferencesFactoryUtil.getPortletPreferences(request, PortalUtil.getPortletId(request));
        return GetterUtil.getLong(portletPreferences.getValue("rootFolderId", String.valueOf(0L)));
    }

    private DLUtil() {
        String[] genericNames;
        this._allMediaGalleryMimeTypes.addAll(SetUtil.fromArray(PropsUtil.getArray("dl.file.entry.preview.audio.mime.types")));
        this._allMediaGalleryMimeTypes.addAll(SetUtil.fromArray(PropsUtil.getArray("dl.file.entry.preview.video.mime.types")));
        this._allMediaGalleryMimeTypes.addAll(SetUtil.fromArray(PropsUtil.getArray("dl.file.entry.preview.image.mime.types")));
        this._allMediaGalleryMimeTypesString = StringUtil.merge(this._allMediaGalleryMimeTypes);
        String[] fileIcons = null;
        try {
            fileIcons = PrefsPropsUtil.getStringArray("dl.file.icons", ",");
        }
        catch (Exception e) {
            _log.error(e, e);
            fileIcons = new String[]{""};
        }
        int i = 0;
        while (i < fileIcons.length) {
            if (!"*".equals(fileIcons[i])) {
                String extension = fileIcons[i];
                extension = extension.substring(1);
                this._fileIcons.add(extension);
            }
            ++i;
        }
        String[] stringArray = genericNames = PropsUtil.getArray("dl.file.generic.names");
        int n = genericNames.length;
        int n2 = 0;
        while (n2 < n) {
            String genericName = stringArray[n2];
            this._populateGenericNamesMap(genericName);
            ++n2;
        }
    }

    private String _getFileIcon(String extension) {
        if (!this._fileIcons.contains(extension)) {
            extension = _DEFAULT_FILE_ICON;
        }
        return extension;
    }

    private String _getGenericName(String extension) {
        String genericName = this._genericNames.get(extension);
        if (genericName == null) {
            genericName = _DEFAULT_GENERIC_NAME;
        }
        return genericName;
    }

    private void _populateGenericNamesMap(String genericName) {
        String[] extensions;
        String[] stringArray = extensions = PropsUtil.getArray("dl.file.generic.extensions", new Filter(genericName));
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            String extension = stringArray[n2];
            this._genericNames.put(extension, genericName);
            ++n2;
        }
    }
}

