/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.util.comparator;

import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFileShortcut;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.service.DLFileEntryLocalServiceUtil;

public class RepositoryModelSizeComparator
extends OrderByComparator {
    public static final String ORDER_BY_ASC = "size_ ASC";
    public static final String ORDER_BY_DESC = "size_ DESC";
    public static final String[] ORDER_BY_FIELDS = new String[]{"size_"};
    private boolean _ascending;

    public RepositoryModelSizeComparator() {
        this(false);
    }

    public RepositoryModelSizeComparator(boolean ascending) {
        this._ascending = ascending;
    }

    @Override
    public int compare(Object obj1, Object obj2) {
        Long size1 = this.getSize(obj1);
        Long size2 = this.getSize(obj2);
        int value = size1.compareTo(size2);
        if (this._ascending) {
            return value;
        }
        return -value;
    }

    @Override
    public String getOrderBy() {
        if (this._ascending) {
            return ORDER_BY_ASC;
        }
        return ORDER_BY_DESC;
    }

    @Override
    public String[] getOrderByFields() {
        return ORDER_BY_FIELDS;
    }

    @Override
    public boolean isAscending() {
        return this._ascending;
    }

    protected long getSize(Object obj) {
        if (obj instanceof DLFileEntry) {
            DLFileEntry dlFileEntry = (DLFileEntry)obj;
            return dlFileEntry.getSize();
        }
        if (obj instanceof DLFileShortcut) {
            DLFileShortcut dlFileShortcut = (DLFileShortcut)obj;
            long toFileEntryId = dlFileShortcut.getToFileEntryId();
            try {
                DLFileEntry dlFileEntry = DLFileEntryLocalServiceUtil.getFileEntry(toFileEntryId);
                return dlFileEntry.getSize();
            }
            catch (Exception exception) {
                return 0L;
            }
        }
        if (obj instanceof DLFolder || obj instanceof Folder) {
            return 0L;
        }
        FileEntry fileEntry = (FileEntry)obj;
        return fileEntry.getSize();
    }
}

