/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.social.model;

import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.User;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.social.model.SocialActivity;
import com.liferay.portlet.social.model.SocialActivityFeedEntry;
import com.liferay.portlet.social.model.SocialActivityInterpreter;

public abstract class BaseSocialActivityInterpreter
implements SocialActivityInterpreter {
    private static Log _log = LogFactoryUtil.getLog(BaseSocialActivityInterpreter.class);

    @Override
    public SocialActivityFeedEntry interpret(SocialActivity activity, ThemeDisplay themeDisplay) {
        try {
            return this.doInterpret(activity, themeDisplay);
        }
        catch (Exception e) {
            _log.error("Unable to interpret activity", e);
            return null;
        }
    }

    protected String cleanContent(String content) {
        return StringUtil.shorten(HtmlUtil.extractText(content), 200);
    }

    protected abstract SocialActivityFeedEntry doInterpret(SocialActivity var1, ThemeDisplay var2) throws Exception;

    protected String getGroupName(long groupId, ThemeDisplay themeDisplay) {
        block8: {
            try {
                if (groupId > 0L) break block8;
                return "";
            }
            catch (Exception exception) {
                return "";
            }
        }
        Group group = GroupLocalServiceUtil.getGroup(groupId);
        String groupName = group.getDescriptiveName();
        if (group.getGroupId() == themeDisplay.getScopeGroupId()) {
            return HtmlUtil.escape(groupName);
        }
        String groupDisplayURL = String.valueOf(themeDisplay.getPortalURL()) + themeDisplay.getPathMain() + "/my_sites/view?groupId=" + group.getGroupId();
        if (group.hasPublicLayouts()) {
            groupDisplayURL = String.valueOf(groupDisplayURL) + "&privateLayout=0";
        } else if (group.hasPrivateLayouts()) {
            groupDisplayURL = String.valueOf(groupDisplayURL) + "&privateLayout=1";
        } else {
            return HtmlUtil.escape(groupName);
        }
        groupName = "<a class=\"group\" href=\"" + groupDisplayURL + "\">" + HtmlUtil.escape(groupName) + "</a>";
        return groupName;
    }

    protected String getUserName(long userId, ThemeDisplay themeDisplay) {
        block5: {
            try {
                if (userId > 0L) break block5;
                return "";
            }
            catch (Exception exception) {
                return "";
            }
        }
        User user = UserLocalServiceUtil.getUserById(userId);
        if (user.getUserId() == themeDisplay.getUserId()) {
            return HtmlUtil.escape(user.getFirstName());
        }
        String userName = user.getFullName();
        Group group = user.getGroup();
        if (group.getGroupId() == themeDisplay.getScopeGroupId()) {
            return HtmlUtil.escape(userName);
        }
        String userDisplayURL = user.getDisplayURL(themeDisplay);
        userName = "<a class=\"user\" href=\"" + userDisplayURL + "\">" + HtmlUtil.escape(userName) + "</a>";
        return userName;
    }

    protected String getValue(String extraData, String key, String defaultValue) {
        if (Validator.isNull(extraData)) {
            return HtmlUtil.escape(defaultValue);
        }
        try {
            JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject(extraData);
            String value = extraDataJSONObject.getString(key);
            if (Validator.isNotNull(value)) {
                return HtmlUtil.escape(value);
            }
        }
        catch (JSONException jSONException) {
            _log.error("Unable to create JSON object from " + extraData);
        }
        return HtmlUtil.escape(defaultValue);
    }

    protected String wrapLink(String link, String text) {
        StringBundler sb = new StringBundler(5);
        sb.append("<a href=\"");
        sb.append(link);
        sb.append("\">");
        sb.append(text);
        sb.append("</a>");
        return sb.toString();
    }

    protected String wrapLink(String link, String key, ThemeDisplay themeDisplay) {
        return this.wrapLink(link, themeDisplay.translate(key));
    }
}

