/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.app.builder.workflow.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.MVCCModel;
import com.liferay.portal.kernel.model.ShardedModel;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the AppBuilderWorkflowTaskLink service. Represents a row in the &quot;AppBuilderWorkflowTaskLink&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.app.builder.workflow.model.impl.AppBuilderWorkflowTaskLinkModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.app.builder.workflow.model.impl.AppBuilderWorkflowTaskLinkImpl</code>.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see AppBuilderWorkflowTaskLink
 * @generated
 */
@ProviderType
public interface AppBuilderWorkflowTaskLinkModel
	extends BaseModel<AppBuilderWorkflowTaskLink>, MVCCModel, ShardedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a app builder workflow task link model instance should use the {@link AppBuilderWorkflowTaskLink} interface instead.
	 */

	/**
	 * Returns the primary key of this app builder workflow task link.
	 *
	 * @return the primary key of this app builder workflow task link
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this app builder workflow task link.
	 *
	 * @param primaryKey the primary key of this app builder workflow task link
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the mvcc version of this app builder workflow task link.
	 *
	 * @return the mvcc version of this app builder workflow task link
	 */
	@Override
	public long getMvccVersion();

	/**
	 * Sets the mvcc version of this app builder workflow task link.
	 *
	 * @param mvccVersion the mvcc version of this app builder workflow task link
	 */
	@Override
	public void setMvccVersion(long mvccVersion);

	/**
	 * Returns the app builder workflow task link ID of this app builder workflow task link.
	 *
	 * @return the app builder workflow task link ID of this app builder workflow task link
	 */
	public long getAppBuilderWorkflowTaskLinkId();

	/**
	 * Sets the app builder workflow task link ID of this app builder workflow task link.
	 *
	 * @param appBuilderWorkflowTaskLinkId the app builder workflow task link ID of this app builder workflow task link
	 */
	public void setAppBuilderWorkflowTaskLinkId(
		long appBuilderWorkflowTaskLinkId);

	/**
	 * Returns the company ID of this app builder workflow task link.
	 *
	 * @return the company ID of this app builder workflow task link
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this app builder workflow task link.
	 *
	 * @param companyId the company ID of this app builder workflow task link
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the app builder app ID of this app builder workflow task link.
	 *
	 * @return the app builder app ID of this app builder workflow task link
	 */
	public long getAppBuilderAppId();

	/**
	 * Sets the app builder app ID of this app builder workflow task link.
	 *
	 * @param appBuilderAppId the app builder app ID of this app builder workflow task link
	 */
	public void setAppBuilderAppId(long appBuilderAppId);

	/**
	 * Returns the app builder app version ID of this app builder workflow task link.
	 *
	 * @return the app builder app version ID of this app builder workflow task link
	 */
	public long getAppBuilderAppVersionId();

	/**
	 * Sets the app builder app version ID of this app builder workflow task link.
	 *
	 * @param appBuilderAppVersionId the app builder app version ID of this app builder workflow task link
	 */
	public void setAppBuilderAppVersionId(long appBuilderAppVersionId);

	/**
	 * Returns the ddm structure layout ID of this app builder workflow task link.
	 *
	 * @return the ddm structure layout ID of this app builder workflow task link
	 */
	public long getDdmStructureLayoutId();

	/**
	 * Sets the ddm structure layout ID of this app builder workflow task link.
	 *
	 * @param ddmStructureLayoutId the ddm structure layout ID of this app builder workflow task link
	 */
	public void setDdmStructureLayoutId(long ddmStructureLayoutId);

	/**
	 * Returns the read only of this app builder workflow task link.
	 *
	 * @return the read only of this app builder workflow task link
	 */
	public boolean getReadOnly();

	/**
	 * Returns <code>true</code> if this app builder workflow task link is read only.
	 *
	 * @return <code>true</code> if this app builder workflow task link is read only; <code>false</code> otherwise
	 */
	public boolean isReadOnly();

	/**
	 * Sets whether this app builder workflow task link is read only.
	 *
	 * @param readOnly the read only of this app builder workflow task link
	 */
	public void setReadOnly(boolean readOnly);

	/**
	 * Returns the workflow task name of this app builder workflow task link.
	 *
	 * @return the workflow task name of this app builder workflow task link
	 */
	@AutoEscape
	public String getWorkflowTaskName();

	/**
	 * Sets the workflow task name of this app builder workflow task link.
	 *
	 * @param workflowTaskName the workflow task name of this app builder workflow task link
	 */
	public void setWorkflowTaskName(String workflowTaskName);

}