/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */
'use strict';

Liferay.Loader.define("commerce-frontend-taglib@10.1.4/address_modal/AddressModal.es", ['module', 'exports', 'require', 'frontend-js-web', 'frontend-js-metal-web$metal-component', 'frontend-js-metal-web$metal-soy', './AddressModal.soy', 'frontend-taglib-clay$clay-modal', '../input_utils/CommerceInputText'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = exports.AddressModal = void 0;

    var _frontendJsWeb = require("frontend-js-web");

    var _metalComponent = _interopRequireDefault(require("frontend-js-metal-web$metal-component"));

    var _metalSoy = _interopRequireWildcard(require("frontend-js-metal-web$metal-soy"));

    var _AddressModal = _interopRequireDefault(require("./AddressModal.soy"));

    require("frontend-taglib-clay$clay-modal");

    require("../input_utils/CommerceInputText");

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    function _classCallCheck(instance, Constructor) {
      if (!(instance instanceof Constructor)) {
        throw new TypeError("Cannot call a class as a function");
      }
    }

    function _defineProperties(target, props) {
      for (var i = 0; i < props.length; i++) {
        var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
      }
    }

    function _createClass(Constructor, protoProps, staticProps) {
      if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
    }

    function _possibleConstructorReturn(self, call) {
      if (call && (_typeof(call) === "object" || typeof call === "function")) {
        return call;
      }return _assertThisInitialized(self);
    }

    function _assertThisInitialized(self) {
      if (self === void 0) {
        throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
      }return self;
    }

    function _getPrototypeOf(o) {
      _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
        return o.__proto__ || Object.getPrototypeOf(o);
      };return _getPrototypeOf(o);
    }

    function _inherits(subClass, superClass) {
      if (typeof superClass !== "function" && superClass !== null) {
        throw new TypeError("Super expression must either be null or a function");
      }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
    }

    function _setPrototypeOf(o, p) {
      _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
        o.__proto__ = p;return o;
      };return _setPrototypeOf(o, p);
    }

    var AddressModal = /*#__PURE__*/function (_Component) {
      _inherits(AddressModal, _Component);

      function AddressModal() {
        _classCallCheck(this, AddressModal);

        return _possibleConstructorReturn(this, _getPrototypeOf(AddressModal).apply(this, arguments));
      }

      _createClass(AddressModal, [{
        key: "attached",
        value: function attached() {
          return this._fetchCountries();
        }
      }, {
        key: "sync_formData",
        value: function sync_formData() {
          return this._validateForms();
        }
      }, {
        key: "_handleFirstDotClick",
        value: function _handleFirstDotClick(e) {
          e.preventDefault();
          this._stage = 1;
          return this._stage;
        }
      }, {
        key: "_handleSecondDotClick",
        value: function _handleSecondDotClick(e) {
          return this._handleNextButton(e);
        }
      }, {
        key: "_handleNextButton",
        value: function _handleNextButton(e) {
          e.preventDefault();
          this._firstFormValid = this.refs.modal.refs.firstForm.checkValidity();

          if (this._firstFormValid) {
            this._stage = 2;
          }

          return e;
        }
      }, {
        key: "_handleCloseModal",
        value: function _handleCloseModal(e) {
          e.preventDefault();
          this._modalVisible = false;
          return e;
        }
      }, {
        key: "_handleSelectBox",
        value: function _handleSelectBox(e) {
          var value = e.target.value;

          if (e.target.name === 'commerceCountry') {
            this._formData = _objectSpread(_objectSpread({}, this._formData), {}, {
              country: value
            });

            var country = this._countries.filter(function (country) {
              return country.id == value;
            });

            if (country.length === 1) {
              this._isBillingAllowed = country[0].billingAllowed;
              this._isShippingAllowed = country[0].shippingAllowed;

              this._fetchRegions();
            } else {
              this._regions = [];
            }
          } else if (e.target.name === 'addressType') {
            this._formData = _objectSpread(_objectSpread({}, this._formData), {}, {
              addressType: value
            });
          } else {
            this._formData = _objectSpread(_objectSpread({}, this._formData), {}, {
              region: value
            });
          }

          return value;
        }
      }, {
        key: "_handleInputBox",
        value: function _handleInputBox(evt) {
          this._formData = _objectSpread(_objectSpread({}, this._formData), {}, _defineProperty({}, evt.target.name, evt.target.value));
          return evt.target.value;
        }
      }, {
        key: "_validateForms",
        value: function _validateForms() {
          var firstFormValid = !!(this._formData.address && this._formData.address.length && this._formData.city && this._formData.city.length && this._formData.zipCode && this._formData.zipCode.length && this._formData.country && this._formData.country.length && this._formData.region && this._formData.region.length);
          this._firstFormValid = firstFormValid;
          var secondFormValid = !!(this._formData.referent && this._formData.referent.length);
          this._secondFormValid = secondFormValid;
          return this._firstFormValid && this._secondFormValid;
        }
      }, {
        key: "fetchExistingAddress",
        value: function fetchExistingAddress(id) {
          var _this = this;

          (0, _frontendJsWeb.fetch)('/o/commerce-ui/address/' + id).then(function (response) {
            return response.json();
          }).then(function (jsonResponse) {
            var data = JSON.parse(jsonResponse);
            _this._formData = _objectSpread(_objectSpread({}, _this._formData), {}, {
              address: data.street1,
              addressType: data.type,
              city: data.city,
              country: data.commerceCountryId,
              id: id,
              referent: data.name,
              region: data.commerceRegionId,
              telephone: data.phoneNumber,
              zipCode: data.zip
            });

            _this._fetchRegions();
          });
        }
      }, {
        key: "_fetchCountries",
        value: function _fetchCountries() {
          var _this2 = this;

          return (0, _frontendJsWeb.fetch)(this.countriesAPI).then(function (response) {
            return response.json();
          }).then(function (countries) {
            _this2._countries = countries;
            return _this2._countries;
          });
        }
      }, {
        key: "_fetchRegions",
        value: function _fetchRegions() {
          var _this3 = this;

          return (0, _frontendJsWeb.fetch)(this.regionsAPI + this._formData.country).then(function (response) {
            return response.json();
          }).then(function (regions) {
            _this3._regions = regions;
            return _this3._regions;
          });
        }
      }, {
        key: "_handleFormSubmit",
        value: function _handleFormSubmit(e) {
          e.preventDefault();

          if (this._firstFormValid && this._secondFormValid) {
            this._addAddress(e);
          }

          return e;
        }
      }, {
        key: "_addAddress",
        value: function _addAddress(_e) {
          return this.emit('addressModalSave', this._formData);
        }
      }, {
        key: "resetForm",
        value: function resetForm() {
          this._formData = {
            address: null,
            addressType: 2,
            city: null,
            country: null,
            id: null,
            referent: null,
            region: null,
            telephone: null,
            zipCode: null
          };
          this._stage = 1;
        }
      }, {
        key: "toggle",
        value: function toggle() {
          this._modalVisible = !this._modalVisible;
          return this._modalVisible;
        }
      }, {
        key: "open",
        value: function open() {
          this._modalVisible = true;
          return this._modalVisible;
        }
      }, {
        key: "close",
        value: function close() {
          this._modalVisible = false;
          return this._modalVisible;
        }
      }]);

      return AddressModal;
    }(_metalComponent.default);

    exports.AddressModal = AddressModal;

    _metalSoy.default.register(AddressModal, _AddressModal.default);

    AddressModal.STATE = {
      _countries: _metalSoy.Config.array(_metalSoy.Config.shapeOf({
        billingAllowed: _metalSoy.Config.bool().required(),
        id: _metalSoy.Config.number().required(),
        name: _metalSoy.Config.string().required(),
        shippingAllowed: _metalSoy.Config.bool().required()
      })).value([]),
      _firstFormValid: _metalSoy.Config.bool().value(false),
      _formData: _metalSoy.Config.shapeOf({
        address: _metalSoy.Config.string(),
        addressType: _metalSoy.Config.oneOfType([_metalSoy.Config.string(), _metalSoy.Config.number()]),
        city: _metalSoy.Config.string(),
        country: _metalSoy.Config.oneOfType([_metalSoy.Config.string(), _metalSoy.Config.number()]),
        id: _metalSoy.Config.oneOfType([_metalSoy.Config.string(), _metalSoy.Config.number()]),
        referent: _metalSoy.Config.string(),
        region: _metalSoy.Config.oneOfType([_metalSoy.Config.string(), _metalSoy.Config.number()]),
        telephone: _metalSoy.Config.string(),
        zipCode: _metalSoy.Config.string()
      }).value({
        address: null,
        addressType: 2,
        city: null,
        country: null,
        id: null,
        referent: null,
        region: null,
        telephone: null,
        zipCode: null
      }),
      _isBillingAllowed: _metalSoy.Config.bool().value(true),
      _isShippingAllowed: _metalSoy.Config.bool().value(true),
      _modalVisible: _metalSoy.Config.bool().internal().value(false),
      _regions: _metalSoy.Config.array(_metalSoy.Config.shapeOf({
        id: _metalSoy.Config.number().required(),
        name: _metalSoy.Config.string().required()
      })).value([]),
      _secondFormValid: _metalSoy.Config.bool().value(false),
      _stage: _metalSoy.Config.number(_metalSoy.Config.oneOf([1, 2])).value(1),
      countriesAPI: _metalSoy.Config.string().required(),
      regionsAPI: _metalSoy.Config.string().required(),
      spritemap: _metalSoy.Config.string()
    };
    var _default = AddressModal;
    exports.default = _default;
    //# sourceMappingURL=AddressModal.es.js.map
  }
});
//# sourceMappingURL=AddressModal.es.js.map