Liferay.Loader.define("data-engine-taglib@2.5.24/data_layout_builder/js/components/field-sets/FieldSets.es", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/button', 'frontend-js-react-web$react', '../../AppContext.es', '../../actions.es', '../../data-layout-builder/DataLayoutBuilderContext.es', '../../drag-and-drop/dragTypes.es', '../../utils/dataDefinition.es', '../../utils/lang.es', '../empty-state/EmptyState.es', '../field-types/FieldType.es', './FieldSetModal.es', './actions/useDeleteFieldSet.es', './actions/usePropagateFieldSet.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = FieldSets;

    var _button = _interopRequireDefault(require("@frontend-taglib-clay$clayui/button"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _AppContext = _interopRequireDefault(require("../../AppContext.es"));

    var _actions = require("../../actions.es");

    var _DataLayoutBuilderContext = _interopRequireDefault(require("../../data-layout-builder/DataLayoutBuilderContext.es"));

    var _dragTypes = require("../../drag-and-drop/dragTypes.es");

    var _dataDefinition = require("../../utils/dataDefinition.es");

    var _lang = require("../../utils/lang.es");

    var _EmptyState = _interopRequireDefault(require("../empty-state/EmptyState.es"));

    var _FieldType = _interopRequireDefault(require("../field-types/FieldType.es"));

    var _FieldSetModal = _interopRequireDefault(require("./FieldSetModal.es"));

    var _useDeleteFieldSet = _interopRequireDefault(require("./actions/useDeleteFieldSet.es"));

    var _usePropagateFieldSet = _interopRequireDefault(require("./actions/usePropagateFieldSet.es"));

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _extends() {
      _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
          var source = arguments[i];for (var key in source) {
            if (Object.prototype.hasOwnProperty.call(source, key)) {
              target[key] = source[key];
            }
          }
        }return target;
      };return _extends.apply(this, arguments);
    }

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    function FieldSets(_ref) {
      var keywords = _ref.keywords;

      var _useContext = (0, _react.useContext)(_DataLayoutBuilderContext.default),
          _useContext2 = _slicedToArray(_useContext, 1),
          dataLayoutBuilder = _useContext2[0];

      var _useContext3 = (0, _react.useContext)(_AppContext.default),
          _useContext4 = _slicedToArray(_useContext3, 1),
          _useContext4$ = _useContext4[0],
          appProps = _useContext4$.appProps,
          dataDefinition = _useContext4$.dataDefinition,
          fieldSets = _useContext4$.fieldSets;

      var _useState = (0, _react.useState)({
        childrenAppProps: {},
        editingDataDefinition: null,
        fieldSet: null,
        isVisible: false
      }),
          _useState2 = _slicedToArray(_useState, 2),
          state = _useState2[0],
          setState = _useState2[1];

      var defaultLanguageId = themeDisplay.getDefaultLanguageId();

      var toggleFieldSet = function toggleFieldSet(fieldSet, editingDataDefinition) {
        var childrenAppProps = {
          availableLanguageIds: [defaultLanguageId],
          context: {},
          dataDefinitionId: null,
          dataLayoutId: null,
          editingLanguageId: defaultLanguageId
        };

        if (fieldSet) {
          var context = appProps.context;
          var defaultDataLayout = fieldSet.defaultDataLayout,
              dataDefinitionId = fieldSet.id;
          var ddmForm = dataLayoutBuilder.getDDMForm(fieldSet, defaultDataLayout);

          var _ddmForm$pages = _slicedToArray(ddmForm.pages, 1),
              rows = _ddmForm$pages[0].rows;

          delete ddmForm.pages;
          defaultLanguageId = fieldSet.defaultLanguageId;
          childrenAppProps = {
            availableLanguageIds: fieldSet.availableLanguageIds,
            context: _objectSpread(_objectSpread({}, context), {}, {
              pages: [_objectSpread(_objectSpread({}, ddmForm), {}, {
                description: '',
                rows: rows,
                title: ''
              })]
            }),
            dataDefinitionId: dataDefinitionId,
            dataLayoutId: defaultDataLayout.id,
            editingLanguageId: defaultLanguageId
          };
        }

        setState({
          childrenAppProps: childrenAppProps,
          defaultLanguageId: defaultLanguageId,
          editingDataDefinition: editingDataDefinition,
          fieldSet: fieldSet,
          isVisible: !state.isVisible
        });
      };

      var deleteFieldSet = (0, _useDeleteFieldSet.default)({
        dataLayoutBuilder: dataLayoutBuilder
      });
      var propagateFieldSet = (0, _usePropagateFieldSet.default)();

      var onDoubleClick = function onDoubleClick(_ref2) {
        var fieldName = _ref2.fieldSet.name,
            fieldSet = _ref2.fieldSet;

        var _dataLayoutBuilder$ge = dataLayoutBuilder.getStore(),
            activePage = _dataLayoutBuilder$ge.activePage,
            pages = _dataLayoutBuilder$ge.pages;

        dataLayoutBuilder.dispatch('fieldSetAdded', (0, _actions.dropFieldSet)({
          dataLayoutBuilder: dataLayoutBuilder,
          fieldName: fieldName,
          fieldSet: fieldSet,
          indexes: {
            columnIndex: 0,
            pageIndex: activePage,
            rowIndex: pages[activePage].rows.length
          }
        }));
      };

      var filteredFieldSets = fieldSets.filter(function (_ref3) {
        var defaultLanguageId = _ref3.defaultLanguageId,
            name = _ref3.name;
        return new RegExp(keywords, 'ig').test((0, _lang.getLocalizedValue)(defaultLanguageId, name));
      }).sort(function (a, b) {
        var localizedValueA = (0, _lang.getLocalizedValue)(a.defaultLanguageId, a.name);
        var localizedValueB = (0, _lang.getLocalizedValue)(b.defaultLanguageId, b.name);
        return localizedValueA.localeCompare(localizedValueB);
      });

      var AddButton = function AddButton() {
        return (/*#__PURE__*/_react.default.createElement(_button.default, {
            block: true,
            className: "add-fieldset",
            displayType: "secondary",
            onClick: function onClick() {
              return toggleFieldSet(null, dataDefinition);
            }
          }, Liferay.Language.get('create-new-fieldset'))
        );
      };

      return (/*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, filteredFieldSets.length ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(AddButton, null), /*#__PURE__*/_react.default.createElement("div", {
          className: "mt-3"
        }, filteredFieldSets.map(function (fieldSet) {
          var fieldSetLanguageId = fieldSet.defaultLanguageId;
          var fieldSetName = (0, _lang.getLocalizedValue)(fieldSetLanguageId, fieldSet.name);
          var editAction = {
            action: function action() {
              return toggleFieldSet(fieldSet);
            },
            name: Liferay.Language.get('edit')
          };

          if (defaultLanguageId !== fieldSetLanguageId) {
            editAction = _objectSpread(_objectSpread({}, editAction), {}, {
              className: 'disabled',
              popover: {
                alignPosition: 'left',
                body: Liferay.Language.get('the-fieldset-cannot-be-edited-because-the-instance-language-does-not-match-the-current-language-of-the-fieldset-recreate-the-fieldset-if-changes-are-required'),
                header: Liferay.Language.get('edit-not-allowed')
              }
            });
          }

          var dropDownActions = [editAction, {
            action: function action() {
              return propagateFieldSet({
                fieldSet: fieldSet,
                isDeleteAction: true,
                modal: {
                  actionMessage: Liferay.Language.get('delete'),
                  fieldSetMessage: Liferay.Language.get('the-fieldset-will-be-deleted-permanently-from'),
                  headerMessage: Liferay.Language.get('delete'),
                  status: 'danger',
                  warningMessage: Liferay.Language.get('this-action-may-erase-data-permanently')
                },
                onPropagate: deleteFieldSet
              });
            },
            name: Liferay.Language.get('delete')
          }];
          var disabled = dataDefinition.name[defaultLanguageId] === fieldSetName;
          return (/*#__PURE__*/_react.default.createElement(_FieldType.default, {
              actions: dropDownActions,
              description: "".concat(fieldSet.dataDefinitionFields.length, " ").concat(Liferay.Language.get('fields')),
              disabled: disabled || (0, _dataDefinition.containsFieldSet)(dataDefinition, fieldSet.id),
              dragType: _dragTypes.DRAG_FIELDSET,
              fieldSet: fieldSet,
              icon: "forms",
              key: fieldSet.dataDefinitionKey,
              label: fieldSetName,
              onDoubleClick: onDoubleClick
            })
          );
        }))) : /*#__PURE__*/_react.default.createElement("div", {
          className: "mt-2"
        }, /*#__PURE__*/_react.default.createElement(_EmptyState.default, {
          emptyState: {
            button: AddButton,
            description: Liferay.Language.get('there-are-no-fieldsets-description'),
            title: Liferay.Language.get('there-are-no-fieldsets')
          },
          keywords: keywords,
          small: true
        })), /*#__PURE__*/_react.default.createElement(_FieldSetModal.default, _extends({
          defaultLanguageId: defaultLanguageId,
          onClose: function onClose() {
            return toggleFieldSet();
          }
        }, state)))
      );
    }
    //# sourceMappingURL=FieldSets.es.js.map
  }
});
//# sourceMappingURL=FieldSets.es.js.map