Liferay.Loader.define("data-engine-taglib@2.5.24/data_layout_builder/js/drag-and-drop/getDropHandler.es", ['module', 'exports', 'require', '../actions.es', './dragTypes.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.getDropHandler = void 0;

    var _actions = require("../actions.es");

    var _dragTypes = require("./dragTypes.es");

    function _objectWithoutProperties(source, excluded) {
      if (source == null) return {};var target = _objectWithoutPropertiesLoose(source, excluded);var key, i;if (Object.getOwnPropertySymbols) {
        var sourceSymbolKeys = Object.getOwnPropertySymbols(source);for (i = 0; i < sourceSymbolKeys.length; i++) {
          key = sourceSymbolKeys[i];if (excluded.indexOf(key) >= 0) continue;if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;target[key] = source[key];
        }
      }return target;
    }

    function _objectWithoutPropertiesLoose(source, excluded) {
      if (source == null) return {};var target = {};var sourceKeys = Object.keys(source);var key, i;for (i = 0; i < sourceKeys.length; i++) {
        key = sourceKeys[i];if (excluded.indexOf(key) >= 0) continue;target[key] = source[key];
      }return target;
    }

    var getDropHandler = function getDropHandler(_ref) {
      var dataDefinition = _ref.dataDefinition,
          dataLayoutBuilder = _ref.dataLayoutBuilder;
      return function (_ref2) {
        var item = _ref2.item,
            monitor = _ref2.monitor,
            sourceItem = _ref2.sourceItem;
        var data = item.data,
            type = item.type;

        var fieldName = sourceItem.fieldName,
            origin = sourceItem.origin,
            parentField = sourceItem.parentField,
            indexes = _objectWithoutProperties(sourceItem, ["fieldName", "origin", "parentField"]);

        if (monitor.didDrop()) {
          return;
        }

        switch (type) {
          case _dragTypes.DRAG_FIELD_TYPE:
            {
              if (parentField && parentField.nestedFields && parentField.type !== 'fieldset') {
                throw new Error(Liferay.Language.get('you-cannot-drop-new-fields-to-a-deprecated-field-group'));
              }

              var payload = (0, _actions.dropLayoutBuilderField)({
                dataLayoutBuilder: dataLayoutBuilder,
                fieldName: fieldName,
                fieldTypeName: data.name,
                indexes: indexes,
                parentFieldName: parentField === null || parentField === void 0 ? void 0 : parentField.fieldName
              });
              dataLayoutBuilder.dispatch(origin === 'empty' ? 'fieldAdded' : 'sectionAdded', payload);
              break;
            }

          case _dragTypes.DRAG_DATA_DEFINITION_FIELD:
            {
              var _payload = (0, _actions.dropCustomObjectField)({
                dataDefinition: dataDefinition,
                dataDefinitionFieldName: data.name,
                dataLayoutBuilder: dataLayoutBuilder,
                fieldName: fieldName,
                indexes: indexes,
                parentFieldName: parentField === null || parentField === void 0 ? void 0 : parentField.fieldName
              });

              dataLayoutBuilder.dispatch(origin === 'empty' ? 'fieldAdded' : 'sectionAdded', _payload);
              break;
            }

          case _dragTypes.DRAG_FIELDSET:
            dataLayoutBuilder.dispatch('fieldSetAdded', (0, _actions.dropFieldSet)({
              dataLayoutBuilder: dataLayoutBuilder,
              fieldName: fieldName,
              fieldSet: data.fieldSet,
              indexes: indexes,
              parentFieldName: parentField === null || parentField === void 0 ? void 0 : parentField.fieldName,
              properties: data.properties,
              useFieldName: data.useFieldName
            }));
            break;

          default:
            break;
        }
      };
    };

    exports.getDropHandler = getDropHandler;
    //# sourceMappingURL=getDropHandler.es.js.map
  }
});
//# sourceMappingURL=getDropHandler.es.js.map