Liferay.Loader.define("data-engine-taglib@2.5.24/data_layout_builder/js/utils/dataLayoutVisitor.es", ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.findField = findField;
    exports.containsField = containsField;
    exports.mapDataLayoutColumns = mapDataLayoutColumns;
    exports.deleteField = deleteField;
    exports.getFieldNameFromIndexes = getFieldNameFromIndexes;
    exports.getIndexesFromFieldName = getIndexesFromFieldName;
    exports.normalizeRule = normalizeRule;
    exports.isDataLayoutEmpty = isDataLayoutEmpty;
    exports.normalizeDataLayoutRows = normalizeDataLayoutRows;

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    function _objectWithoutProperties(source, excluded) {
      if (source == null) return {};var target = _objectWithoutPropertiesLoose(source, excluded);var key, i;if (Object.getOwnPropertySymbols) {
        var sourceSymbolKeys = Object.getOwnPropertySymbols(source);for (i = 0; i < sourceSymbolKeys.length; i++) {
          key = sourceSymbolKeys[i];if (excluded.indexOf(key) >= 0) continue;if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;target[key] = source[key];
        }
      }return target;
    }

    function _objectWithoutPropertiesLoose(source, excluded) {
      if (source == null) return {};var target = {};var sourceKeys = Object.keys(source);var key, i;for (i = 0; i < sourceKeys.length; i++) {
        key = sourceKeys[i];if (excluded.indexOf(key) >= 0) continue;target[key] = source[key];
      }return target;
    }

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */
    function findField(dataLayoutPages, fieldName) {
      return (dataLayoutPages || []).find(function (_ref) {
        var dataLayoutRows = _ref.dataLayoutRows;
        return (dataLayoutRows || []).find(function (_ref2) {
          var dataLayoutColumns = _ref2.dataLayoutColumns;
          return (dataLayoutColumns || []).find(function (_ref3) {
            var fieldNames = _ref3.fieldNames;
            return (fieldNames || []).find(function (name) {
              return name === fieldName;
            });
          });
        });
      });
    }

    function containsField(dataLayoutPages, fieldName) {
      return !!findField(dataLayoutPages, fieldName);
    }

    function mapDataLayoutColumns(dataLayoutPages) {
      var fn = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : function () {};
      return (dataLayoutPages || []).map(function (_ref4, pageIndex) {
        var dataLayoutRows = _ref4.dataLayoutRows,
            dataLayoutPage = _objectWithoutProperties(_ref4, ["dataLayoutRows"]);

        return _objectSpread(_objectSpread({}, dataLayoutPage), {}, {
          dataLayoutRows: (dataLayoutRows || []).map(function (_ref5, rowIndex) {
            var dataLayoutColumns = _ref5.dataLayoutColumns,
                dataLayoutRow = _objectWithoutProperties(_ref5, ["dataLayoutColumns"]);

            return _objectSpread(_objectSpread({}, dataLayoutRow), {}, {
              dataLayoutColumns: dataLayoutColumns.map(function (dataLayoutColumn, columnIndex) {
                return fn(dataLayoutColumn, columnIndex, rowIndex, pageIndex);
              })
            });
          })
        });
      });
    }

    function deleteField(dataLayoutPages, fieldName) {
      return mapDataLayoutColumns(dataLayoutPages, function (_ref6) {
        var fieldNames = _ref6.fieldNames,
            dataLayoutColumn = _objectWithoutProperties(_ref6, ["fieldNames"]);

        return _objectSpread(_objectSpread({}, dataLayoutColumn), {}, {
          fieldNames: (fieldNames || []).filter(function (name) {
            return name !== fieldName;
          })
        });
      });
    }

    function getFieldNameFromIndexes(_ref7, _ref8) {
      var dataLayoutPages = _ref7.dataLayoutPages;
      var columnIndex = _ref8.columnIndex,
          _ref8$fieldIndex = _ref8.fieldIndex,
          fieldIndex = _ref8$fieldIndex === void 0 ? 0 : _ref8$fieldIndex,
          pageIndex = _ref8.pageIndex,
          rowIndex = _ref8.rowIndex;
      return dataLayoutPages[pageIndex].dataLayoutRows[rowIndex].dataLayoutColumns[columnIndex].fieldNames[fieldIndex];
    }

    function getIndexesFromFieldName(_ref9, fieldName) {
      var dataLayoutPages = _ref9.dataLayoutPages;
      var indexes = {};
      dataLayoutPages.some(function (_ref10, pageIndex) {
        var dataLayoutRows = _ref10.dataLayoutRows;
        return dataLayoutRows.some(function (_ref11, rowIndex) {
          var dataLayoutColumns = _ref11.dataLayoutColumns;
          return dataLayoutColumns.some(function (_ref12, columnIndex) {
            var _ref12$fieldNames = _ref12.fieldNames,
                fieldNames = _ref12$fieldNames === void 0 ? [] : _ref12$fieldNames;
            return fieldNames.some(function (name) {
              if (name === fieldName) {
                indexes = {
                  columnIndex: columnIndex,
                  pageIndex: pageIndex,
                  rowIndex: rowIndex
                };
                return true;
              }

              return false;
            });
          });
        });
      });
      return indexes;
    }

    function normalizeRule(dataRule) {
      if (Object.prototype.hasOwnProperty.call(dataRule, 'logical-operator')) {
        dataRule['logicalOperator'] = dataRule['logical-operator'];
        delete dataRule['logical-operator'];
      }

      dataRule = _objectSpread(_objectSpread({}, dataRule), {}, {
        name: {
          en_US: dataRule.name
        }
      });
      return dataRule;
    }

    function isDataLayoutEmpty(dataLayoutPages) {
      return dataLayoutPages.every(function (_ref13) {
        var dataLayoutRows = _ref13.dataLayoutRows;
        return dataLayoutRows.every(function (_ref14) {
          var dataLayoutColumns = _ref14.dataLayoutColumns;
          return dataLayoutColumns.every(function (_ref15) {
            var _ref15$fieldNames = _ref15.fieldNames,
                fieldNames = _ref15$fieldNames === void 0 ? [] : _ref15$fieldNames;
            return !fieldNames.length;
          });
        });
      });
    }

    function normalizeDataLayoutRows(dataLayoutPages) {
      return dataLayoutPages[0].dataLayoutRows.map(function (_ref16) {
        var dataLayoutColumns = _ref16.dataLayoutColumns;
        return {
          columns: dataLayoutColumns.map(function (_ref17) {
            var size = _ref17.columnSize,
                fields = _ref17.fieldNames;
            return {
              fields: fields,
              size: size
            };
          })
        };
      });
    }
    //# sourceMappingURL=dataLayoutVisitor.es.js.map
  }
});
//# sourceMappingURL=dataLayoutVisitor.es.js.map