Liferay.Loader.define("data-engine-taglib@2.5.24/data_layout_builder/js/utils/saveDataDefinition.es", ['module', 'exports', 'require', './client.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;

    var _client = require("./client.es");

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    /**
     * Normalize field
     * @param {Array} availableLanguageIds
     * @param {Object} field
     * @description some fields are translated with the language of
     * themeDisplay.getDefaultLanguageId() which is not necessarily the language of dataDefinition,
     * so we need to normalize all fields so that they receive themeDisplay.getDefaultLanguageId()
     */
    var normalizeField = function normalizeField(availableLanguageIds, field) {
      var defaultLanguageId = themeDisplay.getDefaultLanguageId();

      var toArray = function toArray(value) {
        return availableLanguageIds.reduce(function (accumulator, currentValue) {
          accumulator[currentValue] = value[currentValue] || value[defaultLanguageId] || '';
          return accumulator;
        }, {});
      };

      var toString = function toString(value) {
        return availableLanguageIds.reduce(function (accumulator, currentValue) {
          if (value[currentValue] && value[currentValue].length) {
            accumulator[currentValue] = value[currentValue];
          } else {
            accumulator[currentValue] = value[defaultLanguageId];
          }

          return accumulator;
        }, {});
      };

      var defaultValue = field.defaultValue,
          label = field.label,
          tip = field.tip;
      var _field$customProperti = field.customProperties,
          options = _field$customProperti.options,
          placeholder = _field$customProperti.placeholder,
          tooltip = _field$customProperti.tooltip;
      return _objectSpread(_objectSpread(_objectSpread(_objectSpread(_objectSpread({}, field), defaultValue && {
        defaultValue: Array.isArray(defaultValue[defaultLanguageId]) ? toString(defaultValue) : toArray(defaultValue)
      }), label && {
        label: toArray(label)
      }), tip && {
        tip: toArray(tip)
      }), {}, {
        customProperties: _objectSpread(_objectSpread(_objectSpread(_objectSpread({}, field.customProperties), options && {
          options: toString(options)
        }), placeholder && {
          placeholder: toArray(placeholder)
        }), tooltip && {
          tooltip: toArray(tooltip)
        }),
        nestedDataDefinitionFields: field.nestedDataDefinitionFields.length ? field.nestedDataDefinitionFields.map(function (nestedField) {
          return _objectSpread(_objectSpread({}, nestedField), normalizeField(availableLanguageIds, nestedField));
        }) : []
      });
    };

    var _default = function _default(_ref) {
      var dataDefinition = _ref.dataDefinition,
          dataDefinitionId = _ref.dataDefinitionId,
          dataLayout = _ref.dataLayout,
          dataLayoutId = _ref.dataLayoutId;
      var defaultLanguageId = themeDisplay.getDefaultLanguageId();

      var normalizedDataLayout = _objectSpread(_objectSpread({}, dataLayout), {}, {
        dataLayoutPages: dataLayout.dataLayoutPages.map(function (dataLayoutPage) {
          return _objectSpread(_objectSpread({}, dataLayoutPage), {}, {
            dataLayoutRows: (dataLayoutPage.dataLayoutRows || []).map(function (dataLayoutRow) {
              return _objectSpread(_objectSpread({}, dataLayoutRow), {}, {
                dataLayoutColumns: (dataLayoutRow.dataLayoutColumns || []).map(function (dataLayoutColumn) {
                  return _objectSpread(_objectSpread({}, dataLayoutColumn), {}, {
                    fieldNames: dataLayoutColumn.fieldNames || []
                  });
                })
              });
            }),
            description: _objectSpread(_objectSpread({}, dataLayout.description), {}, _defineProperty({}, defaultLanguageId, dataLayoutPage.description[defaultLanguageId] || '')),
            title: _objectSpread(_objectSpread({}, dataLayoutPage.title), {}, _defineProperty({}, defaultLanguageId, dataLayoutPage.title[defaultLanguageId] || ''))
          });
        }),
        dataRules: dataLayout.dataRules.map(function (rule) {
          delete rule.ruleEditedIndex;
          return rule;
        })
      });

      var normalizedDataDefinition = _objectSpread(_objectSpread({}, dataDefinition), {}, {
        dataDefinitionFields: dataDefinition.dataDefinitionFields.map(function (field) {
          return normalizeField(dataDefinition.availableLanguageIds, field);
        }),
        name: _objectSpread(_objectSpread({}, dataDefinition.name), {}, _defineProperty({}, defaultLanguageId, dataDefinition.name[defaultLanguageId] || ''))
      });

      var updateDefinition = function updateDefinition() {
        return (0, _client.updateItem)("/o/data-engine/v2.0/data-definitions/".concat(dataDefinitionId), normalizedDataDefinition);
      };

      if (dataLayoutId) {
        return updateDefinition().then(function () {
          return (0, _client.updateItem)("/o/data-engine/v2.0/data-layouts/".concat(dataLayoutId), normalizedDataLayout);
        });
      }

      return updateDefinition().then(function () {
        return (0, _client.addItem)("/o/data-engine/v2.0/data-definitions/".concat(dataDefinitionId, "/data-layouts"), normalizedDataLayout);
      });
    };

    exports.default = _default;
    //# sourceMappingURL=saveDataDefinition.es.js.map
  }
});
//# sourceMappingURL=saveDataDefinition.es.js.map