Liferay.Loader.define("frontend-taglib-clay@6.3.11/data_set_display/modal/Modal", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/loading-indicator', '@frontend-taglib-clay$clayui/modal', 'frontend-taglib-clay$prop-types', 'frontend-js-react-web$react', '../utilities/eventsDefinitions', '../utilities/iframes', '../utilities/index', '../utilities/modals/constants', '../utilities/modals/index'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;

    var _loadingIndicator = _interopRequireDefault(require("@frontend-taglib-clay$clayui/loading-indicator"));

    var _modal = _interopRequireWildcard(require("@frontend-taglib-clay$clayui/modal"));

    var _propTypes = _interopRequireDefault(require("frontend-taglib-clay$prop-types"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _eventsDefinitions = require("../utilities/eventsDefinitions");

    var _iframes = require("../utilities/iframes");

    var _index = require("../utilities/index");

    var _constants = require("../utilities/modals/constants");

    var _index2 = require("../utilities/modals/index");

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    function Modal(_ref) {
      var id = _ref.id,
          onCloseProp = _ref.onClose,
          status = _ref.status,
          titleProp = _ref.title,
          urlProp = _ref.url;

      var _useState = (0, _react.useState)(false),
          _useState2 = _slicedToArray(_useState, 2),
          visible = _useState2[0],
          setVisible = _useState2[1];

      var _useState3 = (0, _react.useState)(false),
          _useState4 = _slicedToArray(_useState3, 2),
          loading = _useState4[0],
          setLoading = _useState4[1];

      var _useState5 = (0, _react.useState)(null),
          _useState6 = _slicedToArray(_useState5, 2),
          onClose = _useState6[0],
          setOnClose = _useState6[1];

      var _useState7 = (0, _react.useState)(titleProp),
          _useState8 = _slicedToArray(_useState7, 2),
          title = _useState8[0],
          setTitle = _useState8[1];

      var _useState9 = (0, _react.useState)(urlProp),
          _useState10 = _slicedToArray(_useState9, 2),
          url = _useState10[0],
          setURL = _useState10[1];

      var _useState11 = (0, _react.useState)(_constants.INITIAL_MODAL_SIZE),
          _useState12 = _slicedToArray(_useState11, 2),
          size = _useState12[0],
          setSize = _useState12[1];

      var doClose = (0, _react.useCallback)(function (successNotification) {
        if (onClose) {
          onClose(successNotification);
        } else if (onCloseProp) {
          onCloseProp(successNotification);
        }

        setLoading(false);
        setVisible(false);
      }, [onClose, onCloseProp]);

      var _useModal = (0, _modal.useModal)({
        onClose: doClose
      }),
          observer = _useModal.observer,
          closeOnIframeRefresh = _useModal.onClose;

      (0, _react.useEffect)(function () {
        function handleOpenEvent(data) {
          if (id !== data.id || visible || (0, _iframes.isPageInIframe)()) {
            return;
          }

          setLoading(true);
          setVisible(true);

          if (data.url) {
            setURL(data.url);
          }

          if (data.onClose) {
            setOnClose(function () {
              return data.onClose;
            });
          }

          if (data.title) {
            setTitle(data.title);
          }

          if (!data.size) {
            setSize(_constants.INITIAL_MODAL_SIZE);
          }
        }

        function handleCloseModal(_ref2) {
          var _ref2$redirectURL = _ref2.redirectURL,
              redirectURL = _ref2$redirectURL === void 0 ? '' : _ref2$redirectURL,
              _ref2$successNotifica = _ref2.successNotification,
              successNotification = _ref2$successNotifica === void 0 ? {} : _ref2$successNotifica,
              _ref2$willIframeRefre = _ref2.willIframeRefresh,
              willIframeRefresh = _ref2$willIframeRefre === void 0 ? true : _ref2$willIframeRefre;

          if (!visible) {
            return;
          }

          if (redirectURL) {
            (0, _index.liferayNavigate)(redirectURL);
          } else if (willIframeRefresh) {
            closeOnIframeRefresh(successNotification);
          } else {
            doClose(successNotification);
          }
        }

        function handleSetLoading(data) {
          var isLoading = data.isLoading;
          setLoading(isLoading || false);
        }

        function cleanUpListeners() {
          Liferay.detach(_eventsDefinitions.OPEN_MODAL, handleOpenEvent);
          Liferay.detach(_eventsDefinitions.CLOSE_MODAL, handleCloseModal);
          Liferay.detach(_eventsDefinitions.IS_LOADING_MODAL, handleSetLoading);
          Liferay.detach('destroyPortlet', cleanUpListeners);
        }

        if (Liferay.on) {
          Liferay.on(_eventsDefinitions.OPEN_MODAL, handleOpenEvent);
          Liferay.on(_eventsDefinitions.CLOSE_MODAL, handleCloseModal);
          Liferay.on(_eventsDefinitions.IS_LOADING_MODAL, handleSetLoading);
          Liferay.on('destroyPortlet', cleanUpListeners);
        }

        return function () {
          return cleanUpListeners();
        };
      }, [id, closeOnIframeRefresh, visible, doClose]);
      (0, _react.useEffect)(function () {
        setOnClose(function () {
          return onClose;
        });
      }, [onClose]);
      return (/*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, visible && /*#__PURE__*/_react.default.createElement(_modal.default, {
          className: "clay-modal",
          observer: observer,
          size: size,
          status: status
        }, title && /*#__PURE__*/_react.default.createElement(_modal.default.Header, null, title), /*#__PURE__*/_react.default.createElement("div", {
          className: "modal-body modal-body-iframe",
          style: {
            height: (0, _index2.resolveModalHeight)(size),
            maxHeight: '100%'
          }
        }, /*#__PURE__*/_react.default.createElement("iframe", {
          src: url,
          title: title
        }), loading && /*#__PURE__*/_react.default.createElement("div", {
          className: "loader-container"
        }, /*#__PURE__*/_react.default.createElement(_loadingIndicator.default, null)))))
      );
    }

    var _default = Modal;
    exports.default = _default;
    //# sourceMappingURL=Modal.js.map
  }
});
//# sourceMappingURL=Modal.js.map