Liferay.Loader.define("frontend-taglib-clay@6.3.11/data_set_display/side_panel/SidePanel", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/button', '@frontend-taglib-clay$clayui/icon', '@frontend-taglib-clay$clayui/loading-indicator', 'frontend-taglib-clay$classnames', 'frontend-taglib-clay$prop-types', 'frontend-js-react-web$react', 'frontend-js-react-web$react-dom', '../modal/Modal', '../utilities/debounce', '../utilities/eventsDefinitions', '../utilities/iframes', '../utilities/logError', '../utilities/sidePanels', './SideMenu'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;

    var _button = _interopRequireDefault(require("@frontend-taglib-clay$clayui/button"));

    var _icon = _interopRequireDefault(require("@frontend-taglib-clay$clayui/icon"));

    var _loadingIndicator = _interopRequireDefault(require("@frontend-taglib-clay$clayui/loading-indicator"));

    var _classnames = _interopRequireDefault(require("frontend-taglib-clay$classnames"));

    var _propTypes = _interopRequireDefault(require("frontend-taglib-clay$prop-types"));

    var _react = _interopRequireDefault(require("frontend-js-react-web$react"));

    var _reactDom = _interopRequireDefault(require("frontend-js-react-web$react-dom"));

    var _Modal = _interopRequireDefault(require("../modal/Modal"));

    var _debounce = _interopRequireDefault(require("../utilities/debounce"));

    var _eventsDefinitions = require("../utilities/eventsDefinitions");

    var _iframes = require("../utilities/iframes");

    var _logError = require("../utilities/logError");

    var _sidePanels = require("../utilities/sidePanels");

    var _SideMenu = _interopRequireDefault(require("./SideMenu"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    function _classCallCheck(instance, Constructor) {
      if (!(instance instanceof Constructor)) {
        throw new TypeError("Cannot call a class as a function");
      }
    }

    function _defineProperties(target, props) {
      for (var i = 0; i < props.length; i++) {
        var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
      }
    }

    function _createClass(Constructor, protoProps, staticProps) {
      if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
    }

    function _possibleConstructorReturn(self, call) {
      if (call && (_typeof(call) === "object" || typeof call === "function")) {
        return call;
      }return _assertThisInitialized(self);
    }

    function _getPrototypeOf(o) {
      _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
        return o.__proto__ || Object.getPrototypeOf(o);
      };return _getPrototypeOf(o);
    }

    function _assertThisInitialized(self) {
      if (self === void 0) {
        throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
      }return self;
    }

    function _inherits(subClass, superClass) {
      if (typeof superClass !== "function" && superClass !== null) {
        throw new TypeError("Super expression must either be null or a function");
      }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
    }

    function _setPrototypeOf(o, p) {
      _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
        o.__proto__ = p;return o;
      };return _setPrototypeOf(o, p);
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    var SIDE_PANEL_TITLE_HEIGHT = 65;

    var SidePanel = /*#__PURE__*/function (_React$Component) {
      _inherits(SidePanel, _React$Component);

      function SidePanel(props) {
        var _this;

        _classCallCheck(this, SidePanel);

        _this = _possibleConstructorReturn(this, _getPrototypeOf(SidePanel).call(this, props));
        _this.state = {
          active: null,
          closeButtonStyle: null,
          currentURL: props.url || null,
          loading: true,
          menuCoverTopDistance: 0,
          moving: false,
          onAfterSubmit: props.onAfterSubmit || null,
          size: props.size || _this.defaultSize,
          topDistance: 0,
          visible: !!props.visible,
          wrapper: document.querySelector(_this.props.wrapperSelector) || document.querySelector('body')
        };
        _this.iframeHandlerModalId = (0, _iframes.getIframeHandlerModalId)();
        _this.handleIframeClickOnSubmit = _this.handleIframeClickOnSubmit.bind(_assertThisInitialized(_this));
        _this.handleIframeSubmit = _this.handleIframeSubmit.bind(_assertThisInitialized(_this));
        _this.handleContentLoaded = _this.handleContentLoaded.bind(_assertThisInitialized(_this));
        _this.close = _this.close.bind(_assertThisInitialized(_this));
        _this.open = _this.open.bind(_assertThisInitialized(_this));
        _this.handlePanelOpenEvent = _this.handlePanelOpenEvent.bind(_assertThisInitialized(_this));
        _this.handlePanelCloseEvent = _this.handlePanelCloseEvent.bind(_assertThisInitialized(_this));
        _this.handleKeyupEvent = _this.handleKeyupEvent.bind(_assertThisInitialized(_this));
        _this.updateTop = _this.updateTop.bind(_assertThisInitialized(_this));
        _this.debouncedUpdateTop = (0, _debounce.default)(_this.updateTop, 250);
        _this.panel = /*#__PURE__*/_react.default.createRef();
        _this.iframeRef = /*#__PURE__*/_react.default.createRef();
        return _this;
      }

      _createClass(SidePanel, [{
        key: "componentDidMount",
        value: function componentDidMount() {
          var _this2 = this;

          this._isMounted = true;

          if (this.props.topAnchorSelector) {
            window.addEventListener('resize', this.debouncedUpdateTop);
            this.updateTop();
          }

          if (this.props.containerSelector) {
            var container = document.querySelector(this.props.containerSelector);

            if (container) {
              container.classList.add('with-side-panel');
            } else {
              (0, _logError.logError)("Container: \"".concat(this.props.containerSelector, "\" not found!"));
            }
          }

          Liferay.on(_eventsDefinitions.OPEN_SIDE_PANEL, this.handlePanelOpenEvent);
          Liferay.on(_eventsDefinitions.CLOSE_SIDE_PANEL, this.handlePanelCloseEvent);
          (0, _sidePanels.exposeSidePanel)(this.props.id, function () {
            return {
              activeMenuItem: _this2.state.active,
              size: _this2.state.size,
              url: _this2.state.currentURL,
              visible: _this2.state.visible
            };
          });
        }
      }, {
        key: "handlePanelOpenEvent",
        value: function handlePanelOpenEvent(event) {
          if (event.id !== this.props.id) {
            return this.close();
          }

          this.open(event.url, event.slug);
          this.setState({
            onAfterSubmit: event.onSubmit || null,
            size: event.size || this.defaultSize
          });
        }
      }, {
        key: "handlePanelCloseEvent",
        value: function handlePanelCloseEvent(event) {
          event.preventDefault();
          return this.close();
        }
      }, {
        key: "handleKeyupEvent",
        value: function handleKeyupEvent(even) {
          var _this$iframeRef$curre;

          if (even.keyCode !== 27 || window.top.document.querySelector('.modal-content')) {
            return;
          }

          if ((_this$iframeRef$curre = this.iframeRef.current) === null || _this$iframeRef$curre === void 0 ? void 0 : _this$iframeRef$curre.contentWindow) {
            var nestedIframe = this.iframeRef.current.contentDocument.querySelector('.side-panel iframe');

            if (!nestedIframe || nestedIframe.contentDocument.location.origin === 'null') {
              this.close();
            }
          }
        }
      }, {
        key: "componentWillUnmount",
        value: function componentWillUnmount() {
          this._isMounted = false;
          window.removeEventListener('keyup', this.handleKeyupEvent);

          if (this.props.topAnchorSelector) {
            window.removeEventListener('resize', this.debouncedUpdateTop);
          }

          Liferay.detach(_eventsDefinitions.OPEN_SIDE_PANEL, this.handlePanelOpenEvent);
        }
      }, {
        key: "updateTop",
        value: function updateTop() {
          if (!this._isMounted) {
            return;
          }

          var topAnchor = document.querySelector(this.props.topAnchorSelector);

          if (topAnchor) {
            var _topAnchor$getBoundin = topAnchor.getBoundingClientRect(),
                height = _topAnchor$getBoundin.height,
                top = _topAnchor$getBoundin.top;

            this.setState({
              topDistance: top + height + 'px'
            });
          }

          var pageHeader = document.querySelector('.page-header');

          if (pageHeader) {
            var _pageHeader$getBoundi = pageHeader.getBoundingClientRect(),
                _top = _pageHeader$getBoundi.top;

            this.setState({
              menuCoverTopDistance: _top + 'px'
            });
          } else if ((0, _iframes.isPageInIframe)()) {
            this.setState({
              menuCoverTopDistance: SIDE_PANEL_TITLE_HEIGHT + 'px'
            });
          }
        }
      }, {
        key: "load",
        value: function load(url, refreshPageAfterSubmit) {
          var _this3 = this;

          if (!this._isMounted) {
            return;
          }

          this.setState({
            currentURL: url,
            loading: true,
            onAfterSubmit: refreshPageAfterSubmit ? function () {
              return window.location.reload();
            } : null
          }, function () {
            var _this3$iframeRef$curr;

            if ((_this3$iframeRef$curr = _this3.iframeRef.current) === null || _this3$iframeRef$curr === void 0 ? void 0 : _this3$iframeRef$curr.contentWindow) {
              _this3.iframeRef.current.contentWindow.location = _this3.state.currentURL;
            }
          });
        }
      }, {
        key: "open",
        value: function open() {
          var _this4 = this;

          var url = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : this.state.currentURL;
          var active = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
          this.setState({
            active: active,
            closeButtonStyle: null
          });

          if (!this.state.visible) {
            this.toggle(true).then(function () {
              _this4.load(url);
            });
          } else if (url !== this.state.currentURL) {
            this.load(url);
          }
        }
      }, {
        key: "close",
        value: function close() {
          var _this5 = this;

          this.toggle(false).then(function () {
            if (!_this5._isMounted) {
              return;
            }

            _this5.setState({
              active: null,
              closeButtonStyle: null,
              currentURL: null,
              loading: true
            });

            Liferay.fire(_eventsDefinitions.SIDE_PANEL_CLOSED, {
              id: _this5.props.id
            });
          });
        }
      }, {
        key: "toggle",
        value: function toggle() {
          var _this6 = this;

          var visible = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : !this.state.visible;

          if (visible) {
            window.addEventListener('keyup', this.handleKeyupEvent);
          } else {
            window.removeEventListener('keyup', this.handleKeyupEvent);
            window.focus();
          }

          return new Promise(function (resolve) {
            _this6.setState({
              moving: true,
              visible: visible
            });

            if (!_this6.panel.current) {
              return;
            }

            _this6.panel.current.addEventListener('transitionend', function () {
              if (_this6._isMounted) {
                _this6.setState({
                  moving: false
                }, function () {
                  return resolve(status);
                });
              }
            }, {
              once: true
            });
          });
        }
      }, {
        key: "handleIframeSubmit",
        value: function handleIframeSubmit(even) {
          if (even.id !== this.props.id) {
            return;
          }

          Liferay.detach(_eventsDefinitions.IFRAME_LOADED, this.handleIframeSubmit);

          if (this.props.onAfterSubmit) {
            this.props.onAfterSubmit();
          }
        }
      }, {
        key: "handleIframeClickOnSubmit",
        value: function handleIframeClickOnSubmit() {
          var _this7 = this;

          Liferay.on(_eventsDefinitions.IFRAME_LOADED, this.handleIframeSubmit);
          setTimeout(function () {
            Liferay.detach(_eventsDefinitions.IFRAME_LOADED, _this7.handleIframeSubmit);
          }, 3000);
        }
      }, {
        key: "handleContentLoaded",
        value: function handleContentLoaded() {
          var _this8 = this;

          Liferay.fire(_eventsDefinitions.IFRAME_LOADED, {
            id: this.props.id
          });
          this.setState({
            loading: false
          });

          try {
            var iframeDocument = this.iframeRef.current.contentDocument;
            var iframeWindow = this.iframeRef.current.contentWindow;
            iframeWindow.addEventListener('keyup', function (event) {
              return _this8.handleKeyupEvent(event);
            });

            if (iframeWindow.Liferay) {
              iframeWindow.Liferay.on('endNavigate', function () {
                _this8.handleIframeSubmit({
                  id: _this8.props.id
                });

                iframeWindow.addEventListener('keyup', function (event) {
                  return _this8.handleKeyupEvent(event);
                });
              });
            }

            var submitButton = iframeDocument.querySelector('[type="submit"]');

            if (submitButton) {
              submitButton.addEventListener('click', this.handleIframeClickOnSubmit);
            }
          } catch (error) {
            (0, _logError.logError)("Cannot access to iframe body. URL: \"".concat(this.state.currentURL, "\""));
          }
        }
      }, {
        key: "render",
        value: function render() {
          var _this9 = this,
              _this$props$items;

          var visibility = this.state.visible ? 'is-visible' : 'is-hidden';
          var loading = this.state.loading || this.state.moving && this.state.visible ? 'is-loading' : '';

          var content = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_Modal.default, {
            id: this.iframeHandlerModalId
          }), /*#__PURE__*/_react.default.createElement("div", {
            className: (0, _classnames.default)('side-panel-nav-cover navigation-bar border-bottom', visibility),
            style: {
              top: this.state.menuCoverTopDistance
            }
          }, /*#__PURE__*/_react.default.createElement("div", {
            className: (0, _classnames.default)(!(0, _iframes.isPageInIframe)() && 'container')
          }, /*#__PURE__*/_react.default.createElement("ul", {
            className: "navbar-nav"
          }, /*#__PURE__*/_react.default.createElement("li", {
            className: "nav-item"
          }, /*#__PURE__*/_react.default.createElement("button", {
            className: "btn btn-unstyled nav-link",
            onClick: function onClick() {
              return _this9.close();
            }
          }, /*#__PURE__*/_react.default.createElement(_icon.default, {
            symbol: "angle-left"
          })))))), /*#__PURE__*/_react.default.createElement("div", {
            className: (0, _classnames.default)('side-panel', "side-panel-".concat(this.state.size), visibility, loading),
            ref: this.panel,
            style: {
              top: this.state.topDistance
            }
          }, ((_this$props$items = this.props.items) === null || _this$props$items === void 0 ? void 0 : _this$props$items.length) && /*#__PURE__*/_react.default.createElement(_SideMenu.default, {
            active: this.state.active,
            items: this.props.items,
            open: this.open
          }), /*#__PURE__*/_react.default.createElement(_button.default, {
            className: (0, _classnames.default)('side-panel-close', this.state.closeButtonStyle === 'simple' && 'side-panel-close-simple', this.state.closeButtonStyle === 'menu' && 'side-panel-close-menu'),
            displayType: "monospaced",
            onClick: function onClick() {
              return _this9.close();
            }
          }, /*#__PURE__*/_react.default.createElement(_icon.default, {
            symbol: "times"
          })), /*#__PURE__*/_react.default.createElement("div", {
            className: "tab-content"
          }, /*#__PURE__*/_react.default.createElement("div", {
            className: "loader"
          }, /*#__PURE__*/_react.default.createElement(_loadingIndicator.default, null)), /*#__PURE__*/_react.default.createElement("div", {
            className: "active fade show tab-pane",
            role: "tabpanel"
          }, !(this.state.moving && this.state.visible) && /*#__PURE__*/_react.default.createElement("iframe", {
            frameBorder: "0",
            onLoad: this.handleContentLoaded,
            ref: this.iframeRef,
            src: this.state.currentURL
          })))));

          return (/*#__PURE__*/_reactDom.default.createPortal(content, this.state.wrapper)
          );
        }
      }]);

      return SidePanel;
    }(_react.default.Component);

    exports.default = SidePanel;

    _defineProperty(SidePanel, "defaultSize", 'md');

    SidePanel.defaultProps = {
      size: 'lg',
      topAnchorSelector: '.control-menu',
      wrapperSelector: '.side-panel-wrapper'
    };
    //# sourceMappingURL=SidePanel.js.map
  }
});
//# sourceMappingURL=SidePanel.js.map