Liferay.Loader.define("frontend-taglib-clay@6.3.11/data_set_display/utilities/dates", ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.formatDateObject = formatDateObject;
    exports.getDateFromDateString = getDateFromDateString;
    exports.prettifyDateObject = prettifyDateObject;
    exports.formatDateRangeObject = formatDateRangeObject;
    exports.convertObjectDateToIsoString = convertObjectDateToIsoString;

    function isNativeReflectConstruct() {
      if (typeof Reflect === "undefined" || !Reflect.construct) return false;if (Reflect.construct.sham) return false;if (typeof Proxy === "function") return true;try {
        Date.prototype.toString.call(Reflect.construct(Date, [], function () {}));return true;
      } catch (e) {
        return false;
      }
    }

    function _construct(Parent, args, Class) {
      if (isNativeReflectConstruct()) {
        _construct = Reflect.construct;
      } else {
        _construct = function _construct(Parent, args, Class) {
          var a = [null];a.push.apply(a, args);var Constructor = Function.bind.apply(Parent, a);var instance = new Constructor();if (Class) _setPrototypeOf(instance, Class.prototype);return instance;
        };
      }return _construct.apply(null, arguments);
    }

    function _setPrototypeOf(o, p) {
      _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
        o.__proto__ = p;return o;
      };return _setPrototypeOf(o, p);
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */
    function formatDateObject(dateObject) {
      return "".concat(dateObject.year, "-").concat(('0' + dateObject.month).slice(-2), "-").concat(('0' + dateObject.day).slice(-2));
    }

    function getDateFromDateString(dateString) {
      var _dateString$split = dateString.split('-'),
          _dateString$split2 = _slicedToArray(_dateString$split, 3),
          year = _dateString$split2[0],
          month = _dateString$split2[1],
          day = _dateString$split2[2];

      return {
        day: Number(day),
        month: Number(month),
        year: Number(year)
      };
    }

    function prettifyDateObject(dateObject) {
      var date = new Date(dateObject.year, dateObject.month - 1, dateObject.day);
      return date.toLocaleDateString();
    }

    function formatDateRangeObject(dateRangeObject) {
      if (dateRangeObject.from && dateRangeObject.to) {
        return "".concat(prettifyDateObject(dateRangeObject.from), " - ").concat(prettifyDateObject(dateRangeObject.to));
      }

      if (dateRangeObject.from) {
        return "".concat(Liferay.Language.get('from'), " ").concat(prettifyDateObject(dateRangeObject.from));
      }

      if (dateRangeObject.to) {
        return "".concat(Liferay.Language.get('to'), " ").concat(prettifyDateObject(dateRangeObject.to));
      }
    }

    function convertObjectDateToIsoString(objDate, direction) {
      var time = direction === 'from' ? [0, 0, 0, 0] : [23, 59, 59, 999];

      var date = _construct(Date, [objDate.year, objDate.month - 1, objDate.day].concat(time));

      return date.toISOString();
    }
    //# sourceMappingURL=dates.js.map
  }
});
//# sourceMappingURL=dates.js.map