Liferay.Loader.define("frontend-taglib-clay@6.3.11/data_set_display/utilities/index", ['module', 'exports', 'require', 'frontend-js-web', './odata'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.delay = delay;
    exports.getAcceptLanguageHeaderParam = getAcceptLanguageHeaderParam;
    exports.getData = getData;
    exports.getSchemaString = getSchemaString;
    exports.liferayNavigate = liferayNavigate;
    exports.isValuesArrayChanged = isValuesArrayChanged;
    exports.getValueFromItem = getValueFromItem;
    exports.executeAsyncAction = executeAsyncAction;
    exports.formatActionURL = formatActionURL;
    exports.getRandomId = getRandomId;
    exports.createSortingString = createSortingString;
    exports.getFiltersString = getFiltersString;
    exports.loadData = loadData;

    var _frontendJsWeb = require("frontend-js-web");

    var _odata = _interopRequireDefault(require("./odata"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */
    function delay(duration) {
      return new Promise(function (resolve) {
        setTimeout(function () {
          return resolve();
        }, duration);
      });
    }

    function getAcceptLanguageHeaderParam() {
      var _navigator$language;

      var browserLang = (_navigator$language = navigator.language) !== null && _navigator$language !== void 0 ? _navigator$language : navigator.userLanguage;
      var themeLang = Liferay.ThemeDisplay.getLanguageId().replace('_', '-');
      return browserLang === themeLang ? browserLang : "".concat(browserLang, ", ").concat(themeLang, ";q=0.8");
    }

    function getData(apiURL, query) {
      var url = new URL(apiURL);

      if (query) {
        url.searchParams.append('search', query);
      }

      return (0, _frontendJsWeb.fetch)(url, {
        method: 'GET'
      }).then(function (data) {
        return data.json();
      });
    }

    function getSchemaString(object, path) {
      if (!Array.isArray(path)) {
        return object[path];
      } else {
        return path.reduce(function (acc, path) {
          return acc[path];
        }, object);
      }
    }

    function liferayNavigate(url) {
      if (Liferay.SPA) {
        Liferay.SPA.app.navigate(url);
      } else {
        window.location.href = url;
      }
    }

    function isValuesArrayChanged() {
      var prevValue = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
      var newValue = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];

      if (prevValue.length !== newValue.length) {
        return true;
      }

      var prevValues = prevValue.map(function (el) {
        return el.value || el;
      }).sort();
      var newValues = newValue.map(function (el) {
        return el.value || el;
      }).sort();
      var changed = false;
      prevValues.forEach(function (element, i) {
        if (element !== newValues[i]) {
          changed = true;
        }
      });
      return changed;
    }

    function getValueFromItem(item, fieldName) {
      if (!fieldName) {
        return null;
      }

      if (Array.isArray(fieldName)) {
        return fieldName.reduce(function (acc, key) {
          if (key === 'LANG') {
            return acc[Liferay.ThemeDisplay.getLanguageId()] || acc[Liferay.ThemeDisplay.getDefaultLanguageId()];
          }

          return acc[key];
        }, item);
      }

      return item[fieldName];
    }

    function executeAsyncAction(url) {
      var method = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'GET';
      return (0, _frontendJsWeb.fetch)(url, {
        headers: {
          Accept: 'application/json',
          'Accept-Language': getAcceptLanguageHeaderParam(),
          'Content-Type': 'application/json'
        },
        method: method
      });
    }

    function formatActionURL(url, item) {
      var replacedURL = url.replace(new RegExp('{(.*?)}', 'mg'), function (matched) {
        return getValueFromItem(item, matched.substring(1, matched.length - 1).split('.'));
      });
      return replacedURL.replace(new RegExp('(%7B.*?%7D)', 'mg'), function (matched) {
        return getValueFromItem(item, matched.substring(3, matched.length - 3).split('.'));
      });
    }

    function getRandomId() {
      return Math.random().toString(36).substr(2, 9);
    }

    function createSortingString(values) {
      if (!values.length) {
        return null;
      }

      return values.map(function (value) {
        return "".concat(Array.isArray(value.fieldName) ? value.fieldName[0] : value.fieldName, ":").concat(value.direction);
      }).join(',');
    }

    function getFiltersString(odataFiltersStrings, providedFilters) {
      var filtersString = '';

      if (providedFilters) {
        filtersString += providedFilters;
      }

      if (providedFilters && odataFiltersStrings.length) {
        filtersString += ' and ';
      }

      if (odataFiltersStrings.length) {
        filtersString += (0, _odata.default)(odataFiltersStrings);
      }

      return filtersString;
    }

    function loadData(apiURL, currentURL, odataFiltersStrings, searchParam, delta) {
      var page = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : 1;
      var sorting = arguments.length > 6 && arguments[6] !== undefined ? arguments[6] : [];
      var url = new URL(apiURL, themeDisplay.getPortalURL());
      var providedFilters = url.searchParams.get('filter');
      url.searchParams.delete('filter');
      url.searchParams.append('currentURL', currentURL);

      if (providedFilters || odataFiltersStrings.length) {
        url.searchParams.append('filter', getFiltersString(odataFiltersStrings, providedFilters));
      }

      url.searchParams.append('page', page);
      url.searchParams.append('pageSize', delta);

      if (searchParam) {
        url.searchParams.append('search', searchParam);
      }

      if (sorting.length) {
        url.searchParams.append('sort', sorting.map(function (item) {
          return "".concat(item.key, ":").concat(item.direction);
        }).join(','));
      }

      return executeAsyncAction(url, 'GET').then(function (response) {
        return response.json();
      });
    }
    //# sourceMappingURL=index.js.map
  }
});
//# sourceMappingURL=index.js.map