Liferay.Loader.define("frontend-taglib-clay@6.3.11/data_set_display/views/index", ['module', 'exports', 'require', './cards/Cards', './emails_list/EmailsList', './list/List', './selectable_table/SelectableTable', './table/Table', './timeline/Timeline'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.getViewContentRenderer = getViewContentRenderer;

    var _Cards = _interopRequireDefault(require("./cards/Cards"));

    var _EmailsList = _interopRequireDefault(require("./emails_list/EmailsList"));

    var _List = _interopRequireDefault(require("./list/List"));

    var _SelectableTable = _interopRequireDefault(require("./selectable_table/SelectableTable"));

    var _Table = _interopRequireDefault(require("./table/Table"));

    var _Timeline = _interopRequireDefault(require("./timeline/Timeline"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */
    var VIEWS = {
      cards: _Cards.default,
      emailsList: _EmailsList.default,
      list: _List.default,
      selectableTable: _SelectableTable.default,
      table: _Table.default,
      timeline: _Timeline.default
    };

    function getViewContentRenderer(contentRenderer) {
      var view = VIEWS[contentRenderer];
      return view ? Promise.resolve(view) : Promise.reject("No content renderer found with the ID: \"".concat(contentRenderer, "\""));
    }
    //# sourceMappingURL=index.js.map
  }
});
//# sourceMappingURL=index.js.map