Liferay.Loader.define("frontend-taglib-clay@6.3.11/data_set_display/views/table/Table", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/table', 'frontend-taglib-clay$classnames', 'frontend-taglib-clay$prop-types', 'frontend-js-react-web$react', '../../DataSetDisplayContext', '../../data_renderers/ActionsDropdownRenderer', '../../data_renderers/CheckboxRenderer', '../../data_renderers/CommentRenderer', '../../data_renderers/RadioRenderer', '../../data_renderers/index', '../../utilities/index', '../ViewsContext', './TableHeadRow'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = exports.getVisibleFields = void 0;

    var _table = _interopRequireDefault(require("@frontend-taglib-clay$clayui/table"));

    var _classnames = _interopRequireDefault(require("frontend-taglib-clay$classnames"));

    var _propTypes = _interopRequireDefault(require("frontend-taglib-clay$prop-types"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _DataSetDisplayContext = _interopRequireDefault(require("../../DataSetDisplayContext"));

    var _ActionsDropdownRenderer = _interopRequireDefault(require("../../data_renderers/ActionsDropdownRenderer"));

    var _CheckboxRenderer = _interopRequireDefault(require("../../data_renderers/CheckboxRenderer"));

    var _CommentRenderer = _interopRequireDefault(require("../../data_renderers/CommentRenderer"));

    var _RadioRenderer = _interopRequireDefault(require("../../data_renderers/RadioRenderer"));

    var _index = require("../../data_renderers/index");

    var _index2 = require("../../utilities/index");

    var _ViewsContext = _interopRequireDefault(require("../ViewsContext"));

    var _TableHeadRow = _interopRequireDefault(require("./TableHeadRow"));

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    function CustomTableCell(_ref) {
      var actions = _ref.actions,
          comment = _ref.comment,
          itemData = _ref.itemData,
          itemId = _ref.itemId,
          options = _ref.options,
          value = _ref.value,
          view = _ref.view;

      var _useState = (0, _react.useState)(_objectSpread(_objectSpread({}, view), {}, {
        Component: view.contentRendererModuleURL ? null : (0, _index.getDataRendererById)(view.contentRenderer)
      })),
          _useState2 = _slicedToArray(_useState, 2),
          currentView = _useState2[0],
          updateCurrentView = _useState2[1];

      var _useState3 = (0, _react.useState)(false),
          _useState4 = _slicedToArray(_useState3, 2),
          loading = _useState4[0],
          setLoading = _useState4[1];

      (0, _react.useEffect)(function () {
        if (loading) {
          return;
        }

        if (currentView.contentRendererModuleURL) {
          setLoading(true);
          (0, _index.getDataRendererByURL)(currentView.contentRendererModuleURL).then(function (Component) {
            updateCurrentView(_objectSpread(_objectSpread({}, currentView), {}, {
              Component: Component
            }));
            setLoading(false);
          });
        } // eslint-disable-next-line react-hooks/exhaustive-deps
      }, [currentView]);
      return (/*#__PURE__*/_react.default.createElement(_table.default.Cell, null, currentView.Component && !loading ? /*#__PURE__*/_react.default.createElement(currentView.Component, {
          actions: actions,
          itemData: itemData,
          itemId: itemId,
          options: options,
          value: value
        }) : /*#__PURE__*/_react.default.createElement("span", {
          "aria-hidden": "true",
          className: "loading-animation loading-animation-sm"
        }), comment && /*#__PURE__*/_react.default.createElement(_CommentRenderer.default, null, comment))
      );
    }

    function getItemFields(item, fields, itemId, itemsActions) {
      return fields.map(function (field, i) {
        var actionDropdownItems = item.actionDropdownItems,
            comments = item.comments;
        var rawValue = (0, _index2.getValueFromItem)(item, field.fieldName);
        var formattedValue = field.mapData ? field.mapData(rawValue) : rawValue;
        var comment = comments ? comments[field.fieldName] : null;
        return (/*#__PURE__*/_react.default.createElement(CustomTableCell, {
            actions: itemsActions || actionDropdownItems,
            comment: comment,
            itemData: item,
            itemId: itemId,
            key: field.fieldName || i,
            options: field,
            value: formattedValue,
            view: {
              contentRenderer: field.contentRenderer,
              contentRendererModuleURL: field.contentRendererModuleURL
            }
          })
        );
      });
    }

    var getVisibleFields = function getVisibleFields(fields, visibleFieldNames) {
      var visibleFields = fields.filter(function (_ref2) {
        var fieldName = _ref2.fieldName;
        return visibleFieldNames[fieldName];
      });
      return visibleFields.length ? visibleFields : fields;
    };

    exports.getVisibleFields = getVisibleFields;

    function Table(_ref3) {
      var items = _ref3.items,
          itemsActions = _ref3.itemsActions,
          schema = _ref3.schema,
          style = _ref3.style;

      var _useContext = (0, _react.useContext)(_DataSetDisplayContext.default),
          highlightedItemsValue = _useContext.highlightedItemsValue,
          nestedItemsKey = _useContext.nestedItemsKey,
          nestedItemsReferenceKey = _useContext.nestedItemsReferenceKey,
          selectItems = _useContext.selectItems,
          selectable = _useContext.selectable,
          selectedItemsKey = _useContext.selectedItemsKey,
          selectedItemsValue = _useContext.selectedItemsValue,
          selectionType = _useContext.selectionType,
          sorting = _useContext.sorting,
          updateSorting = _useContext.updateSorting;

      var _useContext2 = (0, _react.useContext)(_ViewsContext.default),
          _useContext3 = _slicedToArray(_useContext2, 1),
          visibleFieldNames = _useContext3[0].visibleFieldNames;

      var visibleFields = getVisibleFields(schema.fields, visibleFieldNames);
      var showActionItems = Boolean((itemsActions === null || itemsActions === void 0 ? void 0 : itemsActions.length) || items.find(function (item) {
        return item.actions || item.actionDropdownItems;
      }));
      var SelectionComponent = selectionType === 'multiple' ? _CheckboxRenderer.default : _RadioRenderer.default;
      return (/*#__PURE__*/_react.default.createElement("div", {
          className: "table-style-".concat(style)
        }, /*#__PURE__*/_react.default.createElement(_table.default, {
          borderless: true,
          hover: false,
          responsive: true
        }, /*#__PURE__*/_react.default.createElement(_TableHeadRow.default, {
          items: items,
          schema: schema,
          selectItems: selectItems,
          selectable: selectable,
          selectedItemsKey: selectedItemsKey,
          selectedItemsValue: selectedItemsValue,
          selectionType: selectionType,
          sorting: sorting,
          updateSorting: updateSorting,
          visibleFields: visibleFields
        }), /*#__PURE__*/_react.default.createElement(_table.default.Body, null, items.map(function (item, i) {
          var itemId = item[selectedItemsKey] || i;
          var nestedItems = nestedItemsReferenceKey && item[nestedItemsReferenceKey];
          return (/*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
              key: itemId
            }, /*#__PURE__*/_react.default.createElement(_table.default.Row, {
              className: (0, _classnames.default)(highlightedItemsValue.includes(itemId) && 'active')
            }, selectable && /*#__PURE__*/_react.default.createElement(_table.default.Cell, {
              className: "data-set-item-selector-wrapper",
              rowSpan: 1 + ((nestedItems === null || nestedItems === void 0 ? void 0 : nestedItems.length) || 0)
            }, /*#__PURE__*/_react.default.createElement(SelectionComponent, {
              checked: !!selectedItemsValue.find(function (element) {
                return String(element) === String(itemId);
              }),
              onChange: function onChange() {
                return selectItems(itemId);
              },
              value: itemId
            })), getItemFields(item, visibleFields, itemId, itemsActions), /*#__PURE__*/_react.default.createElement(_table.default.Cell, {
              className: "data-set-item-actions-wrapper"
            }, (showActionItems || item.actions) && /*#__PURE__*/_react.default.createElement(_ActionsDropdownRenderer.default, {
              actions: itemsActions || item.actions || item.actionDropdownItems,
              itemData: item,
              itemId: itemId
            }))), (nestedItems === null || nestedItems === void 0 ? void 0 : nestedItems.length) ? nestedItems.map(function (nestedItem, i) {
              return (/*#__PURE__*/_react.default.createElement(_table.default.Row, {
                  className: (0, _classnames.default)('data-set-sub-item', highlightedItemsValue.includes(nestedItem[nestedItemsKey]) && 'active', i === nestedItems.length - 1 && 'last-of-group'),
                  key: nestedItem[nestedItemsKey]
                }, getItemFields(nestedItem, schema.fields, nestedItem[nestedItemsKey], itemsActions), showActionItems ? /*#__PURE__*/_react.default.createElement(_table.default.Cell, null) : null)
              );
            }) : null)
          );
        }))))
      );
    }

    Table.defaultProps = {
      items: []
    };
    var _default = Table;
    exports.default = _default;
    //# sourceMappingURL=Table.js.map
  }
});
//# sourceMappingURL=Table.js.map