Liferay.Loader.define("ratings-taglib@2.1.11/js/components/RatingsStars", ['module', 'exports', 'require', 'frontend-js-react-web', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', '../RATINGS_TYPES', '../utils/lang', './RatingsSelectStars', './RatingsStackedStars'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;

    var _frontendJsReactWeb = require("frontend-js-react-web");

    var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

    var _react = require("frontend-js-react-web$react");

    var _RATINGS_TYPES = _interopRequireDefault(require("../RATINGS_TYPES"));

    var _lang = _interopRequireDefault(require("../utils/lang"));

    var _RatingsSelectStars = _interopRequireDefault(require("./RatingsSelectStars"));

    var _RatingsStackedStars = _interopRequireDefault(require("./RatingsStackedStars"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    var SCORE_UNVOTE = -1;

    var RatingsStars = function RatingsStars(_ref) {
      var _RatingsStarsTypes;

      var _ref$disabled = _ref.disabled,
          disabled = _ref$disabled === void 0 ? true : _ref$disabled,
          _ref$initialAverageSc = _ref.initialAverageScore,
          initialAverageScore = _ref$initialAverageSc === void 0 ? 0 : _ref$initialAverageSc,
          _ref$initialTotalEntr = _ref.initialTotalEntries,
          initialTotalEntries = _ref$initialTotalEntr === void 0 ? 0 : _ref$initialTotalEntr,
          inititalTitle = _ref.inititalTitle,
          numberOfStars = _ref.numberOfStars,
          randomNamespace = _ref.randomNamespace,
          sendVoteRequest = _ref.sendVoteRequest,
          type = _ref.type,
          userScore = _ref.userScore;
      var starScores = Array.from(Array(numberOfStars)).map(function (_, index) {
        var number = index + 1;
        return {
          label: number,
          value: number / numberOfStars
        };
      });
      var getLabelScore = (0, _react.useCallback)(function (score) {
        var starScore = starScores.find(function (_ref2) {
          var value = _ref2.value;
          return score === value;
        });
        return starScore && starScore.label || 0;
      }, [starScores]);
      var formatAverageScore = (0, _react.useCallback)(function (averageScore) {
        return Number((averageScore * numberOfStars).toFixed(1));
      }, [numberOfStars]);

      var _useState = (0, _react.useState)(getLabelScore(userScore)),
          _useState2 = _slicedToArray(_useState, 2),
          score = _useState2[0],
          setScore = _useState2[1];

      var _useState3 = (0, _react.useState)(formatAverageScore(initialAverageScore)),
          _useState4 = _slicedToArray(_useState3, 2),
          averageScore = _useState4[0],
          setAverageScore = _useState4[1];

      var _useState5 = (0, _react.useState)(initialTotalEntries),
          _useState6 = _slicedToArray(_useState5, 2),
          totalEntries = _useState6[0],
          setTotalEntries = _useState6[1];

      var isMounted = (0, _frontendJsReactWeb.useIsMounted)();
      var handleSendVoteRequest = (0, _react.useCallback)(function (score) {
        sendVoteRequest(score).then(function () {
          var _ref3 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
              averageScore = _ref3.averageScore,
              score = _ref3.score,
              totalEntries = _ref3.totalEntries;

          if (isMounted() && averageScore !== undefined && score !== undefined && totalEntries !== undefined) {
            setTotalEntries(totalEntries);
            setAverageScore(formatAverageScore(averageScore));
            setScore(getLabelScore(score));
          }
        });
      }, [formatAverageScore, getLabelScore, isMounted, sendVoteRequest]);

      var getTitle = (0, _react.useCallback)(function () {
        if (inititalTitle !== undefined) {
          return inititalTitle;
        } else if (score <= 0) {
          return Liferay.Language.get('vote');
        } else if (score > 0) {
          var title = score === 1 ? Liferay.Language.get('you-have-rated-this-x-star-out-of-x') : Liferay.Language.get('you-have-rated-this-x-stars-out-of-x');
          return _lang.default.sub(title, [score, numberOfStars]);
        }

        return '';
      }, [inititalTitle, score, numberOfStars]);

      var RatingsStarsTypes = (_RatingsStarsTypes = {}, _defineProperty(_RatingsStarsTypes, _RATINGS_TYPES.default.STACKED_STARS, _RatingsStackedStars.default), _defineProperty(_RatingsStarsTypes, _RATINGS_TYPES.default.STARS, _RatingsSelectStars.default), _RatingsStarsTypes);
      var RatingsStarsUI = RatingsStarsTypes[type];
      return RatingsStarsUI({
        averageScore: averageScore,
        disabled: disabled,
        getSrAverageMessage: function getSrAverageMessage() {
          var srAverageMessage = averageScore === 1 ? Liferay.Language.get('the-average-rating-is-x-star-out-of-x') : Liferay.Language.get('the-average-rating-is-x-stars-out-of-x');
          return _lang.default.sub(srAverageMessage, [averageScore, numberOfStars]);
        },
        getTitle: getTitle,
        numberOfStars: numberOfStars,
        onVote: function handleVote(index) {
          var value, label;
          var starScore = starScores[index];

          if (starScore) {
            value = starScore.value;
            label = starScore.label;
          } else {
            value = SCORE_UNVOTE;
            label = getLabelScore(SCORE_UNVOTE);
          }

          setScore(label);
          handleSendVoteRequest(value);
        },
        randomNamespace: randomNamespace,
        score: score,
        starScores: starScores,
        totalEntries: totalEntries
      });
    };

    RatingsStars.propTypes = {
      disabled: _propTypes.default.bool,
      initialAverageScore: _propTypes.default.number,
      initialTotalEntries: _propTypes.default.number,
      inititalTitle: _propTypes.default.string,
      numberOfStars: _propTypes.default.number.isRequired,
      positiveVotes: _propTypes.default.number,
      randomNamespace: _propTypes.default.string.isRequired,
      sendVoteRequest: _propTypes.default.func.isRequired,
      userScore: _propTypes.default.number
    };
    var _default = RatingsStars;
    exports.default = _default;
    //# sourceMappingURL=RatingsStars.js.map
  }
});
//# sourceMappingURL=RatingsStars.js.map