Liferay.Loader.define("ratings-taglib@2.1.11/js/components/RatingsThumbs", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/button', '@frontend-taglib-clay$clayui/icon', '@frontend-taglib-clay$clayui/tooltip', 'frontend-js-react-web$classnames', 'frontend-js-react-web', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', './AnimatedCounter'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = _default;

    var _button = _interopRequireDefault(require("@frontend-taglib-clay$clayui/button"));

    var _icon = _interopRequireDefault(require("@frontend-taglib-clay$clayui/icon"));

    var _tooltip = require("@frontend-taglib-clay$clayui/tooltip");

    var _classnames = _interopRequireDefault(require("frontend-js-react-web$classnames"));

    var _frontendJsReactWeb = require("frontend-js-react-web");

    var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _AnimatedCounter = _interopRequireDefault(require("./AnimatedCounter"));

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    var PRESSED_DOWN = 'DOWN';
    var PRESSED_UP = 'UP';
    var SCORE_DOWN = 0;
    var SCORE_UNVOTE = -1;
    var SCORE_UP = 1;
    var VOTE_DOWN = 'VOTE_DOWN';
    var VOTE_UP = 'VOTE_UP';
    var UPDATE_VOTES = 'VOTES_UPDATE';

    function reducer(state, action) {
      switch (action.type) {
        case VOTE_UP:
          return {
            negativeVotes: state.pressed !== PRESSED_DOWN ? state.negativeVotes : state.negativeVotes - 1,
            positiveVotes: state.pressed === PRESSED_UP ? state.positiveVotes - 1 : state.positiveVotes + 1,
            pressed: state.pressed !== PRESSED_UP ? PRESSED_UP : null
          };

        case VOTE_DOWN:
          return {
            negativeVotes: state.pressed !== PRESSED_DOWN ? state.negativeVotes + 1 : state.negativeVotes - 1,
            positiveVotes: state.pressed !== PRESSED_UP ? state.positiveVotes : state.positiveVotes - 1,
            pressed: state.pressed !== PRESSED_DOWN ? PRESSED_DOWN : null
          };

        case UPDATE_VOTES:
          return _objectSpread(_objectSpread({}, state), {}, {
            negativeVotes: action.payload.negativeVotes,
            positiveVotes: action.payload.positiveVotes
          });

        default:
          return state;
      }
    }

    var RatingsThumbs = function RatingsThumbs(_ref) {
      var _ref$disabled = _ref.disabled,
          disabled = _ref$disabled === void 0 ? true : _ref$disabled,
          _ref$initialNegativeV = _ref.initialNegativeVotes,
          initialNegativeVotes = _ref$initialNegativeV === void 0 ? 0 : _ref$initialNegativeV,
          _ref$initialPositiveV = _ref.initialPositiveVotes,
          initialPositiveVotes = _ref$initialPositiveV === void 0 ? 0 : _ref$initialPositiveV,
          inititalTitle = _ref.inititalTitle,
          sendVoteRequest = _ref.sendVoteRequest,
          _ref$thumbDown = _ref.thumbDown,
          thumbDown = _ref$thumbDown === void 0 ? false : _ref$thumbDown,
          _ref$thumbUp = _ref.thumbUp,
          thumbUp = _ref$thumbUp === void 0 ? false : _ref$thumbUp;

      var _useReducer = (0, _react.useReducer)(reducer, {
        negativeVotes: initialNegativeVotes,
        positiveVotes: initialPositiveVotes,
        pressed: thumbDown ? PRESSED_DOWN : thumbUp ? PRESSED_UP : null
      }),
          _useReducer2 = _slicedToArray(_useReducer, 2),
          state = _useReducer2[0],
          dispatch = _useReducer2[1];

      var negativeVotes = state.negativeVotes,
          positiveVotes = state.positiveVotes,
          pressed = state.pressed;

      var _useState = (0, _react.useState)(false),
          _useState2 = _slicedToArray(_useState, 2),
          animatedButtonUp = _useState2[0],
          setAnimatedButtonUp = _useState2[1];

      var _useState3 = (0, _react.useState)(false),
          _useState4 = _slicedToArray(_useState3, 2),
          animatedButtonDown = _useState4[0],
          setAnimatedButtonDown = _useState4[1];

      var isMounted = (0, _frontendJsReactWeb.useIsMounted)();

      var handleSendVoteRequest = (0, _react.useCallback)(function (score) {
        sendVoteRequest(score).then(function () {
          var _ref2 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
              totalEntries = _ref2.totalEntries,
              totalScore = _ref2.totalScore;

          if (isMounted() && totalEntries && totalScore) {
            var _positiveVotes = Math.round(totalScore);

            dispatch({
              payload: {
                negativeVotes: totalEntries - _positiveVotes,
                positiveVotes: _positiveVotes
              },
              type: UPDATE_VOTES
            });
          }
        });
      }, [isMounted, sendVoteRequest]);
      var voteUp = (0, _react.useCallback)(function () {
        if (pressed !== PRESSED_UP) {
          setAnimatedButtonUp(true);
        }

        dispatch({
          type: VOTE_UP
        });
        var score = pressed !== PRESSED_UP ? SCORE_UP : SCORE_UNVOTE;
        handleSendVoteRequest(score);
      }, [handleSendVoteRequest, pressed]);
      var voteDown = (0, _react.useCallback)(function () {
        if (pressed !== PRESSED_DOWN) {
          setAnimatedButtonDown(true);
        }

        dispatch({
          type: VOTE_DOWN
        });
        var score = pressed !== PRESSED_DOWN ? SCORE_DOWN : SCORE_UNVOTE;
        handleSendVoteRequest(score);
      }, [handleSendVoteRequest, pressed]);
      var getTitleThumbsUp = (0, _react.useCallback)(function () {
        if (inititalTitle !== undefined) {
          return inititalTitle;
        }

        if (pressed === PRESSED_UP) {
          return Liferay.Language.get('you-have-rated-this-as-good');
        } else {
          return Liferay.Language.get('rate-this-as-good');
        }
      }, [inititalTitle, pressed]);
      var getTitleThumbsDown = (0, _react.useCallback)(function () {
        if (inititalTitle !== undefined) {
          return inititalTitle;
        }

        if (pressed === PRESSED_DOWN) {
          return Liferay.Language.get('you-have-rated-this-as-bad');
        } else {
          return Liferay.Language.get('rate-this-as-bad');
        }
      }, [inititalTitle, pressed]);
      return (/*#__PURE__*/_react.default.createElement(_tooltip.ClayTooltipProvider, null, /*#__PURE__*/_react.default.createElement("div", {
          className: "ratings-thumbs"
        }, /*#__PURE__*/_react.default.createElement(_button.default, {
          "aria-pressed": pressed === PRESSED_UP,
          borderless: true,
          className: (0, _classnames.default)('btn-thumbs-up', {
            'btn-animated': animatedButtonUp
          }),
          disabled: disabled,
          displayType: "secondary",
          onClick: voteUp,
          small: true,
          title: getTitleThumbsUp(),
          value: positiveVotes
        }, /*#__PURE__*/_react.default.createElement("span", {
          className: "c-inner",
          tabIndex: "-1"
        }, /*#__PURE__*/_react.default.createElement("span", {
          className: "inline-item inline-item-before"
        }, /*#__PURE__*/_react.default.createElement("span", {
          className: "off"
        }, /*#__PURE__*/_react.default.createElement(_icon.default, {
          symbol: "thumbs-up"
        })), /*#__PURE__*/_react.default.createElement("span", {
          className: "on",
          onAnimationEnd: function handleAnimationEndUp() {
            setAnimatedButtonUp(false);
          }
        }, /*#__PURE__*/_react.default.createElement(_icon.default, {
          symbol: "thumbs-up-full"
        }))), /*#__PURE__*/_react.default.createElement("span", {
          className: "inline-item"
        }, /*#__PURE__*/_react.default.createElement(_AnimatedCounter.default, {
          counter: positiveVotes
        })))), /*#__PURE__*/_react.default.createElement(_button.default, {
          "aria-pressed": pressed === PRESSED_DOWN,
          borderless: true,
          className: (0, _classnames.default)('btn-thumbs-down', {
            'btn-animated': animatedButtonDown
          }),
          disabled: disabled,
          displayType: "secondary",
          onClick: voteDown,
          small: true,
          title: getTitleThumbsDown(),
          value: negativeVotes
        }, /*#__PURE__*/_react.default.createElement("span", {
          className: "c-inner",
          tabIndex: "-1"
        }, /*#__PURE__*/_react.default.createElement("span", {
          className: "inline-item inline-item-before"
        }, /*#__PURE__*/_react.default.createElement("span", {
          className: "off"
        }, /*#__PURE__*/_react.default.createElement(_icon.default, {
          symbol: "thumbs-down"
        })), /*#__PURE__*/_react.default.createElement("span", {
          className: "on",
          onAnimationEnd: function handleAnimationEndDown() {
            setAnimatedButtonDown(false);
          }
        }, /*#__PURE__*/_react.default.createElement(_icon.default, {
          symbol: "thumbs-down-full"
        }))), /*#__PURE__*/_react.default.createElement("span", {
          className: "inline-item"
        }, /*#__PURE__*/_react.default.createElement(_AnimatedCounter.default, {
          counter: negativeVotes
        }))))))
      );
    };

    function _default(props) {
      return (/*#__PURE__*/_react.default.createElement(RatingsThumbs, props)
      );
    }
    //# sourceMappingURL=RatingsThumbs.js.map
  }
});
//# sourceMappingURL=RatingsThumbs.js.map