/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */
'use strict';

Liferay.Loader.define("commerce-frontend-taglib@10.1.4/user_utils/UserListItem.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal-component', 'frontend-js-metal-web$metal-soy', './UserListItem.soy', '../autocomplete_item/AutocompleteItem.es', '../add_to_tick_item/AddToTickItem.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = exports.UserListItem = void 0;

    var _metalComponent = _interopRequireDefault(require("frontend-js-metal-web$metal-component"));

    var _metalSoy = _interopRequireWildcard(require("frontend-js-metal-web$metal-soy"));

    var _UserListItem = _interopRequireDefault(require("./UserListItem.soy"));

    require("../autocomplete_item/AutocompleteItem.es");

    require("../add_to_tick_item/AddToTickItem.es");

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    function _classCallCheck(instance, Constructor) {
      if (!(instance instanceof Constructor)) {
        throw new TypeError("Cannot call a class as a function");
      }
    }

    function _defineProperties(target, props) {
      for (var i = 0; i < props.length; i++) {
        var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
      }
    }

    function _createClass(Constructor, protoProps, staticProps) {
      if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
    }

    function _possibleConstructorReturn(self, call) {
      if (call && (_typeof(call) === "object" || typeof call === "function")) {
        return call;
      }return _assertThisInitialized(self);
    }

    function _assertThisInitialized(self) {
      if (self === void 0) {
        throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
      }return self;
    }

    function _getPrototypeOf(o) {
      _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
        return o.__proto__ || Object.getPrototypeOf(o);
      };return _getPrototypeOf(o);
    }

    function _inherits(subClass, superClass) {
      if (typeof superClass !== "function" && superClass !== null) {
        throw new TypeError("Super expression must either be null or a function");
      }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
    }

    function _setPrototypeOf(o, p) {
      _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
        o.__proto__ = p;return o;
      };return _setPrototypeOf(o, p);
    }

    var EMAIL_REGEX = /^(([^<>()[\]\\.,;:\s@"]+(\.[^<>()[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;

    var UserListItem = /*#__PURE__*/function (_Component) {
      _inherits(UserListItem, _Component);

      function UserListItem() {
        _classCallCheck(this, UserListItem);

        return _possibleConstructorReturn(this, _getPrototypeOf(UserListItem).apply(this, arguments));
      }

      _createClass(UserListItem, [{
        key: "attached",
        value: function attached() {
          return this._updateStatus();
        }
      }, {
        key: "willUpdate",
        value: function willUpdate() {
          return this._updateStatus();
        }
      }, {
        key: "syncAddedUsers",
        value: function syncAddedUsers() {
          var _this = this;

          this._invited = this.addedUsers.reduce(function (hasBeenInvited, user) {
            return hasBeenInvited || user.email === _this.email;
          }, false);
        }
      }, {
        key: "_updateStatus",
        value: function _updateStatus() {
          if (this.userId) {
            this._status = 'valid';
          } else if (this.email.indexOf('@') < 0) {
            this._status = 'user-not-found';
          } else if (!EMAIL_REGEX.test(this.email)) {
            this._status = 'email-not-valid';
          } else {
            this._status = 'valid';
          }

          return this._status;
        }
      }, {
        key: "_handleToggleInvitation",
        value: function _handleToggleInvitation(e) {
          e.preventDefault();
          return this.emit('toggleInvitation', _objectSpread({
            email: this.email
          }, this.userId ? {
            name: this.name,
            thumbnail: this.thumbnail,
            userId: this.userId
          } : {}));
        }
      }]);

      return UserListItem;
    }(_metalComponent.default);

    exports.UserListItem = UserListItem;

    _metalSoy.default.register(UserListItem, _UserListItem.default);

    UserListItem.STATE = {
      _invited: _metalSoy.Config.bool().value(false),
      _status: _metalSoy.Config.string().value('valid'),
      addedUsers: _metalSoy.Config.array(_metalSoy.Config.shapeOf({
        email: _metalSoy.Config.string()
      })).value([]),
      email: _metalSoy.Config.string().required(),
      name: _metalSoy.Config.string(),
      query: _metalSoy.Config.string(),
      thumbnail: _metalSoy.Config.string(),
      userId: _metalSoy.Config.oneOfType([_metalSoy.Config.string(), _metalSoy.Config.number()])
    };
    var _default = UserListItem;
    exports.default = _default;
    //# sourceMappingURL=UserListItem.es.js.map
  }
});
//# sourceMappingURL=UserListItem.es.js.map